# titling-ps-alpha2.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1999-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import DaliSubprogram
import RealParameter
import TextParameter
import IntParameter

Class TitleSubprogram -superclass DaliSubprogram

TitleSubprogram instproc init {args} {
    eval $self next $args;

    # Set up inputs

    $self instvar input_id_list_;
    $self instvar input_info_;

    lappend input_id_list_ i1

    set input_info_(i1,spec) "";
    set input_info_(i1,trigger) 0;
    set input_info_(i1,buffertype) Uncompressed;
    set input_info_(i1,buffername) [new VidRep/Uncompressed];
    set input_info_(i1,decoder) "";

    # Set up outputs

    $self instvar output_id_list_;
    $self instvar output_info_;

    lappend output_id_list_ o1;

    set output_info_(o1,spec) "";
    set output_info_(o1,buffertype) Uncompressed;
    set output_info_(o1,buffername) [new VidRep/Uncompressed];
    set output_info_(o1,encoder) "";
    set output_info_(o1,format) JPEG;
    set output_info_(o1,vagent) "";

    # Set up which input will drive each output's synchronization
    $self set_ntp_reference i1 o1

    # Set up parameters

    $self instvar parameter_id_list_;
    $self instvar parameter_info_;

    lappend parameter_id_list_ text
    set pobj [new TextParameter];
    set parameter_info_(text,oname) $pobj;
    $pobj set "";

    lappend parameter_id_list_ xpos
    set pobj [new IntParameter];
    set parameter_info_(xpos,oname) $pobj;
    $pobj from 0
    $pobj to 320
    $pobj set 0

    lappend parameter_id_list_ ypos
    set pobj [new IntParameter];
    set parameter_info_(ypos,oname) $pobj;
    $pobj from 0
    $pobj to 240
    $pobj set 0

    lappend parameter_id_list_ back_lum
    set pobj [new IntParameter];
    set parameter_info_(back_lum,oname) $pobj;
    $pobj from 0;
    $pobj to 255;
    $pobj set 128;

    lappend parameter_id_list_ back_cr
    set pobj [new IntParameter];
    set parameter_info_(back_cr,oname) $pobj;
    $pobj from 0;
    $pobj to 255;
    $pobj set 128;

    lappend parameter_id_list_ back_cb
    set pobj [new IntParameter];
    set parameter_info_(back_cb,oname) $pobj;
    $pobj from 0;
    $pobj to 255;
    $pobj set 128;

    lappend parameter_id_list_ point_size;
    set pobj [new IntParameter];
    set parameter_info_(point_size,oname) $pobj;
    $pobj from 5
    $pobj to 40
    $pobj set 30

    lappend parameter_id_list_ font
    set pobj [new ExclusiveChoiceParameter];
    set parameter_info_(font,oname) $pobj;
    $pobj add "Times-Roman"
    $pobj add "Times-Bold"
    $pobj add "Times-Italic"
    $pobj add "Helvetica"
    $pobj add "Helvetica-Bold"
    $pobj add "Helvetica-Narrow"
    $pobj set "Times-Roman"

    lappend parameter_id_list_ back_alpha
    set pobj [new RealParameter];
    set parameter_info_(back_alpha,oname) $pobj;
    $pobj from 0.0
    $pobj to 1.0
    $pobj set 0.5

    lappend parameter_id_list_ master_alpha
    set pobj [new RealParameter];
    set parameter_info_(master_alpha,oname) $pobj;
    $pobj from 0.0
    $pobj to 1.0
    $pobj set 0.0

    $self instvar comm_obj_;
    $comm_obj_ setup;
}

TitleSubprogram instproc trigger {} {
    $self instvar comm_obj_;

    $self instvar parameter_id_list_;

    foreach p $parameter_id_list_ {
	if {![$comm_obj_  parameter_attr_has_value $p value]} {
	    return;
	}
    }

    $self instvar init_done_;
    $self instvar input_info_ output_info_

    $self instvar old_xpos_ old_ypos_ old_text_ old_sz_ old_font_
    $self instvar old_balpha_ old_malpha_;

    set in_frame $input_info_(i1,buffername);
    set out_frame $output_info_(o1,buffername);

    if {![info exists init_done_]} {
	# Stuff to do only the first time
	if {[$in_frame set w_] == 0} {
	    return;
	}
	$out_frame copy_geometry $in_frame;
	if {$output_info_(o1,format) == "JPEG"} {
	    $out_frame set h_subsample_ 2;
	    $out_frame set v_subsample_ 1;
	} else {
	    $out_frame set h_subsample_ 2;
	    $out_frame set v_subsample_ 2;
	}
	$out_frame allocate;

	set old_xpos_ "";
	set old_ypos_ "";
	set old_text_ "";
	set old_sz_ "";
	set old_font_ "";
	set old_balpha_ "";
	set old_malpha_ "";
	set init_done_ 1;
    }

    $self instvar parameter_info_;

    set xpos [$parameter_info_(xpos,oname) get];
    set ypos [$parameter_info_(ypos,oname) get];
    set text [$parameter_info_(text,oname) get];
    set sz [$parameter_info_(point_size,oname) get];
    set font [$parameter_info_(font,oname) get];
    set balpha [$parameter_info_(back_alpha,oname) get];
    set malpha [$parameter_info_(master_alpha,oname) get];
    set blum [$parameter_info_(back_lum,oname) get];
    set bcr [$parameter_info_(back_cr,oname) get];
    set bcb [$parameter_info_(back_cb,oname) get];

    $self instvar y_clip_ cr_clip_ cb_clip_;
    $self instvar text_mask_ inv_text_mask_;
    $self instvar alpha_text_mask_ alpha_inv_text_mask_;
    $self instvar subsamp_alpha_text_mask_ subsamp_alpha_inv_text_mask_;

    set recalc_alphas 0;

    if {$old_xpos_ != $xpos || $old_ypos_ != $ypos || $old_text_ != $text || $old_sz_ != $sz || $old_font_ != $font} {
	# Do changes associated with xpos, ypos and text

	if {($old_sz_ != $sz) || ($old_text_ != $text) || ($old_font_ != $font)} {

	    if {[info exists text_mask_]} {
		byte_free $text_mask_;
	    }
	    if {[info exists inv_text_mask_]} {
		byte_free $inv_text_mask_;
	    }
	    if {[info exists alpha_text_mask_]} {
		byte_free $alpha_text_mask_;
	    }
	    if {[info exists alpha_inv_text_mask_]} {
		byte_free $alpha_inv_text_mask_;
	    }
	    if {[info exists subsamp_alpha_text_mask_]} {
		byte_free $subsamp_alpha_text_mask_;
	    }
	    if {[info exists subsamp_alpha_inv_text_mask_]} {
		byte_free $subsamp_alpha_inv_text_mask_;
	    }

	    set text_mask_ [$self DrawString $text $sz $font];
	    set old_text_ $text;
	    set old_sz_ $sz;
	    set old_font_ $font;

	    set inv_text_mask_ [byte_new [byte_get_width $text_mask_] [byte_get_height $text_mask_]];
	    byte_not $text_mask_ $inv_text_mask_

	    set alpha_text_mask_ [byte_new [byte_get_width $text_mask_] [byte_get_height $text_mask_]];
	    set alpha_inv_text_mask_ [byte_new [byte_get_width $text_mask_] [byte_get_height $text_mask_]];

	    set subsamp_alpha_text_mask_ [byte_new [expr [byte_get_width $text_mask_] / [$out_frame set h_subsample_]] [expr [byte_get_height $text_mask_] / [$out_frame set v_subsample_]]];

	    set subsamp_alpha_inv_text_mask_ [byte_new [expr [byte_get_width $text_mask_] / [$out_frame set h_subsample_]] [expr [byte_get_height $text_mask_] / [$out_frame set v_subsample_]]];

	    set recalc_alphas 1;
	}

	set old_xpos_ $xpos;
	set old_ypos_ $ypos;

	set str_width [byte_get_width $text_mask_];
	set str_height [byte_get_height $text_mask_];

	set left $xpos;
	set right [expr $xpos + $str_width - 1];
	set top $ypos;
	set bottom [expr $ypos + $str_height - 1];

	if {$left < 0} {set left 0};
	if {$right > [$out_frame set w_]} {set right [$out_frame set w_]};
	if {$top < 0} {set top 0};
	if {$bottom > [$out_frame set h_]} {set bottom [$out_frame set h_]};

	if {[info exists y_clip_]} {
	    byte_free $y_clip_;
	    unset y_clip_;
	}
	if {[info exists cr_clip_]} {
	    byte_free $cr_clip_;
	    unset cr_clip_;
	}
	if {[info exists cb_clip_]} {
	    byte_free $cb_clip_;
	    unset cb_clip_;
	}

	set cwidth [expr $right - $left + 1];
	set cheight [expr $bottom - $top + 1];

	set y_clip_ [byte_clip [$out_frame get_lum_name] $left $top $cwidth $cheight];
	set cr_clip_ [byte_clip [$out_frame get_cr_name] [expr $left / [$out_frame set h_subsample_]] [expr $top / [$out_frame set v_subsample_]] [expr $cwidth / [$out_frame set h_subsample_]] [expr $cheight / [$out_frame set v_subsample_]]];
	set cb_clip_ [byte_clip [$out_frame get_cb_name] [expr $left / [$out_frame set h_subsample_]] [expr $top / [$out_frame set v_subsample_]] [expr $cwidth / [$out_frame set h_subsample_]] [expr $cheight / [$out_frame set v_subsample_]]];
    }

    if {$old_balpha_ != $balpha || $old_malpha_ != $malpha || $recalc_alphas == 1} {
	set old_balpha_ $balpha;
	set old_malpha_ $malpha;

	byte_scalar_mult $inv_text_mask_ $alpha_inv_text_mask_ [expr $balpha * $malpha];
	byte_scalar_add $alpha_inv_text_mask_ $alpha_inv_text_mask_ [expr int(((1.0 - $balpha) * $malpha * 255) + ((1.0 - $malpha) * 255))];

	byte_scalar_mult $text_mask_ $alpha_text_mask_ $malpha;
	byte_scalar_add $alpha_text_mask_ $alpha_text_mask_ [expr int(255 * (1.0 - $malpha))];

	if {[$out_frame set h_subsample_] == 2} {
	    if {[$out_frame set v_subsample_] == 2} {
		byte_shrink_2x2 $alpha_text_mask_ $subsamp_alpha_text_mask_;
		byte_shrink_2x2 $alpha_inv_text_mask_ $subsamp_alpha_inv_text_mask_;
	    } else {
		byte_shrink_2x1 $alpha_text_mask_ $subsamp_alpha_text_mask_;
		byte_shrink_2x1 $alpha_inv_text_mask_ $subsamp_alpha_inv_text_mask_;
	    }
	} else {
	    if {[$out_frame set v_subsample_] == 2} {
		byte_shrink_1x2 $alpha_text_mask_ $subsamp_alpha_text_mask_;
		byte_shrink_1x2 $alpha_inv_text_mask_ $subsamp_alpha_inv_text_mask_;
	    } else {
		byte_copy $alpha_text_mask_ $subsamp_alpha_text_mask_;
		byte_copy $alpha_inv_text_mask_ $subsamp_alpha_inv_text_mask_;
	    }
	}
    }

    byte_copy [$in_frame get_lum_name] [$out_frame get_lum_name];
    byte_copy [$in_frame get_cr_name] [$out_frame get_cr_name];
    byte_copy [$in_frame get_cb_name] [$out_frame get_cb_name];

    byte_set_with_alpha_mask $y_clip_ $alpha_inv_text_mask_ $blum;
    byte_set_with_alpha_mask $cr_clip_ $subsamp_alpha_inv_text_mask_ $bcr;
    byte_set_with_alpha_mask $cb_clip_ $subsamp_alpha_inv_text_mask_ $bcb;

    byte_set_with_alpha_mask $y_clip_ $alpha_text_mask_ 255
    byte_set_with_alpha_mask $cr_clip_ $subsamp_alpha_text_mask_ 128
    byte_set_with_alpha_mask $cb_clip_ $subsamp_alpha_text_mask_ 128

    $out_frame set ts_ [$in_frame set ts_];

    set encoder $output_info_(o1,encoder);

    if {$encoder != ""} {
	$encoder recv $out_frame;
    }

    $self send_completion_token

    [[[[$input_info_(i1,decoder) set agent_] set network_] set net_(0)] set dn_] recv_flush

}


TitleSubprogram instproc DrawString {str sz font} {
    $self instvar id_;

    set coord_file "gs_${id_}.out";
    set pgm_file "gs_${id_}.pgm";
    set cut_file "gs_${id_}_cut.pgm";

    exec rm -f $coord_file
    exec rm -f $pgm_file
    set gs_fp [open "| gs -q -sDEVICE=pgmraw -dTextAlphaBits=4 -dGraphicsAlphaBits=4 -sOutputFile=$pgm_file > $coord_file" w];

    puts $gs_fp "/$font findfont $sz scalefont setfont"
    puts $gs_fp "0 0 moveto"
    puts $gs_fp "($str) true charpath flattenpath pathbbox"
    puts $gs_fp "(\\ncoords\\n) print stack"
    puts $gs_fp "pop"
    puts $gs_fp "pop"
    puts $gs_fp "-1 mul"
    puts $gs_fp "2 1 roll"
    puts $gs_fp "-1 mul"
    puts $gs_fp "2 1 roll"
    puts $gs_fp "translate"
    puts $gs_fp "0 0 moveto"
    puts $gs_fp "($str) show"
    puts $gs_fp "showpage";
    close $gs_fp;

    set fp [open "$coord_file" r];
    set nline [gets $fp];
    while {$nline != "coords"} {
	set nline [gets $fp];
    }
    set y2 [gets $fp];
    set x2 [gets $fp];
    set y1 [gets $fp];
    set x1 [gets $fp];

    close $fp;

    set width [expr int($x2 - $x1 + 0.5)];
    set height [expr int($y2 - $y1 + 0.5)];

    exec rm -f $cut_file
    exec pnmcut 0 [expr -1 * $height] $width $height $pgm_file > $cut_file
    exec mv $cut_file $pgm_file

    set bs [bitstream_mmap_read_new $pgm_file];
    set bp [bitparser_new];
    bitparser_wrap $bp $bs;

    set hdr [pnm_hdr_new];

    pnm_hdr_parse $bp $hdr;

    set bimage [byte_new [pnm_hdr_get_width $hdr] [pnm_hdr_get_height $hdr]];
    pgm_parse $bp $bimage;

    bitparser_free $bp
    bitstream_mmap_read_free $bs
    pnm_hdr_free $hdr

    return $bimage
}

