# source-mega.tcl --
#
#       Used to tie-in SAP announcments with MeGa.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import AnnounceListenManager/AS/Client/MeGa

#FIXME making this class is a temporary hack
Class AnnounceListenManager/SAP/MeGa -superclass AnnounceListenManager/SAP

#
AnnounceListenManager/SAP/MeGa public init {s spec {mtu 2048} } {
    $self next $spec $mtu
    $self set s_ $s
}

#
AnnounceListenManager/SAP/MeGa private recv_announcement {args} {
    $self instvar s_
    eval $s_ recv $self $args
}

#FIXME
AnnounceListenManager/SAP/MeGa private incrnsrcs {args} {}
AnnounceListenManager/SAP/MeGa private sample_size {args} {}
AnnounceListenManager/SAP/MeGa private interval {args} { return 0 }


# Receives program announcements via SAP and uses the MeGa
# architecture to receive announcements through a proxy.  (See
# <a href=http://www.cs.berkeley.edu/~elan/mega/>Elan's MeGa page</a>
# for more info about MeGa...)
Class ProgramSource/SAP/MeGa -superclass ProgramSource/SAP

# Initializes a new object.  Arguments have the same meaning as
# for ProgramSource/SAP::init but there can be only a single address
# rather than a list of them.
ProgramSource/SAP/MeGa public init {ui addr} {
    # need to do these things before calling next constructor
    $self set name_ "MeGa Proxy: $addr"
    set addr [intoa [lookup_host_addr $addr]]
    set d [$self get_option cachedir]
    if {$d != ""} {
	$self set cache_ [file join $d $addr]
    }

    eval $self next $ui

    $self instvar app_
    set app_ [Application instance]

    $self instvar bw_
    set bw_ [$app_ get_option megaBW]
    # use 2% of capacity for sdp gateway
    set bw [expr 0.02 * $bw_]

    set spec "$addr/60000:10002/1"
    $app_ add_default megaStartupWait 60
    set sname sdp:0:0:IN:IP4:224.2.127.254
    set sspec 224.2.127.254/9875/127
    $app_ add_default megaCtrl $spec
    set rportspec 10000:10002

    $self instvar al_
    set loc [$self get_option serviceLocation]
    set al_ [new AnnounceListenManager/AS/Client/MeGa $self \
		 $spec $bw Nsdr sdp $sname $sspec $rportspec null $loc]
    $al_ start
}

# Used to set the name of the tag for this program source in the
# user interface.
ProgramSource/SAP/MeGa public name {} {
    return [$self set name_]
}

# Invoked by MeGa to tell the object it should listen for SAP
# messages on the address/port given by <i>spec</i>.
ProgramSource/SAP/MeGa public reset_spec {spec} {
    set l [split $spec /]

    $self instvar addr_ sport_ rport_ ttl_
    set addr_ [lindex $l 0]
    set ports [split [lindex $l 1] :]
    set sport_ [lindex $ports 0]
    set rport_ [lindex $ports 1]
    set ttl_ [lindex $l 3]

    $self instvar addrs_
    foreach a $addrs_ {
	delete $a
    }
    set addrs_ {}
    set s $addr_/$sport_:$rport_/$ttl_
    lappend addrs_ [new AnnounceListenManager/SAP/MeGa $self $s]
}

ProgramSource/SAP/MeGa public scopes {} {
    #FIXME
    return {}
}

#FIXME should this stuff be in AnnounceListenManager/MeGa/Client ?
ProgramSource/SAP/MeGa instproc have_network {} {
    $self instvar addr_
    return [info exists addr_]
}

ProgramSource/SAP/MeGa instproc session-addr {} {
    $self instvar addr_
    return $addr_
}

ProgramSource/SAP/MeGa instproc session-sport {} {
    $self instvar sport_
    return $sport_
}

ProgramSource/SAP/MeGa instproc session-rport {} {
    $self instvar rport_
    return $rport_
}

ProgramSource/SAP/MeGa instproc session-ttl {} {
    $self instvar ttl_
    return $ttl_
}

