# ui-mat.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import Playback Rec

# The user interface for the mat application.
Class MatUI

wm withdraw .

#
MatUI public init {} {
	$self next

	$self instvar module_

	set module_ [$self get_option module]
	toplevel .top
	$self build_ui .top
	$self reset
}

#
MatUI private build_ui { w } {

	# FIXME
	set vspec [$self get_option videoSpec]
	set aspec [$self get_option audioSpec]
	set mbspec [$self get_option mbSpec]
#	eval exec mash ../mash/bin/vic -X loopback=1 $vspec
#    	eval exec mash ../mash/bin/vat -X loopback=1 $aspec
	$self instvar vpid_ apid_ mbpid_
	set vpid_ [eval exec vic -X loopback=1 $vspec &]
    	set apid_ [eval exec vat -X loopback=1 $aspec &]
# Reset will start mb.
#    	set mbpid_ [eval exec mb -sa $mbspec &]

	bind $w <space> "$self advance_slide"

	frame $w.slide -relief sunken
	set c $w.slide.c
	$self instvar canvas_ image_
	set width [$self get_option slideWidth]
	set height [$self get_option slideHeight]
	canvas $c -height $height -width $width

	set canvas_ $c
	set image_ [image create photo -height $height -width $width]
	$image_ blank

	$c create image 0 0 -anchor nw -image $image_

	pack $c -fill both
	pack $w.slide -expand 1 -fill both

	global curtime
	set curtime 00:00:00

	frame $w.slider
	scale $w.slider.scale -orient horizontal -from 0 \
		-to [$self get_option ltsEnd] -command "$self goto"
	pack $w.slider.scale -expand 1 -fill x
	pack $w.slider -expand 1 -fill x

	frame $w.bot -relief ridge -borderwidth 2
	$self instvar buttons_
	set buttons_(record) \
		[button $w.bot.record -text Record -command "$self record"]
	label $w.bot.clock -textvariable curtime
	label $w.bot.title -text "MASH Authoring Tool v1.0"
	set buttons_(play) \
		[button $w.bot.play -text Play -command "$self play"]
	set buttons_(pause) \
		[button $w.bot.pause -text Pause -command "$self pause"]
	set buttons_(reset) \
		[button $w.bot.reset -text Reset -command "$self reset"]
	set buttons_(stop) \
		[button $w.bot.stop -text Stop -command "$self stop"]
	set buttons_(quit) \
		[button $w.bot.quit -text Quit -command "$self quit"]
	pack $w.bot.record $w.bot.pause $w.bot.reset $w.bot.play \
		$w.bot.stop -side left
	pack $w.bot.clock -side left -ipadx 10
	pack $w.bot.title -side left -fill x -expand 1
	pack $w.bot.quit -side right
	pack $w.bot -fill x -expand 1


	$buttons_(record) configure -state normal
	$buttons_(play) configure -state normal
	$buttons_(pause) configure -state disabled
	$buttons_(reset) configure -state disabled
	$buttons_(stop) configure -state disabled
}

#
MatUI private advance_slide {} {
	$self instvar image_ slidenum_ zero_ fd_ state_

	if { $state_ != "rec" } {
		return
	}
	set dir [$self get_option slideDir]

	set h [expr $slidenum_/100]
	set t [expr ($slidenum_ - 100*$h)/10]
	set u [expr $slidenum_ - 100*$h - 10*$t]

	set sname img$h$t$u.GIF
    	set f $dir/$sname
	if ![file exists $f] {
		puts stderr "mat: no such file $f"
		return
	}
	$image_ read $dir/$sname -format gif

	set prefix [$self get_option urlPrefix]
	set fname sld$h$t$u.htm
	puts $fd_ "[$self runtime] $prefix$fname"
	incr slidenum_
}

#
MatUI private record {} {
	$self instvar tid_ zero_ state_ buttons_ pause_time_ pause_start_ fd_ \
		module_


	set now [gettimeofday]
	if { $zero_ < 0 } {
		set zero_ $now
	}
	if { $pause_start_ > 0 } {
		set pause_time_ [expr $pause_time_ + $now - $pause_start_]
	}
	$self instvar rec_
	$rec_ start

	set archive [$self get_option archive]
	set fname $archive/$module_/[$self get_option slideOutputFile]
	set fd_ [open $fname w+]

	$buttons_(record) configure -state disabled
	$buttons_(play) configure -state disabled
#	$buttons_(pause) configure -state normal
	$buttons_(reset) configure -state disabled
	$buttons_(stop) configure -state normal

	set state_ rec
	set tid_ [after 1000 "$self advance_time"]
}

# FIXME This not done right yet
MatUI private pause {} {
	$self instvar tid_ state pause_start_ buttons_
	if { $running_ } {
		if [info exists tid_] {
			after cancel $tid_
		}
		set state_ pause
		$buttons_(record) configure -state normal
		$buttons_(pause) configure -state disabled
		set pause_start_ [gettimeofday]
	}
}

#
MatUI private reset {} {
	$self instvar zero_ slidenum_ fd_ state_ buttons_ tid_ pause_time_ \
		pause_start_ rec_ play_ module_

	if [info exists rec_] {
		delete $rec_
	}
	if [info exists play_] {
		delete $play_
	}
	set rec_ [new Rec $module_]
	set playmodule $module_
	append playmodule catalog
	set play_ [new Playback $playmodule]

	# FIXME Need to restart mb since the SRM state is confused.
	$self instvar mbpid_
	set mbspec [$self get_option mbSpec]
	if [info exists mbpid_] {
	    catch " exec kill -9 $mbpid_ "
	}
	set mbpid_ [exec mb -sa $mbspec &]

	set zero_ -1
	set pause_start_ -1
	set pause_time_ 0
	global curtime
	set curtime [$self format_time 0]
	set slidenum_ 1
	if [info exists fd_] {
		close $fd_
	}
	if [info exists tid_] {
		after cancel $tid_
	}
	set state_ reset
	$buttons_(record) configure -state normal
	$buttons_(pause) configure -state disabled
	$buttons_(stop) configure -state disabled
	$buttons_(reset) configure -state disabled
	$buttons_(play) configure -state normal

	$self instvar image_
	$image_ blank
}

#
MatUI private play {} {
	$self instvar play_ state_ image_ buttons_ zero_ pause_start_ \
		pause_time_
	set state_ play
	$image_ blank

	set now [gettimeofday]
	if { $zero_ < 0 } {
		set zero_ $now
	}
	if { $pause_start_ > 0 } {
		set pause_time_ [expr $pause_time_ + $now - $pause_start_]
	}
	set tid_ [after 1000 "$self advance_time"]

	$buttons_(record) configure -state disabled
	$buttons_(pause) configure -state disabled
	$buttons_(stop) configure -state normal
	$buttons_(reset) configure -state disabled
	$buttons_(play) configure -state disabled

	$play_ start $self
}

#
MatUI private stop {} {
	$self instvar fd_ buttons_ tid_ state_
	if [info exists fd_] {
		flush $fd_
		close $fd_
		unset fd_
	}
	if [info exists tid_] {
		after cancel $tid_
	}
	$self instvar rec_ play_
	if { $state_ == "rec" } {
		$rec_ stop
	} elseif { $state_ == "play" } {
		$play_ stop
	}
	set state_ stop
	$buttons_(record) configure -state disabled
	$buttons_(play) configure -state disabled
	$buttons_(pause) configure -state disabled
	$buttons_(reset) configure -state normal
	$buttons_(stop) configure -state disabled
}

#
MatUI private show { url } {
	# FIXME This all wrong.   This is simply a hack so that we
	# can playback previously stored presentations.
	$self instvar image_
	set u [lindex [split $url :] 1]
	set name [file rootname [file tail $u]]
	set t [split $name d]
	set num [lindex $t 1]
	$image_ read [file dirname $u]/img$num.GIF -format gif
}

#
MatUI private advance_time {} {
	global curtime
	set curtime [$self format_time [$self runtime]]

	$self instvar tid_
	set tid_ [after 1000 "$self advance_time"]
}

#
MatUI private runtime {} {
	$self instvar zero_ pause_time_

	return [expr int([gettimeofday] - $zero_ - $pause_time_ + 0.5)]
}

#
MatUI private format_time { sec } {

	set h [expr $sec/3600]
	set h0 [expr $h/10]
	set h1 [expr $h%10]

	set m [expr ($sec - $h*3600)/60]
	set m0 [expr $m/10]
	set m1 [expr $m%10]

	set s [expr $sec - $h*3600 - $m*60]
	set s0 [expr $s/10]
	set s1 [expr $s%10]

	return $h0$h1:$m0$m1:$s0$s1
}

#
MatUI private quit {} {
    	$self instvar vpid_ apid_ mbpid_
    	catch "exec kill -9 $vpid_ $apid_ $mbpid_"
	$self stop
	exit 0
}

#
MatUI private goto { t } {
	$self instvar rec_ play_ state_
	if { $state_ == "rec" } {
		$rec_ goto $t
	} elseif { $state_ == "play" } {
		$play_ goto $t
	}
}
