# prefs.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/applications/pathfinder/prefs.tcl,v 1.4 2002/02/03 04:22:06 lim Exp $


import WidgetClass Application


WidgetClass PathFinderPrefs -default {
	{ *background \#FFFFFF }
	{ *highlightBackground \#FFFFFF }
	{ *Button.borderWidth 1 }
	{ *Checkbutton.borderWidth 1 }
	{ *Radiobutton.borderWidth 1 }
	{ *font WidgetDefault }
}


PathFinderPrefs public default_prefs { } {
	$self tkvar nomulticast_ usemega_ mega_conn_ mega_conn_other_ \
			session_rate_ status_

	set nomulticast_ 0
	set usemega_ 0
	set mega_conn_ 128000
	set mega_conn_other_ 0
	set session_rate_ 64000

	set status_ "Reverting to default values...\n(Hit <Save> to save these\
			preferences permanently)"
}


PathFinderPrefs public load_prefs { } {
	$self tkvar nomulticast_ usemega_ mega_conn_ mega_conn_other_ \
			session_rate_ status_

	$self default_prefs
	set nomulticast_ [$self get_option pfl-nomulticast $nomulticast_]
	set usemega_ [$self get_option pfl-usemega $usemega_]
	set maxsbw [$self get_option pfl-maxsbw $mega_conn_]
	set list { 28800 128000 1500000 10000000 100000000 }
	if { [lsearch $list $maxsbw] != -1 } {
		set mega_conn_ $maxsbw
		set mega_conn_other_ 0
	} else {
		set mega_conn_ other
		set mega_conn_other_ $maxsbw
	}

	set session_rate_ [$self get_option pfl-srate $session_rate_]

	set status_ "Loaded preferences from disk..."
}


PathFinderPrefs private get_option { key default } {
	set value [$self next $key]
	if { $value == {} } { return $default } else { return $value }
}


PathFinderPrefs public save_prefs { } {
	$self tkvar nomulticast_ usemega_ mega_conn_ mega_conn_other_ \
			session_rate_ status_

	set o [$self options]
	set f [$o open_preferences pfinder-local]
	$o write_preference $f pfl-nomulticast $nomulticast_
	$o write_preference $f pfl-usemega $usemega_
	$o write_preference $f pfl-srate $session_rate_
	if { $mega_conn_ != "other" } { set maxsbw $mega_conn_ } \
			else { set maxsbw $mega_conn_other_ }
	$o write_preference $f pfl-maxsbw $maxsbw
	$o close_preferences $f

	# update our options database with the new values
	$o load_preferences pfinder-local

	set status_ "Saved preferences to disk..."
}


PathFinderPrefs public build_widget { path } {
	$self tkvar nomulticast_ usemega_ mega_conn_ mega_conn_other_ \
			session_rate_

	# load the preferences in from file
	set o [$self options]
	$o load_preferences pfinder-local

	# load the preferences into the tkvars
	$self load_prefs

	checkbutton $path.nomulticast -variable [$self tkvarname nomulticast_]\
			-text "Do not use multicast" -anchor w
	checkbutton $path.usemega -variable [$self tkvarname usemega_]\
			-text "Use Media Gateways to adapt session bandwidth" \
			-anchor w
	pack $path.nomulticast $path.usemega -side top -anchor w -fill x

	upvar \#0 [$self tkvarname usemega_] global_usemega_
	trace variable global_usemega_ w "$self change_usemega"

	upvar \#0 [$self tkvarname mega_conn_] global_mega_conn_
	trace variable global_mega_conn_ w "$self change_mega_conn"

	frame $path.mega -bd 2 -relief ridge
	label $path.crate -text "Connection Rate" -font \
			[WidgetClass widget_default -font] -anchor w
	pack $path.crate -fill x -side top -in $path.mega -anchor w

	frame $path.rb
	radiobutton $path.r0 -text "Modem (28.8 kb/s)" \
		-highlightthickness 0 \
		-variable [$self tkvarname mega_conn_] -value 28800 \
		-relief flat -anchor w -padx 10
	radiobutton $path.r1 -text "ISDN (128 kb/s)" \
		-highlightthickness 0 \
		-variable [$self tkvarname mega_conn_] -value 128000 \
		-relief flat -anchor w -padx 10
	radiobutton $path.r2 -text "T1 (1.5 Mb/s)" \
		-highlightthickness 0 \
		-variable [$self tkvarname mega_conn_] -value 1500000 \
		-relief flat -anchor w -padx 10
	radiobutton $path.r3 -text "10BaseT (10 Mb/s)" \
		-highlightthickness 0 \
		-variable [$self tkvarname mega_conn_] -value 10000000 \
		-relief flat -anchor w -padx 10
	radiobutton $path.r4 -text "100BaseT (100 Mb/s)" \
		-highlightthickness 0 \
		-variable [$self tkvarname mega_conn_] -value 100000000 \
		-relief flat -anchor w -padx 10
	frame $path.r5frame
	radiobutton $path.r5 -text "Other (bps)" \
		-highlightthickness 0 \
		-variable [$self tkvarname mega_conn_] -value other \
		-relief flat -anchor w -padx 10
	entry $path.other -width 10 -relief sunken \
		-textvariable [$self tkvarname mega_conn_other_]
	pack $path.r5 $path.other -side left -anchor w -in $path.r5frame
	foreach i { 0 1 2 3 4 } {
		pack $path.r$i -side top -anchor w -in $path.rb -fill x
	}
	pack $path.r5frame -side top -anchor w -in $path.rb
	pack $path.rb -side top -fill x -in $path.mega

	frame $path.bot
	label $path.sratelabel -text "Session rate (bps): "
	entry $path.srate -width 10 -relief sunken \
		-textvariable [$self tkvarname session_rate_]
	pack $path.sratelabel $path.srate -side left -fill x -in $path.bot
	pack $path.bot -side top -anchor w -fill x -in $path.mega

	pack $path.mega -side top -expand 1 -fill both -padx 5

	frame $path.buttons
	button $path.save  -text "Save" -command "$self save_prefs"
	button $path.reset -text "Reset" -command "$self load_prefs"
	button $path.default -text "Load defaults" -command \
			"$self default_prefs"
	pack $path.save $path.reset $path.default -in $path.buttons -side left\
			-anchor e
	pack $path.buttons -side top -anchor e -pady 5 -padx 2

	label $path.status -textvariable [$self tkvarname status_] -anchor w \
			-justify left
	pack $path.status -fill x -side top -anchor w

	$self change_usemega
}


PathFinderPrefs public change_usemega { args } {
	$self tkvar usemega_

	if $usemega_ {
		set state normal
		set fg [WidgetClass widget_default -foreground]
	} else {
		set state disabled
		set fg [WidgetClass widget_default -disabledforeground]
	}

	set path [$self info path]
	foreach i { 0 1 2 3 4 5 } {
		$path.r$i configure -state $state
	}

	$path.other configure -foreground $fg
	$path.srate configure -foreground $fg
	$path.sratelabel configure -foreground $fg

	$path.other configure -state $state
	$path.srate configure -state $state
}


PathFinderPrefs public change_mega_conn { args } {
	$self tkvar mega_conn_ mega_conn_other_ session_rate_
	if { $mega_conn_!="other" } { set session_rate_ [expr $mega_conn_/2] }\
			else { set session_rate_ [expr $mega_conn_other_/2] }

}

. configure -bg \#FFFFFF
PathFinderPrefs .f
pack .f -padx 5 -pady 5 -anchor nw
