/*
 * transmitter-synch.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1999-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "module.h"
#include "pktbuf.h"
#include "media-timer.h"
#include "rtp.h"

class SynchTransmitter : public PacketModule, public MediaTimer {
public:
  SynchTransmitter() {
    reset_flag_ = 0;
    last_in_seqno_ = -1;
    last_out_seqno_ = -1;
    last_in_ts_ = 0;
    last_out_ts_ = 0;
    srcid_ = 0;

    bind("srcid_", (unsigned int*)&srcid_);
  };
  virtual void recv(pktbuf *pb);
  virtual int command(int argc, const char*const* argv);

  int reset_flag_;
  u_int16_t last_in_seqno_;
  u_int16_t last_out_seqno_;
  u_int32_t last_out_ts_;
  u_int32_t last_in_ts_;
  u_int32_t srcid_;
};


static class SynchTransmitterClass : public TclClass {
public:
  SynchTransmitterClass() : TclClass("SynchTransmitter") {}
  TclObject *create(int argc, const char*const* argv) {
    return (new SynchTransmitter());
  }
} synch_transmitter_class_;

void
SynchTransmitter::recv(pktbuf *pb) {
  if (target_ == 0) {
    pb->release();
  }
  rtphdr *rh = (rtphdr *)pb->dp;

  if (reset_flag_) {
    last_in_seqno_ = ntohs(rh->rh_seqno) - 1;
    last_in_ts_ = 0;
    reset_flag_ = 0;
  }

  u_int16_t new_last_in = ntohs(rh->rh_seqno);

  rh->rh_seqno = htons(ntohs(rh->rh_seqno) - last_in_seqno_ + last_out_seqno_);
  last_out_seqno_ = ntohs(rh->rh_seqno);
  last_in_seqno_ = new_last_in;

  u_int32_t new_last_in_ts = ntohl(rh->rh_ts);

  if (new_last_in_ts == last_in_ts_) {
    rh->rh_ts = htonl(last_out_ts_);
  } else {
    rh->rh_ts = htonl(media_ts());
    last_out_ts_ = ntohl(rh->rh_ts);
  }
  last_in_ts_ = new_last_in_ts;

  rh->rh_ssrc = htonl(srcid_);

  target_->recv(pb);
}


int
SynchTransmitter::command(int argc, const char*const* argv)
{
  if (argc == 2) {
    if (strcmp(argv[1], "reset") == 0) {
      reset_flag_ = 1;
      return TCL_OK;
    }
  }
  return (PacketModule::command(argc, argv));
}

