/*
 * encoder.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1995-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

static const char rcsid[] =
    "@(#) $Header: /usr/mash/src/repository/mash/mash-1/audio/encoder.cc,v 1.10 2002/02/03 03:10:46 lim Exp $";

#include "config.h"
#include "rtp.h"
#include "encoder.h"
#include "pktbuf-rtp.h"

static class PCM_EncoderClass : public TclClass {
public:
	PCM_EncoderClass() : TclClass("Module/AudioEncoder/PCM") {}
	TclObject* create(int /* argc */, const char*const* /* argv */) {
		return (new PCM_Encoder);
	}
} pcm_encoder_class;

PCM_Encoder::PCM_Encoder() : pool_(0), last_ts_(0)
{
}

void PCM_Encoder::recv(Buffer* b)
{
	const AudioFrame* af = (AudioFrame*)b;
	encode(af->ts_, (u_int8_t*)af->bp_, af->len_);
}

void PCM_Encoder::encode(u_int32_t ts, u_int8_t* samples, int len)
{
	register int marker = (ts != last_ts_) ? htons(RTP_M) : 0;
	last_ts_ = ts + len;

	pktbuf* pb = pool_->alloc(ts, RTP_PT_PCMU);
	rtphdr* rh = (rtphdr*)pb->data;
	rh->rh_flags |= marker;
	memcpy((char*)(rh + 1), samples, len);
	pb->len = len + sizeof(*rh);
	target_->recv(pb);
}

int PCM_Encoder::command(int argc, const char*const* argv)
{
        if (argc == 3) {
                if (strcmp(argv[1], "buffer-pool") == 0) {
                        pool_ = (RTP_BufferPool*)TclObject::lookup(argv[2]);
                        return (TCL_OK);
                }
        }
        return (SourceModule::command(argc, argv));
}

static class NullAudioEncoderClass : public TclClass {
public:
	NullAudioEncoderClass() : TclClass("Module/AudioEncoder/Null") {}
	TclObject* create(int /* argc */, const char*const* /* argv */) {
		return (new NullAudioEncoder);
	}
} null_audio_encoder_class;

NullAudioEncoder::NullAudioEncoder()
  : PCM_Encoder()
{
}
