
.\" * OpenGGSN - Gateway GPRS Support Node
.\" * Copyright (C) 2002, 2003 Mondru AB.
.\" * Polish translation copyright (C) 2004 Marek akowicz <mazaczek@users.sourceforge.net>
.\" * 
.\" * The contents of this file may be used under the terms of the GNU
.\" * General Public License Version 2, provided that the above copyright
.\" * notice and this permission notice is included in all copies or
.\" * substantial portions of the software.
.\" * 
.\" * The initial developer of the original code is
.\" * Jens Jakobsen <jj@openggsn.org>
.\" * 
.\" * Contributor(s):
.\" * 
.\" * Translation to polish: Marek Zakowicz <mazak@debian.linux.org.pl>
.\" Manual page for ggsn
.\" SH section heading
.\" SS subsection heading
.\" LP paragraph
.\" IP indented paragraph
.\" TP hanging label

.TH sgsnemu 8 "Maj 2004"
.SH NAZWA
sgsnemu \- Emulator Wza Dostarczajcego Usug GPRS
.SH UYTKOWANIE
.B sgsnemu
\-\-help

.B sgsnemu
\-\-version

.B sgsnemu
[
.BI \-\-debug
] [
.BI \-\-conf " plik"
] [
.BI \-\-pidfile " plik"
] [
.BI \-\-statedir " plik" 
] [ 
.BI \-\-dns " host"
] [ 
.BI \-\-listen " host" 
] [
.BI \-\-remote " host"
] [
.BI \-\-contexts " liczba"
] [
.BI \-\-timelimit " sekundy" 
] [
.BI \-\-gtpversion " wersja"
] [
.BI \-\-apn " apn"
] [
.BI \-\-selmode " tryb"
] [
.BI \-\-imsi " imsi"
] [
.BI \-\-nsapi " nsapi"
] [
.BI \-\-msisdn " msisdn"
] [
.BI \-\-qos " qos"
] [
.BI \-\-charging " opata"
] [
.BI \-\-uid " uid"
] [
.BI \-\-pwd " pwd"
] [
.BI \-\-createif
] [
.BI \-\-net " sie" 
] [
.BI \-\-defaultroute
] [
.BI \-\-ipup " skrypt" 
] [
.BI \-\-ipdown " skrypt" 
] [
.BI \-\-pinghost " host"
] [
.BI \-\-pingrate " liczba"
] [
.BI \-\-pingsize " liczba"
] [
.BI \-\-pingcount " liczba"
]
.SH OPIS
.B sgsnemu
jest czci projektu
.B OpenGGSN
i implementuje emulator wza dostarczajcego usug GPRS (SGSN).
Moe on by wykorzystywany zarwno do testowania wzw GGSN,
jak rdzenia sieci GRPS, czy pocze odwiedzajcych. 

Funkcjonalno i protokoy GPRS zostay ustandaryzowane w ramach projektu 
Third Generation Partnership Project (3GPP).
Wedug specyfikacji 3GPP, SGSN posiada kilka interfejsw.
.B sgsnemu
implementuje interfejs Gn/Gp, ktry jest wykorzystywany w kierunku
wzw GGSN.

Interfejs Gn/Gp moe by postrzegany jako cze nadrzdne wza SGSN.
Jest ono wykorzystywane do komunikacji z wzem GGSN, ktry zazwyczaj jest
podczony do Internetu.
Interfejs Gn/Gp wykorzystuje protok tunelowania GPRS (GTP).
Pakiety uytkownika (zazwyczaj pakiety IP) s tunelowane za porednictwem protokou GTP,
ktry z kolei wykorzystuje protok UDP nad IP.


.B sgsnemu 
ustanawia pewn liczb pocze do GGSN.
Wewntrzny ping transmituje dania ICMP poprzez ju ustanowione poczenia.
Alternatywnie, moe by utworzony lokalny interfejs sieciowy.
W tym przypadku
.B sgsnemu
przekazuje pakiety pomidzy lokalnym interfejsem sieciowym i poczeniami
ustanowionymi na interfejsie Gn/Gp.

.B sgsnemu
wykorzystuje sterownik
.B TUN/TAP
jako interfejs lokalny.  Interfejs sieci tun jest ustanawiany dla kadego
poczenia zestawianego z wzem GGSN.
Bdy wystpujce podczas pracy programu s raportowane z wykorzystaniem 
.B syslogd (8).

.SH OPCJE
.TP
.BI --help
Wywietla pomoc i na tym koczy wykonanie programu.
  
.TP
.BI --version
Wywietla pomoc i na tym koczy wykonanie programu.
 
.TP
.BI --debug
Uruchamia w trybie usuwania bdw (domylnie wyczone).
  
.TP
.BI --conf " plik"
Odczytuje konfiguracj z
.I pliku
,ktrego kada linia odpowiada jednej opcji
linii polece pozbawionej przedrostka '--'.  Opcje podane w linii polece
nadpisuj opcje podane w pliku konfiguracyjnym.
 
.TP
.BI --pidfile " plik"
Nazwa
.I pliku
z identyfikatorem procesu (domylnie ./sgsnemu.pid)
  
.TP
.BI --statedir " cieka"
.I cieka
do katalogu z trwaymi (nie ulotnymi) danymi (domylnie ./)

.TP
.BI --dns " host"
Serwer DNS wykorzystywany do zapyta APN.
Jeli parametr zosta pominity, wykorzystywana jest domylna, systemowa konfiguracja DNS.

.TP
.BI --listen " host"
Lokalny adres IP, ktry zostanie uyty do nasuchu przez interfejs Gn/Gp.
Ta opcja musi zosta podana.
Z przyczyn bezpieczestwa nie moe by wykorzystany INADDR_ANY.

.TP
.BI --remote " host"
.I Host
z wzem GGSN wykorzystywanym do pocze.  Jeli DNS jest prawidowo skonfigurowany
to powinno by moliwe podanie nazwy punktu dostpowego (APN) jako nazwy zdalnego hosta.

.TP
.BI --contexts " liczba"
Liczba ustanawianych kontekstw (domylnie = 1).  W przypadku wielu kontekstw
pierwszy kontekst jest ustanawiany z wykorzystaniem imsi + 0 i msidn + 0.
Drugi kontekst jest ustanawiany z wykorzystaniem imsi + 1 i msidn +1.
Trzeci ...

.TP
.BI --timelimit " sekundy"
Koczy wykonanie
.b sgsnemu
po upywie podanej liczy \fIsekund\fP.
W przypadku wykorzystywania opcji ping mona zakoczy
.B sgsnemu
po wyaniu
.B --pingcount
pakietw.  

.TP
.BI --gtpversion " wersja"
.I wersja
protokou GTP wykorzystywana przy ustanawianiu kontekstw (domylnie = 1).
Jeli nie jest moliwe ustanowienie kontekstu GTPw1
.B sgsnemu
powtrzy danie wykorzystujc GTPw0.
  
.TP
.BI --apn " apn"
.I apn
wykorzystywany przy czeniu si z wzem GGSN (domylnie = internet).
APN jest akronimem angielskich sw Access Point Name.

.TP
.BI --selmode " tryb"
Tryb wyboru wykorzystywany w komunikacji z wzem GGSN (domylnie = 0x01).
Jako tryby wyboru mog by wykorzystane nastpujce kody:
0: MS lub sie dostarczana przez APN, subskrypcja zweryfikowana,
1: MS dostarczany przez APN, subskrypcja nie zweryfikowana,
2: sie dostarczana przez APN, subskrypcja nie zweryfikowana.

.TP
.BI --imsi " imsi"
.I imsi
wykorzystywane w komunikacji z wzem GGSN (domylnie = 240010123456789).
IMSI jest akronimem angielskich sw International Mobile Subscriber Identity.
IMSI musi skada si z dokadnie 15 cyfr.  Porwnaj z opcj
.I contexts
by zobaczy wykorzystanie 
.I imsi
w przypadku wielu kontekstw.

.TP
.BI --nsapi " nsapi"
.I nsapi
wykorzystywane w komunikacji z wzem GGSN (domylnie = 0).
Warto musi by pomidzy 0, a 15.

.TP
.BI --msisdn " msisdn"
.I msisdn
wykorzystywane w komunikacji z wzem GGSN (domylnie = 46702123456).
MSISDN jest akronimem angielskich sw International Mobile Integrated Services Digital Network.
W istocie jest numerem telefonu zapisanym w midzynarodowym formacie bez wiodcych 00 lub 011.
Porwnaj z opcj
.I contexts
by zobaczy wykorzystanie 
.I msisdn
w przypadku wielu kontekstw.

.TP
.BI --qos " qos"
.I qos
wykorzystywany w komunikacji z wzem GGSN (domylnie = 0x0b921f).
QoS jest akronimem angielskich sw Quality of Service.
Format tego parametru zosta okrelony na podstawie specyfikacji 3GPP 09.60.

.TP
.BI --charging " opata"
Charakterystyka rozliczania wykorzystywana w komunikacji z wzem GGSN
(domylnie = 0x0800).  0x0800 = normalna, 0x0400 = przedpata,
0x0200 = paska rata, 0x0100 = rozliczanie dynamiczne.
Format pola zosta opisany w specyfikacji 3GPP 32.015.

.TP
.BI --uid " uid"
Identyfikator uytkownika wysyany do GGSN jako opcja konfiguracyjna protokou.

.TP
.BI --pwd " haso"
Identyfikator wysyane do GGSN jako opcja konfiguracyjna protokou.

.TP
.BI --createif
Tworzy lokalny interfejs tun, wykorzystywany dla
przesyania pakietw do i z interfejsu Gn/Gp.
Naley zaznaczy, e interfejs Gn/Gp zazwyczaj jest kierowany
do Internetu przez GGSN.  Tylko jeden interfejs moe by utworzony, chocia
wiele kontekstw moe zosta ustanowionych.
Interfejs moe by podany dla kadego kontekstu jako adres IP, lub moe by
okrelony za pomoc opcji
.I net.

.TP
.BI --net " sie"
Adres sieci lokalnego interfejsu.
Opcja
.I net
jest poprawna tylko wtedy, gdy zostaa wykorzystana opcja
.I createif.
Warto parametru
.I net
jest podawana w formacie cidr (sie/maska).  Jeli opcja
.I net
zostanie pominita, adres IP jest rezerwowany dla kadego ustanawianego kontekstu.

.TP
.BI --defaultroute
Definiuje domylne trasowanie przez lokalny interfejs tun.

.TP
.BI --ipup " skrypt"
Skrypt wykonywany po aktywacji interfejsu Gi w sieci tun.
Skrypt jest uruchamiany z nastpujcymi parametrami <nazwa urzdzenia> <adres ip>.
  
.TP
.BI --ipdown " skrypt"
Skrypt wykonywany po wyczeniu interfejsu Gi w sieci tun.
Skrypt jest uruchamiany z nastpujcymi parametrami <nazwa urzdzenia> <adres ip>.
  
.TP
.BI --pinghost " host"
Powoduje wysyanie pakietw ICMP do urzdzenia
.I host
poprzez interfejs Gn/Gp.  Statystyki pocze s raportowane w formie
bardzo zblionej do wyjcia oryginalnego programu ping.  Moesz wykorzysta
to udogodnienie do testowania wydajnoci GGSN.

.TP
.BI --pingrate " liczba"
Ilo da ICMP generowanych w przecigu sekundy (domylnie = 1).

.TP
.BI --pingsize " liczba"
Rozmiar generowanych da ICMP wyraony w oktetach (domylnie = 56).


.TP
.BI --pingcount " liczba"
Oczekiwana ilo wygenerowanych da ICMP (domylnie  = 0).
Warto 0 (zero) oznacza wielko nieograniczon.

.TP
.BI --pingquiet
Wycza wypisywanie informacji o otrzymanych pakietach (domylnie pakiety s wypisywane).
Jest to cakiem przydatne dla duych iloci pakietw ICMP generowanych w przecigu sekundy
(porwnaj z opcj pingrate).

.SH PLIKI
.I sgsnemu.conf
.RS
Plik konfiguracyjny dla
.B sgsnemu.
.RE
.I .sgsnemu.pid
.RS
Plik zawierajcy identyfikator procesu.
.RE
.I ./
.RS
Katalog przechowujcy trwae (nie ulotne) dane.
.RE

.SH BDY
Zgaszaj bdy na list ledzenia bdw OpenGGSN
.I http://sourceforge.net/projects/sgsnemu/


.SH "ZOBACZ TAKE"
.BR ggsn (8), 
.BR syslog (8)

.SH UWAGI
.LP

Oprcz dugich, udokumentowanych w tym podrczniku, opcji
.B sgsnemu
wspiera rwnie pewn liczb krtkich opcji o tej samej funkcjonalnoci.
Wywoaj 
.B sgsnemu --help
by uzyska pen list dostpnych opcji.

Sterownik TUN/TAP jest wymagany dla poprawnego dziaania
.B sgsnemu. 
Dla jder linuksa pniejszych ni 2.4.7 sterownik TUN/TAP jest zawarty w jdrze,
chocia w typowej sytuacji musi by adowany oddzielnie za pomoc
.B modprobe tun.
Aby adowa automatycznie naley do pliku
.B /etc/modules.conf.
doda lini  
.B alias char-major-10-200 tun
Aby uzyska informacje o innych platformach zobacz stron
.I http://vtun.sourceforge.net/tun/
opisujc jak zainstalowa i skonfigurowa sterownik tun.

.B ggsn 
wykorzystuje protok tunelowania GPRS (GTP) wyspecyfikowany przez 
Third Generation Partnership Project (3GPP). Specyfikacje protokow 3GPP
mog by znalezione na
.I http://www.3gpp.org

.SH COPYRIGHT

Copyright (C) 2002, 2003, 2004 by Mondru AB.

Zawarto tego pliku moe by wykorzystywana stosownie do terminw
Oglnej, Publicznej Licencji (GPL) GNU w wersji 2 dostarczonej wraz
z niniejsz uwag o prawach autorskich zawart we wszystkich kopiach
i istotnych fragmentach oprogramowania.

.SH AUTORZY
Jens Jakobsen <jj@openggsn.org>

.SH TUMACZENIE
Polish translation copyright (C) 2004 Marek akowicz <mazaczek@users.sourceforge.net>

Tumaczenie jest chronione prawami autorskimi.
Dozwolone jest korzystanie, rozprowadzanie i modyfikacja na zasadach licencji GNU GPL 2.
