//
// Search.php javascript
//

// Any characters mentioned in escapeChars
// will be escaped by specifying the escapeChar
function escapeChars(inval, escapeChars)
{
	var retval='';
	for (var i=0; i<inval.length; i++)
	{
		if(escapeChars.indexOf(inval.charAt(i))!=-1)
			retval = retval + '\\' + inval.charAt(i);
		else
			retval = retval + inval.charAt(i);
	}
	return retval;
}

// Defines the Attribute javascript object.
function LookupAttribute(type, value, text)
{
	this.type = type;
	this.value = value;
	this.text = text;
}

// Defines the Item Type javascript object.
function ItemType(type, category_attribute_type)
{
	this.type = type;
	this.category_attribute_type = category_attribute_type;
}

//
// This function will populate the selectObject with the
// records from the array that match the type.
// doUniqueOnly parameter if equal to true will populate the list
// with unique elements only.  If false, the list will be empty
// except for default.
//
function populateList(type, selectObject, LookupArray, doUniqueIfTypeEmpty, emptyOptionValue, doEscapeValue)
{
	// This works because we keep setting [0] to null,
	// and the positions of the options keep adjusting.
	if(selectObject.options.length)
	{
		var length = selectObject.options.length;
		for(var i=0; i<length; i++)
			selectObject.options[0] = null;
	}

	// Now repopulate.
	selectObject.options[0] = new Option(emptyOptionValue, "");
	var j=1;
	
	if(type.length>0 || doUniqueIfTypeEmpty)
	{
		for (var i=0; i<LookupArray.length; i++)
		{
			if( (type.length>0 && LookupArray[i].type == type) ||
					(type.length==0 && doUniqueIfTypeEmpty && indexOfLookupValue(selectObject.options, LookupArray[i].value)==-1))
			{
				// Escape value if requested.
				if(doEscapeValue){
					selectObject.options[j] = new Option(LookupArray[i].text, escapeChars(LookupArray[i].value, '_'));
				}else{
					selectObject.options[j] = new Option(LookupArray[i].text, LookupArray[i].value);
				}
				j++;
			}
		}
	}

	// Select ALL option.
	selectObject.options[0].selected = true;
}

function get_category_type(s_item_type, ItemTypes)
{
	for (var i=0; i<ItemTypes.length; i++)
	{
		if(ItemTypes[i].type == s_item_type)
			return ItemTypes[i].category_attribute_type;
	}
	return "";
}

//
// Will return index of value if found, otherwise -1
//
function indexOfLookupValue(SelectOptions, value)
{
	for (var i=0; i<SelectOptions.length; i++)
	{
		if(SelectOptions[i].value == value)
			return i;
	}
	return -1;
}