<?php
/* 	OpenDb - Open Lending Database Project
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// This php file contains functions for updating item records.
include_once("./functions/function.php");
include_once("./functions/item_attribute.php");
include_once("./functions/item_type.php");
include_once("./functions/theme.php");
include_once("./functions/utils.php");
include_once("./functions/datetime.php");
include_once("./functions/status_type.php");
include_once("./functions/BooleanParser.class.inc");

/**
	Will check that the $uid has an item_instance for item_id.  If instance_no specified,
	will check that the user owns the specified instance, otherwise this function is
	only checking that the $uid owns at least one instance of the item.
*/	
function is_user_owner_of_item($item_id, $instance_no, $uid)
{
	$query = "SELECT 'x' FROM item_instance WHERE item_id = '$item_id' AND owner_id = '$uid' ";
	if(is_numeric($instance_no))
		$query .= " AND instance_no = '$instance_no' ";

	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		mysql_free_result($result);
		// The very fact that at least one row was returned indicates that owner
		// has at least one instance of item.
		return TRUE;
	}

	//else
	return FALSE;
}

function is_exists_child_item_with_diff_item_type_to_parent($item_id, $s_item_type)
{
	$query = "SELECT 'x' FROM item WHERE parent_id = '$item_id' AND s_item_type <> '$s_item_type' ";

	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		mysql_free_result($result);
		return TRUE;
	}

	//else
	return FALSE;
}

/**
*/
function fetch_item_owner_id($item_id, $instance_no)
{
	$query = "SELECT owner_id FROM item_instance WHERE item_id = '$item_id' AND instance_no = '$instance_no'";
	$result = run_opendb_query($query);
	if ($result && mysql_num_rows($result)>0)
	{
		$found = mysql_fetch_array($result, MYSQL_ASSOC);
		if ($found)
		{
			mysql_free_result($result);
			return $found['owner_id'];
		}
	}
	//else
	return FALSE;	
}

function fetch_item_s_status_type($item_id, $instance_no)
{
	$query = "SELECT s_status_type FROM item_instance WHERE item_id = '$item_id' AND instance_no = '$instance_no'";
	$result = run_opendb_query($query);
	if ($result && mysql_num_rows($result)>0)
	{
		$found = mysql_fetch_array($result, MYSQL_ASSOC);
		if ($found)
		{
			mysql_free_result($result);
			return $found['s_status_type'];
		}
	}
	//else
	return FALSE;	
}

/**
	Returns a count of items stored in the database, or false if none found.
	NOTE: If $s_item_type is specified, only the given $s_item_type is counted (otherwise all)
*/
function fetch_item_instance_cnt($s_item_type = NULL)
{
	global $HTTP_SESSION_VARS;
	
	$query = "SELECT count(ii.item_id) as count ";
	$from = "FROM item_instance ii, s_status_type sst, user u ";
	$where = "WHERE u.user_id = ii.owner_id AND LENGTH(IFNULL(u.pwd,''))>0 AND sst.s_status_type = ii.s_status_type ";
			
	if($s_item_type)
	{
		$from .= ",item i";
		$where .= "AND i.id = ii.item_id AND i.s_item_type='".$s_item_type."' ";
	}
	
	// Restrict certain status types, to specified user types.
	$user_type_r = get_min_user_type_r($HTTP_SESSION_VARS['user_type']);
	if(is_not_empty_array($user_type_r))
	{
		$where .= "AND ( ii.owner_id = '".$HTTP_SESSION_VARS['user_id']."' OR ".
				" LENGTH(IFNULL(sst.min_display_user_type,'')) = 0 OR ".
				" sst.min_display_user_type IN(".format_sql_in_clause($user_type_r).") ) ";
	}
	
	$query .= "$from $where";
	
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		$found = mysql_fetch_array($result, MYSQL_ASSOC);
		mysql_free_result($result);
		if ($found!== FALSE)
			return $found['count'];
	}

	//else
	return FALSE;
}

/**
	Returns resultset of child items for the particular item_id
*/
function fetch_child_item_rs($item_id)
{
	// so that both resultset use item_id for the item.id or item_instance.item_id!!!
	$query = "SELECT id as item_id, title, s_item_type, category FROM item WHERE parent_id='".$item_id."' order by id ASC";
	
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
		return $result;
	else	
		return FALSE;
}

/**
	Returns resultset of item_instance's for the particular item_id
*/
function fetch_item_instance_rs($item_id, $owner_id)
{
	global $HTTP_SESSION_VARS;

	// so that both resultset use item_id for the item.id or item_instance.item_id!!!
	$query = "SELECT ii.item_id, ii.instance_no, ii.owner_id, ii.borrow_duration, ii.s_status_type, ii.status_comment ".
			" FROM item_instance ii, s_status_type sst, user u".
			" WHERE u.user_id = ii.owner_id AND LENGTH(IFNULL(u.pwd,''))>0 AND sst.s_status_type = ii.s_status_type AND ii.item_id='".$item_id."' ".(strlen($owner_id)>0?"AND ii.owner_id = '$owner_id'":"");
	
	// Restrict certain status types, to specified user types.
	$user_type_r = get_min_user_type_r($HTTP_SESSION_VARS['user_type']);
	if(is_not_empty_array($user_type_r))
	{
		$query .= " AND ( ii.owner_id = '".$HTTP_SESSION_VARS['user_id']."' OR ".
				" LENGTH(IFNULL(sst.min_display_user_type,'')) = 0 OR ".
				" sst.min_display_user_type IN(".format_sql_in_clause($user_type_r).") ) ";
	}
	
	$query .= " order by ii.instance_no	";
	
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
		return $result;
	else	
		return FALSE;
}

/**
	Returns a count of items owned by the specified owner_id, or FALSE if no records.
	Assumes this will NOT be called for INACTIVE users, if being called from Statistics
	
	NOTE: If $s_item_type is specified, only the given s_item_type is counted (otherwise all)
	
*/
function fetch_owner_item_cnt($owner_id, $s_item_type = NULL)
{
	global $HTTP_SESSION_VARS;
	
	$query = "SELECT count(ii.item_id) as count ";
	$from = "FROM item_instance ii, s_status_type sst ";
	$where = "WHERE sst.s_status_type = ii.s_status_type ";
			
	if($s_item_type)
	{
		$from .= ",item i";
		$where .= "AND i.id = ii.item_id AND i.s_item_type='".$s_item_type."' ";
	}
	$where .= "AND ii.owner_id = '$owner_id' "; 
	
	// Restrict certain status types, to specified user types.
	$user_type_r = get_min_user_type_r($HTTP_SESSION_VARS['user_type']);
	if(is_not_empty_array($user_type_r))
	{
		$where .= "AND ( ii.owner_id = '".$HTTP_SESSION_VARS['user_id']."' OR ".
				" LENGTH(IFNULL(sst.min_display_user_type,'')) = 0 OR ".
				" sst.min_display_user_type IN(".format_sql_in_clause($user_type_r).") ) ";
	}
	
	$query .= "$from $where";
	
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		$found = mysql_fetch_array($result, MYSQL_ASSOC);
		mysql_free_result($result);
		if ($found!== FALSE)
			return $found['count'];
	}

	//else
	return FALSE;
}

/*
* 	We do not know which s_status_type's the $HTTP_SESSION_VARS['user_type']
* 	can have access to so we include a join to s_status_type to hide any
* 	items with a s_status_type the current user should not see.
*/
function fetch_owner_s_status_type_item_cnt($owner_id, $s_status_type)
{
	global $HTTP_SESSION_VARS;
	
	$query = "SELECT count(ii.item_id) as count ".
			"FROM item_instance ii, s_status_type sst ".
			"WHERE sst.s_status_type = ii.s_status_type AND ii.owner_id='".$owner_id."' AND ii.s_status_type = '$s_status_type' ";

	// Restrict certain status types, to specified user types.
	$user_type_r = get_min_user_type_r($HTTP_SESSION_VARS['user_type']);
	if(is_not_empty_array($user_type_r))
	{
		$query .= "AND ( ii.owner_id = '".$HTTP_SESSION_VARS['user_id']."' OR ".
				" LENGTH(IFNULL(sst.min_display_user_type,'')) = 0 OR ".
				" sst.min_display_user_type IN(".format_sql_in_clause($user_type_r).") ) ";
	}
	
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		$found = mysql_fetch_array($result, MYSQL_ASSOC);
		mysql_free_result($result);
		if ($found !== FALSE)
			return $found['count'];
	}

	//else
	return FALSE;
}

/**
	Returns a count of child items for $item_id
*/
function fetch_child_item_cnt($item_id)
{
	$query = "SELECT count(id) as count FROM item WHERE parent_id ='".$item_id."'";
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		$found = mysql_fetch_array($result, MYSQL_ASSOC);
		mysql_free_result($result);
		if ($found !== FALSE)
			return $found['count'];
	}

	//else
	return FALSE;
}

/**
	Returns a count of items in the specified $s_item_type category, or FALSE if no records.
	NOTE: If $s_item_type is specified, only the given s_item_type is counted (otherwise all)
*/
function fetch_category_item_cnt($category, $s_item_type = NULL)
{
	global $HTTP_SESSION_VARS;
	
	$query = "SELECT count(ii.item_id) as count ".
			"FROM item i,item_instance ii, s_status_type sst, user u ".
			"WHERE u.user_id = ii.owner_id AND LENGTH(IFNULL(u.pwd,''))>0 AND sst.s_status_type = ii.s_status_type AND i.id = ii.item_id AND i.parent_id IS NULL AND i.category like '%".$category."%'";
	
	if($s_item_type)
		$query .= " AND s_item_type='".$s_item_type."'";
	
	// Restrict certain status types, to specified user types.
	$user_type_r = get_min_user_type_r($HTTP_SESSION_VARS['user_type']);
	if(is_not_empty_array($user_type_r))
	{
		$where .= "AND ( ii.owner_id = '".$HTTP_SESSION_VARS['user_id']."' OR ".
				" LENGTH(IFNULL(sst.min_display_user_type,'')) = 0 OR ".
				" sst.min_display_user_type IN(".format_sql_in_clause($user_type_r).") ) ";
	}
	
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		$found = mysql_fetch_array($result, MYSQL_ASSOC);
		mysql_free_result($result);
		if ($found!== FALSE)
			return $found['count'];
	}

	//else
	return FALSE;
}

/*
* Returns a list of items owned by the specified owner.
* item_id,instance_no,title
* 
* Note: Used exclusively in User Admin.  This we can restrict
* set returned, to only those records which are accessible to
* the administrator.
*/
function fetch_owner_item_id_and_title_rs($owner_id)
{
	$query = "SELECT ii.item_id, ii.instance_no, i.title FROM item i, item_instance ii WHERE i.id = ii.item_id AND parent_id IS NULL AND ii.owner_id='".$owner_id."' "; 
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
		return $result;
	else
		return FALSE;
}

//
// Returns an associative array for a single item.
//id,owner_id,title,category,s_item_type
//
function fetch_item_instance_r($item_id, $instance_no)
{
	$query = "SELECT ii.item_id, ii.instance_no, ii.s_status_type, ii.status_comment, ii.borrow_duration, i.parent_id, ii.owner_id, i.title, i.category, i.s_item_type FROM item i,item_instance ii WHERE i.id = ii.item_id AND i.id='".$item_id."' AND ii.instance_no = '".$instance_no."'";
	
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		$found = mysql_fetch_array($result, MYSQL_ASSOC);
		mysql_free_result($result);
		return $found;
	}
	else
		return FALSE;
}

function fetch_item_r($item_id)
{
	$query = "SELECT id as item_id, parent_id, title, category, s_item_type FROM item WHERE id='".$item_id."'";
	
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		$found = mysql_fetch_array($result, MYSQL_ASSOC);
		mysql_free_result($result);
		return $found;
	}
	else
		return FALSE;
}

//
// Returns an associative array for a single item.
//id,owner_id,title,category,s_item_type
//
function fetch_child_item_r($item_id)
{
	return fetch_item_r($item_id);
}

/**
	Return the item title.
*/
function fetch_item_title($item_id)
{
	// Only load previous record if edit.
	$query = "SELECT title FROM item WHERE id='".$item_id."'"; 
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		$found = mysql_fetch_array($result, MYSQL_ASSOC);
		mysql_free_result($result);
		return $found['title'];
	}
	else
		return FALSE;
}

//
// Return the item title.
//
function fetch_item_type($item_id)
{
	// Only load previous record if edit.
	$query = "SELECT s_item_type FROM item WHERE id='".$item_id."'"; 
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		$found = mysql_fetch_array($result, MYSQL_ASSOC);
		mysql_free_result($result);
		return $found['s_item_type'];
	}
	else
		return FALSE;
}

/**
	Will ascertain whether an item already exists with the same information:
		title, s_item_type, parent_id
	OR
		title, s_item_type, owner_id		
*/
function is_exists_title($title, $s_item_type, $owner_id=NULL, $parent_id=NULL)
{
	global $HTTP_SESSION_VARS;
	
	// In this case we assume the parent id is visible and accessible to the 
	// current user, because otherwise validation checks would not have allowed
	// the user to come this far.
	if(strlen($parent_id)>0)
	{
		$query = "SELECT 'x' FROM item i ".
	    		"WHERE i.title = '".addslashes($title)."' AND ".
				"i.s_item_type = '".$s_item_type."' AND ".
				"i.parent_id = '".$parent_id."'";
	}
	else
	{
		$query = "SELECT 'x' FROM item i,item_instance ii, s_status_type sst, user u ".
    			"WHERE i.id = ii.item_id AND ".
				"u.user_id = ii.owner_id AND ".
				"LENGTH(IFNULL(u.pwd,''))>0 AND ".
				"sst.s_status_type = ii.s_status_type AND ".
				"i.title = '".addslashes($title)."' AND ".
            	"i.s_item_type = '".$s_item_type."' AND ".
				" i.parent_id IS NULL ";
				
		// Restrict certain status types, to specified user types.
		$user_type_r = get_min_user_type_r($HTTP_SESSION_VARS['user_type']);
		if(is_not_empty_array($user_type_r))
		{
			$where .= "AND ( ii.owner_id = '".$HTTP_SESSION_VARS['user_id']."' OR ".
					" LENGTH(IFNULL(sst.min_display_user_type,'')) = 0 OR ".
					" sst.min_display_user_type IN(".format_sql_in_clause($user_type_r).") ) ";
		}
				
		if(strlen($owner_id)>0)
			$query .= "AND ii.owner_id = '".$owner_id."'";
	}

	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		mysql_free_result($result);
		return TRUE;
	}
	else
	{
		return FALSE;
	}
}

/**
	Assumes that lock_item_instance has been called to ensure that
	between delete of item_instance and delete of item, no further activity
	can occur on the table.
	
	If '$instance_no' specified, will test whether the specific instance 
	exists or not; Other wise will test whether any instances exist.

	This will not cater for 'linked' items which do not have a 
	item_instance record.
*/
function is_exists_item_instance($item_id, $instance_no=NULL)
{
	$query = "SELECT 'x' FROM item_instance WHERE item_id = '$item_id' ";
	if($instance_no)
		$query .= "AND instance_no = '$instance_no'";
	$query .= " LIMIT 0,1";
	
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		mysql_free_result($result);
		return TRUE;
	}

	//else
	return FALSE;
}

function is_exists_item_instance_with_owner($owner_id)
{
	$query = "SELECT 'x' FROM item_instance WHERE owner_id = '$owner_id'";
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		mysql_free_result($result);
		return TRUE;
	}

	//else
	return FALSE;
}

function is_exists_item_instance_with_owner_and_status($item_id, $s_status_type, $owner_id)
{
	$query = "SELECT 'x' FROM item_instance WHERE item_id = '$item_id' AND owner_id = '$owner_id' AND s_status_type = '$s_status_type'";

	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		mysql_free_result($result);
		return TRUE;
	}

	//else
	return FALSE;
}

/**
	Checks if the underlying item record actually exists or not.
*/
function is_exists_item($item_id)
{
	$query = "SELECT 'x' FROM item WHERE id = '$item_id'";

	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		mysql_free_result($result);
		return TRUE;
	}

	//else
	return FALSE;
}

/**
	Check if item is a child item.  No need to check item_instance,
	because parent-child relationship does not exist there.
*/
function is_child_item($item_id)
{
	$query = "SELECT parent_id FROM item WHERE id = '$item_id'";
	
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		$found = mysql_fetch_array($result, MYSQL_ASSOC);
		mysql_free_result($result);
		if ($found!== FALSE && is_numeric($found['parent_id']))
			return TRUE;
	}

	//else
	return FALSE;
}

/**
	Assumes that lock_item_instance has been called to 
	ensure that the max_instance_no is valid between select
	and insert.
*/
function fetch_max_instance_no($item_id)
{
	$query = "SELECT MAX(instance_no) as instance_no FROM item_instance WHERE item_id = $item_id";
	
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		$found = mysql_fetch_array($result, MYSQL_ASSOC);
		mysql_free_result($result);
		if ($found!== FALSE)
			return $found['instance_no'];
	}

	//else
	return FALSE;
}

/**
	Will fetch the image block for a particular s_item_type.  Will
	use $s_item_type if specified, otherwise will get s_item_type
	for $item_id first.

	@param $islinked is ignored at the moment.  It may be used to
	display a slightly smaller item type image for linked items,
	but we can not provide this logic at level.
	
	NOTE: Assumes that include("./include/theme.php"); has been performed.
*/
function get_item_image($s_item_type, $item_id = NULL, $islinked = FALSE)
{
	global $LANG_VARS;
	
	if(strlen($s_item_type)>0 || ($s_item_type = fetch_item_type($item_id)))
	{
		$item_type_r = fetch_item_type_r($s_item_type);
		if(is_array($item_type_r))
		{
			// Get image block.
			if(strlen($item_type_r['image'])>0)
			{
				if(strlen($item_type_r['description'])>0)
					$title_text = htmlspecialchars($item_type_r['description']);
				else
					$title_text = NULL;

				$imagetext = _theme_image($item_type_r['image'], $s_item_type, $title_text, NULL, "s_item_type");

				if($islinked)
				{
					$imagetext .= _theme_image("linked.gif", NULL, $LANG_VARS['linked_item']);
				}
				
				return $imagetext;
			}				
		}
	}
	
	//else
	return FALSE;
}

/**
	Add the SELECT and ORDER BY CLAUSES

	@param	$from_and_where_clause - the result of running the item_where_clause statement.

	@param	$order_by by should be one of "s_item_type, owner_id, title, category, update_on"
		The $order_by value will control which order column is first in the list, the rest
		will be filled in after with defaults.
	
	@param	$sortorder will be either "asc" or "desc"  if not defined it will default to "asc"
	@param	$index is the LIMIT value to apply.
*/
function fetch_item_listing_rs($from_and_where_clause, $order_by, $sortorder, $start_index, $items_per_page=NULL)
{
	// from config.php
	global $CONFIG_VARS;
	
	$query = "SELECT DISTINCT i.id as item_id, ii.instance_no, i.parent_id, ii.s_status_type, ii.owner_id, ii.borrow_duration, i.s_item_type, i.title, i.category, ii.update_on ".
			 $from_and_where_clause;

	// For simplicity sake!
	if(strlen($order_by)==0)
		$order_by = "title";

	if($order_by === "title")
		$query .= " ORDER BY i.title ".$sortorder.", ii.instance_no ASC, i.s_item_type";	
	else if($order_by == "s_item_type")
		$query .= " ORDER BY i.s_item_type ".$sortorder.", i.title, ii.instance_no ASC";	
	else if($order_by == "category")
		$query .= " ORDER BY i.category ".$sortorder.", i.title, ii.instance_no ASC, i.s_item_type";	
	else if($order_by == "owner_id")
		$query .= " ORDER BY ii.owner_id ".$sortorder.", i.title, ii.instance_no ASC, i.s_item_type";	
	else if($order_by == "s_status_type")
		$query .= " ORDER BY ii.s_status_type ".$sortorder.", i.title, ii.instance_no ASC, i.s_item_type";	
	else if($order_by == "update_on")
		$query .= " ORDER BY ii.update_on ".$sortorder.", i.title, ii.instance_no ASC, i.s_item_type";	

	if(is_numeric($start_index))
		$query .= " LIMIT " .$start_index. ", " .ifempty($items_per_page, $CONFIG_VARS['listings.items_per_page']);

	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
		return $result;
	else
		return FALSE;          
}

/**
	@param item_where_clause - the result of running the item_where_clause statement.
*/
function fetch_item_listing_cnt($from_and_where_clause)
{
	// From configuration file.
	global $CONFIG_VARS;

	$query = "SELECT count(".($CONFIG_VARS['listings.count_distinct_support']!==FALSE?"DISTINCT i.id, ii.instance_no":"i.id").") as count ".
			$from_and_where_clause;

	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		$found = mysql_fetch_array($result, MYSQL_ASSOC);
		mysql_free_result($result);
		if ($found!== FALSE)
			return $found['count'];
	}

	//else
	return FALSE;
}

/**
* 	NOTE: PRIVATE FUNCTION.

	Will return the FROM and WHERE clauses for a selection from the item table.
	
	If $owner_id defined, will limit to only items owned by owner_id
	If $s_item_type defined, will limit to only items of that type.
	If $category defined, will limit to only items of that category.
	If $letter defined will limit to item.title starting with that letter.
*/
function from_and_where_clause($HTTP_VARS)
{
	// For checking whether count (DISTINCT ...) is supported, and thus 
	// whether we have to do any special processing!
	global $CONFIG_VARS;
	global $HTTP_SESSION_VARS;

	// Extract all variables from array:
	//	$owner_id, $s_item_type, $s_item_type_rs[], $s_item_type_group, $title, $title_match, $category,
	//	$rating, $attribute_type, $attribute_vals[], $attribute_val, $attr_match, 
	//	$update_on, $datetimemask, $update_on_days, $letter, $start_item_id
	//	$s_status_type[], $not_s_status_type[], $linked_items
	if(is_not_empty_array($HTTP_VARS))
	{
		extract($HTTP_VARS);
	}

	// Escape only the single quote!
	$title = str_replace("'","\\'", $title);

	$attribute_val = str_replace("'","\\'", $attribute_val);
	if(is_array($attribute_vals))
	{
		for($i=0; $i<count($attribute_vals); $i++)
		{
			$attribute_vals[$i] = str_replace("'","\\'", $attribute_vals[$i]);
		}
	}

	$from = "item i, item_instance ii, s_status_type sst, user u ";
	
	// Only if count DISTINCT supported AND $linked_items == "include")
 	if($CONFIG_VARS['listings.count_distinct_support'] !== FALSE && $linked_items == "include")
	{ 
		$where = 
			"WHERE (".
			"(i.parent_id IS NULL AND i.id = ii.item_id) OR ".
			"(i.parent_id IS NOT NULL AND i.parent_id = ii.item_id)".
			") ";
	}
	else if($linked_items == "restrict") // Only display linked items.
	{
		"WHERE i.parent_id IS NOT NULL ";
	}
	else // $linked_items == "exclude"
	{
		// only parent items should ever be listed.
		$where = "WHERE i.id = ii.item_id AND i.parent_id IS NULL ";
	}
	
	// Join the s_status table in, so we can do some restrictions if required.
	$where .= "AND u.user_id = ii.owner_id AND LENGTH(IFNULL(u.pwd,''))>0 AND sst.s_status_type = ii.s_status_type ";

	// Add status support.
	if($s_status_type != 'ALL') // Special type, which does not restrict at all.
	{
		if(is_not_empty_array($s_status_type))
			$where .= "AND ii.s_status_type IN(".format_sql_in_clause($s_status_type).") ";
		else if(strlen($s_status_type)>0)
		{		
			$where .= "AND ii.s_status_type = '$s_status_type' ";
		}
	}
	
	// Restrict certain status types, to specified user types.
	$user_type_r = get_min_user_type_r($HTTP_SESSION_VARS['user_type']);
	if(is_not_empty_array($user_type_r))
	{
		$where .= "AND ( ii.owner_id = '".$HTTP_SESSION_VARS['user_id']."' OR ".
			" LENGTH(IFNULL(sst.min_display_user_type,'')) = 0 OR ".
			" sst.min_display_user_type IN(".format_sql_in_clause($user_type_r).") ) ";
	}
	
	// If the $attribute_vals length is 1, and $attribute_vals[0] is empty, then we should pretend that the
	// $attribute_vals array was not specified at all, because this is the default value.
	if( (is_array($attribute_vals) && (strlen($attribute_vals[0])>0 || count($attribute_vals)>1) ) || (strcasecmp($attr_match,"category")!==0 && strlen($attribute_val)>0))
	{
		if(strlen($attribute_type)>0)
			$attr_where .= "AND ia.s_attribute_type = '".$attribute_type."' ";
		
		// Only if attribute_vals is larger than 1, because the first value is always the default (and empty!) one
		if( strlen($attribute_val) == 0 && is_array($attribute_vals) && ( strlen($attribute_vals[0])>0 || count($attribute_vals)>1) )
		{
			if(strlen($attribute_vals[0])>0)
				$attribute_val = $attribute_vals[0];
			else// the first one after empty attribute!
				$attribute_val = $attribute_vals[1];
			
			$attribute_val = strtoupper($attribute_val);
			
			$attr_where .= "AND ( UPPER(ia.attribute_val) = '".str_replace('\_','_',$attribute_val)."' OR ".
					"UPPER(ia.attribute_val) LIKE '% ".$attribute_val." %' OR ".
					"UPPER(ia.attribute_val) LIKE '".$attribute_val." %' OR ".
					"UPPER(ia.attribute_val) LIKE '% ".$attribute_val."') ";
		}
		else if(strlen($attribute_val)>0) //$attribute_val
		{
			$parser = new BooleanParser();
			$statements = $parser->parseBooleanStatement($attribute_val);
			if(is_array($statements))
			{
				$attr_where .= "AND ".build_boolean_clause($statements, "ia.attribute_val", $attr_match);
			}
		}

		if($CONFIG_VARS['listings.count_distinct_support'] !== FALSE)
		{
			$where .= "AND ia.item_id = i.id ".$attr_where;
			$from .= ",item_attribute ia";
		}
		else
		{
			// Cut off the AND
			if(substr($attr_where,0,4) == "AND ")
				$attr_where = substr($attr_where,4);
		}
	}

	// Support for reviews.
	if(strlen($rating)>0)
	{
		if($CONFIG_VARS['listings.count_distinct_support'] !== FALSE)
		{
			$where .= "AND r.item_id = i.id AND r.rating>=$rating ";
			$from .= ",review r ";
		}
		else
		{
			$review_where = " r.rating>=$rating ";
		}
	}

	// Now process the item arrays for reviews and atttributes together if returned.
	if($CONFIG_VARS['listings.count_distinct_support'] === FALSE)
	{
		$inclause = get_item_attribute_and_review_matched_ids_in_clause($attr_where, $review_where);
		if($inclause)
			$where .= "AND i.id IN($inclause) ";
	}

	// Support specifying $attribute_val for $category where $attr_match=="category"!
	if(strcasecmp($attr_match,"category")===0 && strlen($attribute_val)>0)
		$category = $attribute_val;

 	if(strlen($category)>0)
	{
		// If item_type && item_type_group are not set!
		if(strlen($s_item_type)==0 && strlen($s_item_type_group)==0 && !is_array($s_item_type_rs) && strlen($attribute_type)>0)
		{
			$result = fetch_category_itemtype_rs($attribute_type);
			if($result)
			{
				$inclause = "";
				while($type_r = mysql_fetch_array($result))
				{
					if(strlen($inclause)>0)
						$inclause .= ",";
					$inclause .= "'".$type_r['s_item_type']."'";
				}
				mysql_free_result($result);
			
				if(strlen($inclause)>0)
				{
					$where .= "AND i.s_item_type IN (".$inclause.") ";
				}
			}
		}

		$category = strtoupper($category);
		$where .= "AND ( UPPER(i.category) = '".str_replace('\_','_',$category)."' OR ".
						"UPPER(i.category) LIKE '% ".$category." %' OR ".
						"UPPER(i.category) LIKE '".$category." %' OR ".
						"UPPER(i.category) LIKE '% ".$category."' ) ";
	}

	// No LIKE support for $owner_id
	if(strlen($owner_id)>0)
		$where .= "AND ii.owner_id = '$owner_id' ";
	else if(strlen($not_owner_id)>0)//For not showing current user items.
		$where .= "AND ii.owner_id <> '$not_owner_id' ";
	
	// No LIKE support for $s_item_type
	if(strlen($s_item_type)>0)
	{
		$where .= "AND i.s_item_type = '$s_item_type' ";
	}
	else if(strlen($s_item_type_group)>0 && is_not_empty_array($CONFIG_VARS['listings.s_item_type_groups'][$s_item_type_group]))
	{
		$where .= "AND i.s_item_type IN(".format_sql_in_clause($CONFIG_VARS['listings.s_item_type_groups'][$s_item_type_group]).")";
	}
	else if(is_not_empty_array($s_item_type_rs))
	{
		$where .= "AND i.s_item_type IN(".format_sql_in_clause($s_item_type_rs).")";
	}
	
	if(strlen($title)>0)
	{
		$parser = new BooleanParser();
		$statements = $parser->parseBooleanStatement($title);
		if(is_array($statements))
		{
			$where .= "AND ".build_boolean_clause($statements, "i.title", $title_match);
		}
	}
	
	// GIve us all records updated in the last however many days.
	if(strlen($update_on)>0)
	{
		if(isset($datetimemask) && strlen($datetimemask)>0)
		{
			$components = get_timestamp_components($update_on, $datetimemask);
			$update_on = get_mysql_timestamp($components);
		}
		$where .= "AND ii.update_on >= '$update_on' ";
	}
	else if(is_numeric($update_on_days))
		$where .= "AND TO_DAYS(ii.update_on) >= (TO_DAYS(now())-$update_on_days) ";
			
	// Enforce non-case sensitive here! 
	if(strlen($letter)>0)
	{
		// Numeric match.
		if($letter == "#")
			$where .= "AND left(i.title,1) BETWEEN 0 AND 9 ";
		else
			$where .= "AND UPPER(left(i.title,1)) = '".strtoupper($letter)."' ";
	}

	// A special option just for the Import script to display all items just added.
	if(is_numeric($start_item_id))
		$where .= "AND i.id >= $start_item_id ";

	return "FROM ".$from." ".$where;
}

/**
	Will return a "$item_id,$item_id,..." list for inclusion in a item_id IN(...) clause.
*/
function get_item_attribute_and_review_matched_ids_in_clause($attr_where, $review_where)
{
	if(strlen($attr_where)>0 && strlen($review_where)>0)
		$query = "SELECT DISTINCT ia.item_id FROM item_attribute ia, review r WHERE ia.item_id = r.item_id AND $attr_where AND $review_where";
	else if(strlen($attr_where)>0)
		$query = "SELECT DISTINCT ia.item_id FROM item_attribute ia WHERE $attr_where";
	else if(strlen($review_where)>0)
		$query = "SELECT DISTINCT r.item_id FROM review r WHERE $review_where";
	else
		return FALSE;

	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		$inclause = "";
		while($item_r = mysql_fetch_array($result, MYSQL_ASSOC))
		{
			if(strlen($inclause)>0) $inclause .= ",";
				$inclause .= $item_r['item_id'];
		}
		mysql_free_result($result);
		return $inclause;
	}
	else
		return FALSE;
}

//
// If successful will return the new ID for the item, otherwise will return FALSE.
//
function insert_item($parent_id, $s_item_type, $title, $category)
{
	global $HTTP_SESSION_VARS;
	
	if(strlen($title)>0)
	{
		$title = addslashes(replace_newlines(trim($title)));
		
		// Max size of 100 characters for $category.
		$category = addslashes(trim(replace_newlines(substr(trim($category),0,100))));

		$query = "INSERT INTO item (parent_id, s_item_type, title, category)".				   
				" VALUES (".(!is_numeric($parent_id)?"NULL":"'$parent_id'").",'$s_item_type','$title', '$category')";

		$insert = run_opendb_query($query);
		if (mysql_affected_rows() > 0)
		{
			$new_item_id = mysql_insert_id();
			opendb_log("Inserted item (item_id=$new_item_id, update_who=".$HTTP_SESSION_VARS['user_id'].")");
			return $new_item_id;
		}
		else
		{
			opendb_log("Failed to insert item (update_who=".$HTTP_SESSION_VARS['user_id'].") [error=".mysql_error()."]");
			return FALSE;
		}
	}
	else
	{
		opendb_log("Failed to insert item (update_who=".$HTTP_SESSION_VARS['user_id'].") [Title not specified]");
		return FALSE;
	}		
}

function validate_item_instance_fields($s_status_type, &$status_comment, &$borrow_duration)
{
	// At this point, a specific $s_status_type MUST be supplied.
	if(strlen($s_status_type)>0)
		$status_type_r = fetch_status_type_r($s_status_type);
		
	if(is_not_empty_array($status_type_r))	
	{
		// A $borrow_duration explicitly set to FALSE, is
		// an indication that nothing should be done with it.
		if($borrow_duration !== FALSE && $borrow_duration !== NULL)//if already null, no need to check again.
		{
			if($status_type_r['borrow_ind'] != 'Y' && $status_type_r['borrow_ind'] != 'N' && $status_type_r['borrow_ind'] != 'B')
				$borrow_duration = NULL;
			else
			{		
				// Ensure we have a valid $borrow_duration
				if(is_numeric($borrow_duration))//column cannot handle more than 999
				{
					if($borrow_duration > 999)
						$borrow_duration = '999';
				}
				else
					$borrow_duration = NULL;
			}
		}
		
		// If no status comment allowed, then set to NULL
		if($status_type_r['status_comment_ind'] != 'Y' && $status_type_r['status_comment_ind'] != 'H')
			$status_comment = NULL;
		else
			$status_comment = addslashes(substr(replace_newlines(trim(strip_tags($status_comment))),0,255));
		
		return TRUE;
	}
	else
	{
		return FALSE;
	}
}

/**
	This function is for the initial instance of the item.
*/
function insert_newitem_instance($item_id, $s_status_type, $status_comment, $borrow_duration, $owner_id)
{
	global $HTTP_SESSION_VARS;
	
	if(validate_item_instance_fields($s_status_type, $status_comment, $borrow_duration))
	{
		$instance_no = '1';	

		// The first instance starts from 1
		$query = "INSERT INTO item_instance(item_id, instance_no, owner_id,borrow_duration,s_status_type,status_comment)".
				"VALUES ('$item_id','$instance_no','$owner_id',".(is_numeric($borrow_duration)?"'$borrow_duration'":"NULL").",UPPER('".$s_status_type."'),'$status_comment')";

		$insert = run_opendb_query($query);
		if ($insert && mysql_affected_rows() > 0)
		{
			opendb_log("Inserted item instance (item_id=$item_id, instance_no=$instance_no, update_who=".$HTTP_SESSION_VARS['user_id'].")");
			return $instance_no;
		}
		else
		{
			opendb_log("Failed to insert item instance (item_id=$item_id, instance_no=$instance_no, update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
			return FALSE;
		}
	}
	else //if(validate_item_instance_fields($s_status_type, $borrow_duration))
	{
		return FALSE;
	}
}

/**
	For subsequent item_instance inserts.

	Does not support $s_status_type = 'W' specific functionality.

*/
function insert_item_instance($item_id, $s_status_type, $status_comment, $borrow_duration, $owner_id)
{
	global $HTTP_SESSION_VARS;
	
	if(validate_item_instance_fields($s_status_type, $status_comment, $borrow_duration))
	{
		// No need to lock if new item, as no other item_instances will
		// be assigned to it yet!
		if(run_opendb_query("LOCK TABLES item_instance WRITE"))
		{
			$instance_no = fetch_max_instance_no($item_id);
			if($instance_no!==FALSE)
			{
				// Add 1 to $instance_no
				$instance_no = (int)$instance_no;
				$instance_no++;
			
				$query = "INSERT INTO item_instance(item_id, instance_no, owner_id, borrow_duration, s_status_type, status_comment)".
					"VALUES ('$item_id','$instance_no','$owner_id',".(is_numeric($borrow_duration)?"'$borrow_duration'":"NULL").",UPPER('".$s_status_type."'),'$status_comment')";
				
				$insert = run_opendb_query($query);
				if ($insert && mysql_affected_rows() > 0)
				{
					// Can't forget to unlock table.
					run_opendb_query("UNLOCK TABLES");

					opendb_log("Inserted item instance (item_id=$item_id, instance_no=$instance_no, update_who=".$HTTP_SESSION_VARS['user_id'].")");
					return $instance_no;
				}
				else
				{
					opendb_log("Failed to insert item instance (item_id=$item_id, instance_no=$instance_no, update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
				}
			}
			else
			{
				opendb_log("No item instances found for existing item (item_id=$item_id, update_who=".$HTTP_SESSION_VARS['user_id'].")");
			}

			// Can't forget to unlock table.
			run_opendb_query("UNLOCK TABLES");
			return FALSE;
		}
		else
		{
			opendb_log("Could not lock item_instance table for write (update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
			return FALSE;
		}
	}
	else //if(validate_item_instance_fields($s_status_type, $borrow_duration))
	{
		return FALSE;
	}
}

/**
	@param $borrow_duration If set to FALSE, no update will occur.  If not numeric, will be
	set to NULL otherwise.
	
	@param $status_comment If set to FALSE, no update will occur.  If not numeric, will be
	set to NULL otherwise.
*/
function update_item_instance($item_id, $instance_no, $s_status_type, $status_comment, $borrow_duration)
{
	global $HTTP_SESSION_VARS;
	
	if(validate_item_instance_fields($s_status_type, $status_comment, $borrow_duration))
	{
		$query = "UPDATE item_instance SET ";
	
		// If $borrow_duration explicitly set to FALSE, then no update should occur!
		if($borrow_duration !== FALSE)
		{
			$query .= "borrow_duration = ".(is_numeric($borrow_duration)?"'$borrow_duration'":"NULL").", ";
		}
			
		if($status_comment!==FALSE)
			$query .= "status_comment = '$status_comment', ";
	
		$query .= "s_status_type = UPPER('".$s_status_type."') ".
			"WHERE item_id = '$item_id' AND instance_no = '$instance_no'";

		$update = run_opendb_query($query);
	
		// We should not treat updates that were not actually updated because value did not change as failures.
		$rows_affected = mysql_affected_rows();
		if($update && $rows_affected !== -1)
		{
			if($rows_affected>0)
				opendb_log("Updated item instance (item_id=$item_id, instance_no=$instance_no, update_who=".$HTTP_SESSION_VARS['user_id'].")");
			return TRUE;
		}
		else
		{
			opendb_log("Failed to update item instance (item_id=$item_id, instance_no=$instance_no, update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
			return FALSE;
		}
	}
	else //if(validate_item_instance_fields($s_status_type, $borrow_duration))
	{	
		return FALSE;
	}
}

/**
	Update item - only called from update_item_instance from now on.

	The only problem we have is that when an update of an item occurs, none of the item_instances
	will reflect this.  So we cannot actually tell if an item has been updated.  But since we are
	probably only interested in new items, that is alright.
*/
function update_item($item_id, $title, $category)
{
	global $HTTP_SESSION_VARS;
	
	$query = "UPDATE item set ";
	if(strlen($title)>0)
	{
		$title = addslashes(replace_newlines(trim($title)));
		$query .= "title = '$title',";
	}

	// Max size of 100 characters for $category.
	$category = addslashes(substr(replace_newlines(trim($category)),0,100));

	$query .= "category = '$category' ".
		"WHERE id = '$item_id'";

	$update = run_opendb_query($query);
	// We should not treat updates that were not actually updated because value did not change as failures.
	$rows_affected = mysql_affected_rows();
	if ($rows_affected !== -1)
	{
		if($rows_affected>0)
		{
			opendb_log("Updated item (item_id=$item_id, update_who=".$HTTP_SESSION_VARS['user_id'].")");
		}
		return TRUE;
	}
	else
	{
		opendb_log("Failed to update item (item_id=$item_id, update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
		return FALSE;
	}
}

//
// Delete item and return boolean indicating success or failure.
//
function delete_item_instance($item_id, $instance_no)
{
	global $HTTP_SESSION_VARS;
	
	$query ="DELETE FROM item_instance WHERE item_id = '".$item_id."' AND instance_no = '$instance_no'";
	$delete = run_opendb_query($query);
	if(mysql_affected_rows() > 0)
	{
		opendb_log("Deleted item instance (item_id=$item_id, instance_no=$instance_no, update_who=".$HTTP_SESSION_VARS['user_id'].")");
		return TRUE;
	}else{
		opendb_log("Failed to delete item instance (item_id=$item_id, instance_no=$instance_no, update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
		return FALSE;
	}
}

/**
	Delete item and return boolean indicating success or failure.
	
	This function does not check for dependencies, as it is assumed that this 
	is done in the main code!
*/	
function delete_item($item_id)
{
	global $HTTP_SESSION_VARS;
	
	$query ="DELETE FROM item WHERE id='".$item_id."'";
	$delete = run_opendb_query($query);
	if(mysql_affected_rows() > 0)
	{
		opendb_log("Deleted item (item_id=$item_id, update_who=".$HTTP_SESSION_VARS['user_id'].")");
		if(fetch_child_item_cnt($item_id)>0)
		{
			$query ="DELETE FROM item WHERE parent_id='".$item_id."'";
			$delete = run_opendb_query($query);
			if(mysql_affected_rows() > 0)
			{
				opendb_log("Deleted child items for item (item_id=$item_id, update_who=".$HTTP_SESSION_VARS['user_id'].")");
				return TRUE;
			}
			else{
				opendb_log("Failed to delete child items for item (item_id=$item_id, update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
				return FALSE;
			}
		}
		else
			return TRUE;
	}
	else
	{
		opendb_log("Failed to delete item (item_id=$item_id, update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
		return FALSE;
	}
}
?>
