<?php
/* 	OpenDb - Open Lending Database Project
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

include_once("./functions/function.php");
include_once("./functions/user.php");
include_once("./functions/utils.php");
include_once("./functions/http.php");

/**
	A simple email validation function.  Used by the main 'email' sending
	routine in this script, which allows calling programs to test their
	email addresses with the same test.
*/
function is_valid_email_addr($email_addr)
{
	if ( strlen($email_addr)==0 || !ereg("^.+@.+\\..+$", $email_addr) || strpos($email_addr, ">")!==FALSE)
		return FALSE;
	else
		return TRUE;
}

/**
	Return email footer
*/
function get_email_footer()
{
	// from config.php
	global $CONFIG_VARS;
	global $LANG_VARS;
	
	if(strlen($LANG_VARS['email_footer'])>0)
	{
		$site_url = get_site_url();

		// This footer text will include any newlines that are required, and because the email
		// is text based, these newlines should be respected.  I am not sure what will happen
		// however on Mac / Windows systems, because we only understand '\n' as a newline
		// identifier in the language variables.
		$footer_text = trim(replace_lang_vars(array('site'=>$CONFIG_VARS['site.title'],'version'=>$CONFIG_VARS['site.version'],'site_url'=>$site_url), expand_langvar_newlines($LANG_VARS['email_footer'])));

		// Now lets explode any line breaks into separate lines so we
		// can work out how long the dashed lines need to be.
		$lines_r = explode("\n", $footer_text);
		if(is_array($lines_r) && count($lines_r)>1)
		{
			$length = 0;
			while(list(,$line) = @each($lines_r))
			{
				// We need to get the longest line.
				if(strlen($line)>$length)
					$length = strlen($line);
			}
		}
		else // Only one line.
			$length = strlen($footer_text);

		if($length>0)
		{
			for($i=0;$i<$length;$i++)
				$dashed_line .= "-";
			
			// Now return the complete footer text
			return	$dashed_line
					."\n"
					.$footer_text
					."\n"
					.$dashed_line;
		}
	}

	//else - no footer.
	return "";
}

/**
	@param to
	@param toname
	@param from
	@param fromname
	@param subject
	@param message
	@param append_site_to_subject Whether the [OpenDb] should be appended to 
			the subject line.

	@returns TRUE on success, or array of errors on failure.
*/
function opendb_email($to, $toname, $from, $fromname, $subject, $message, $append_site_to_subject = TRUE)
{
	// from config.php
	global $CONFIG_VARS;
	global $LANG_VARS;
	
	// trim once only!
	$to = trim($to);
	$from = trim($from);

	if(!is_valid_email_addr($from))
		$errors[] = $LANG_VARS['invalid_from_address'];
	if (strlen(trim($subject))==0)
		$errors[] = $LANG_VARS['invalid_subject'];

	// Check 'to' address
	if(!is_valid_email_addr($to))
		$errors[] = $LANG_VARS['invalid_to_address'];
	
	// Any errors.
	if(is_not_empty_array($errors))
		 return $errors;
	else
	{
		// If friendly email format, include \"Person name\" <email address>
		// Otherwise only specify the <email address>.
		if($CONFIG_VARS['email.friendly_email_format'] !== FALSE)
		{
			// For windows, the $to argument to the mail function is actually
			// a RECPT-TO header.
			if($CONFIG_VARS['email.win32_smtp_email'])
			{
				if(strlen($toname)>0)
					$headers .= "To: \"$toname\" <".$to.">\r\n";
				else
					$headers .= "To: <".$to.">\r\n";
			}
			else
			{
				// *nix machines support including friendly name in $to argument to mail in most cases.
				$to = "\"$toname\" <".$to.">";
			}
			
			if(strlen($fromname)>0)
			{
				$from = "\"$fromname\" <".$from.">";
				$headers .= "From: $from\r\n";
			}
			else
				$headers .= "From: <".$from.">\r\n";
		}
		else
		{
			if($CONFIG_VARS['email.win32_smtp_email'])
				$headers .= "To: <".$to.">\r\n";
			
			$headers .= "From: <$from>\r\n";
		}
		
		// additional header pieces for errors
		$headers .= "X-Sender: <".$CONFIG_VARS['site.admin_email'].">\r\n"; 
		$headers .= "X-Mailer: PHP/".phpversion()."\r\n"; // mailer
		$headers .= "X-Priority: 3\r\n"; //1 UrgentMessage, 3 Normal
		$headers .= "Return-Path: <".$CONFIG_VARS['site.admin_email'].">\r\n"; // Return path for errors

		$message = str_replace("\n", "\r\n", // fix for some email setups which require \r\n newlines for all line endings.
				stripslashes($message).
					"\n\n\n".
					get_email_footer());
		
		$subject = stripslashes($subject).
					($append_site_to_subject?" [".$CONFIG_VARS['site.title']."]":"");
		
		if(mail($to, $subject, $message, $headers))
		{
			// No errors returned indicates correct execution.
			opendb_log("Email sent to $to from $from");
			return TRUE;
		}
		else
		{
			// No errors returned indicates correct execution.
			opendb_log("Email not sent to $to from $from");
			return FALSE;
		}
	}
}
?>
