<?php
/* 	OpenDb - Open Lending Database Project
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// This must be first - includes config.php
require_once("./include/begin.inc.php");

include_once("./include/language.php");
include_once("./include/theme.php");

if($HTTP_VARS['op'] != 'header' && strlen($HTTP_VARS['url'])>0)
{
	// Get the site without any extra path info!
	if(strlen($HTTP_VARS['title'])>0)
		$page_title = $HTTP_VARS['title'];
	else
	{
		if(preg_match("!([a-zA-Z]+)://([^/]+)/!", $HTTP_VARS['url'], $regs))
			$page_title = $regs[1]."://".$regs[2];
		else
			$page_title = $HTTP_VARS['url'];
	}
			
	echo("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">".
		"\n<html>".
		"\n<head>".
		"\n<title>".$CONFIG_VARS['site.title']." ".$CONFIG_VARS['site.version']." - ".$page_title."</title>".
		"<link rel=\"icon\" href=\"images/icon.gif\" type=\"image/gif\" />".
		"</head>".
		"<frameset rows=\"50,*\" border=0>".
		"<frame name=\"opendb\" src=\"$PHP_SELF?op=header&url=".urlencode($HTTP_VARS['url'])."&title=".urlencode($HTTP_VARS['title'])."\" scrolling=\"no\" marginheight=1 noresize>".
		"<frame name=\"external\" src=\"".$HTTP_VARS['url']."\" marginheight=1>".
		"</frameset>".
		"<noframes>".
		replace_lang_var("url", $HTTP_VARS['url'], $LANG_VARS['external_noframes_link_text']).
		"</noframes>".
		"</html>");
}
else if($HTTP_VARS['op'] == 'header')
{
	echo("<html>".
		"\n<head>".
		"\n<link rel=\"stylesheet\" type=\"text/css\" href=\"theme/$_OPENDB_THEME/style.css\">".
		"\n</head>".
		"\n<body>".
		"<center><table border=0>".
		"<tr>".
		"<td align=right>".
		"<img src=\"images/icon.gif\">&nbsp;".
		"</td>".
		"<td align=left>".
		"<div class=\"fineprint\">".
		replace_lang_vars(array('site'=>$CONFIG_VARS['site.title'],'url'=>$HTTP_VARS['url'],'title'=>$HTTP_VARS['title']), $LANG_VARS['external_header_text']).
		"</div>".
		"</td>".
		"</tr>".
		"</table></center>".
		"</body>".
		"</html>");
}
else
{
	echo _theme_header($LANG_VARS['external_url_error'],FALSE);
	echo _theme_error($LANG_VARS['external_url_error']);
	echo _theme_footer();
}
?>