<?php
/* 	OpenDb - Open Lending Database Project
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

include_once("./functions/widgets.php");
include_once("./functions/utils.php");

//
// CSV Export Plugin
//

/*
* The content type, when saved as file.
*/
function file_content_type()
{
	return "application/csv";
}

/*
* The filename extension, when saved as file.
*/
function file_extension()
{
	return "csv";
}

/*
* The file header, when saved as file.
*/
function file_header($title)
{
	return "";
}

function prompt_header($columns)
{
	$buffer = "";
	
	if(is_not_empty_array($columns))
	{
		while(list(,$column) = each($columns))
		{
			if(strlen($buffer)>0)
				$buffer .= ",$column";
			else
				$buffer .= "$column";
		}
		return $buffer."\n";
	}
	else
		return "";
}

function item_row($columns)
{
	$buffer = "";
	
	if(is_not_empty_array($columns))
	{
		while(list(,$column) = each($columns))
		{
			$doQuote=FALSE;
			if(strpos($column, "\"")!==FALSE)
			{
				$column = str_replace("\"", "\"\"", $column);
				$doQuote=TRUE;
			}
			if(strpos($column, ",")!==FALSE || strpos($column, "\n")!==FALSE)
			{
				$doQuote=TRUE;
			}
			
			if($doQuote)
				$column = "\"".$column."\"";
				
			if(strlen($buffer)>0)
				$buffer .= ",$column";
			else
				$buffer .= "$column";
		}
		return $buffer."\n";
	}
	else
		return "";
}
?>
