<?php
/* 	OpenDb - Open Lending Database Project
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

include_once("./functions/user.php");
include_once("./functions/status_type.php");

function display_edit_form($status_type_r, $HTTP_VARS=NULL)
{
	global $_COLUMN_DESC;
	
	if(is_array($status_type_r))
		echo get_input_field("s_status_type", NULL, $_COLUMN_DESC['s_status_type'], "readonly", "Y", $status_type_r['s_status_type'], TRUE, "%prompt%<a class=\"smlink\" href=\"javascript:popup('admin.php?type=s_status_type&op=help&inc_header=N&column=s_status_type','500', '350')\">(?)</a>");
	else
		echo get_input_field("s_status_type", NULL, $_COLUMN_DESC['s_status_type'], "text(10,10)", "Y", $HTTP_VARS['s_status_type'], TRUE, "%prompt%<a class=\"smlink\" href=\"javascript:popup('admin.php?type=s_status_type&op=help&inc_header=N&column=s_status_type','500', '350')\">(?)</a>");

	echo get_input_field("description", NULL, $_COLUMN_DESC['description'], "text(30,60)", "Y", ifempty($status_type_r['description'],$HTTP_VARS['description']), TRUE, "%prompt%<a class=\"smlink\" href=\"javascript:popup('admin.php?type=s_status_type&op=help&inc_header=N&column=description','500', '350')\">(?)</a>");

	$field = get_input_field("img", NULL, $_COLUMN_DESC['img'], "url(15,*,\"gif,jpg,png\",N)", "N", ifempty($status_type_r['img'],$HTTP_VARS['img']), FALSE);
	$image_src = _theme_image_src(ifempty($status_type_r['img'],$HTTP_VARS['img']));
	if($image_src!==FALSE && strlen($image_src)>0)
		$field .= " <img align=absmiddle valign=absmiddle src=\"$image_src\">";
	echo format_field($_COLUMN_DESC['img'], NULL, $field, TRUE, "%prompt%<a class=\"smlink\" href=\"javascript:popup('admin.php?type=s_status_type&op=help&inc_header=N&column=img','500', '350')\">(?)</a>");
	
	echo get_input_field("insert_ind", NULL, $_COLUMN_DESC['insert_ind'], "value_radio_grid('Y,N',*)", "N", ifempty($status_type_r['insert_ind'],$HTTP_VARS['insert_ind']), TRUE, "%prompt%<a class=\"smlink\" href=\"javascript:popup('admin.php?type=s_status_type&op=help&inc_header=N&column=insert_ind','500', '350')\">(?)</a>");
	echo get_input_field("update_ind", NULL, $_COLUMN_DESC['update_ind'], "value_radio_grid('Y,N',*)", "N", ifempty($status_type_r['update_ind'],$HTTP_VARS['update_ind']), TRUE, "%prompt%<a class=\"smlink\" href=\"javascript:popup('admin.php?type=s_status_type&op=help&inc_header=N&column=update_ind','500', '350')\">(?)</a>");
	echo get_input_field("delete_ind", NULL, $_COLUMN_DESC['delete_ind'], "value_radio_grid('Y,N',*)", "N", ifempty($status_type_r['delete_ind'],$HTTP_VARS['delete_ind']), TRUE, "%prompt%<a class=\"smlink\" href=\"javascript:popup('admin.php?type=s_status_type&op=help&inc_header=N&column=delete_ind','500', '350')\">(?)</a>");
	
	$user_type_rs = array_merge(array(''=>''),get_user_types_rs());
	echo format_field($_COLUMN_DESC['min_display_user_type'], NULL, custom_select("min_display_user_type", $user_type_rs, "%key% - %value%", 1, ifempty($status_type_r['min_display_user_type'],$HTTP_VARS['min_display_user_type']), 'key'), TRUE, "%prompt%<a class=\"smlink\" href=\"javascript:popup('admin.php?type=s_status_type&op=help&inc_header=N&column=min_display_user_type','500', '350')\">(?)</a>");
	echo format_field($_COLUMN_DESC['min_create_user_type'], NULL, custom_select("min_create_user_type", $user_type_rs, "%key% - %value%", 1, ifempty($status_type_r['min_create_user_type'],$HTTP_VARS['min_create_user_type']), 'key'), TRUE, "%prompt%<a class=\"smlink\" href=\"javascript:popup('admin.php?type=s_status_type&op=help&inc_header=N&column=min_create_user_type','500', '350')\">(?)</a>");
	
	echo get_input_field("new_owner_instance_ind", NULL, $_COLUMN_DESC['new_owner_instance_ind'], "value_radio_grid('Y,N',*)", "N", ifempty($status_type_r['new_owner_instance_ind'],$HTTP_VARS['new_owner_instance_ind']), TRUE, "%prompt%<a class=\"smlink\" href=\"javascript:popup('admin.php?type=s_status_type&op=help&inc_header=N&column=new_owner_instance_ind','500', '350')\">(?)</a>");
	echo get_input_field("new_not_owner_instance_ind", NULL, $_COLUMN_DESC['new_not_owner_instance_ind'], "value_radio_grid('Y,N',*)", "N", ifempty($status_type_r['new_not_owner_instance_ind'],$HTTP_VARS['new_not_owner_instance_ind']), TRUE, "%prompt%<a class=\"smlink\" href=\"javascript:popup('admin.php?type=s_status_type&op=help&inc_header=N&column=new_not_owner_instance_ind','500', '350')\">(?)</a>");
	echo get_input_field("borrow_ind", NULL, $_COLUMN_DESC['borrow_ind'], "value_radio_grid('Y,N,B,X',*)", "N", ifempty($status_type_r['borrow_ind'],$HTTP_VARS['borrow_ind']), TRUE, "%prompt%<a class=\"smlink\" href=\"javascript:popup('admin.php?type=s_status_type&op=help&inc_header=N&column=borrow_ind','500', '350')\">(?)</a>");
	echo get_input_field("status_comment_ind", NULL, $_COLUMN_DESC['status_comment_ind'], "value_radio_grid('Y,H,N',*)", "N", ifempty($status_type_r['status_comment_ind'],$HTTP_VARS['status_comment_ind']), TRUE, "%prompt%<a class=\"smlink\" href=\"javascript:popup('admin.php?type=s_status_type&op=help&inc_header=N&column=status_comment_ind','500', '350')\">(?)</a>");
	echo get_input_field("default_ind", NULL, $_COLUMN_DESC['default_ind'], "checkbox(Y,N)", "N", ifempty($status_type_r['default_ind'],$HTTP_VARS['default_ind']), TRUE, "%prompt%<a class=\"smlink\" href=\"javascript:popup('admin.php?type=s_status_type&op=help&inc_header=N&column=default_ind','500', '350')\">(?)</a>");
	
	if(is_array($status_type_r))
		echo get_input_field("closed_ind", NULL, $_COLUMN_DESC['closed_ind'], "checkbox(Y,N)", "N", ifempty($status_type_r['closed_ind'],$HTTP_VARS['closed_ind']), TRUE, "%prompt%<a class=\"smlink\" href=\"javascript:popup('admin.php?type=s_status_type&op=help&inc_header=N&column=closed_ind','500', '350')\">(?)</a>");
}

function display_s_status_type_chooser($script_name, $type, $s_status_type)
{
	echo("\n<p><form action=\"$script_name\" method=\"get\">");
	echo("\n<input type=\"hidden\" name=\"op\" value=\"edit\">");
	echo("\n<input type=\"hidden\" name=\"type\" value=\"".$type."\">");

	$lookup_results = fetch_status_type_rs();
	echo custom_select("s_status_type", $lookup_results, "%s_status_type% - %description%", 1, $s_status_type, "s_status_type", NULL).
				"&nbsp;<input type=button value=\"Edit\" onclick=\"this.form['op'].value='edit'; this.form.submit();\">&nbsp;".
				"<input type=button value=\"New\" onclick=\"this.form['op'].value='new'; this.form.submit();\">";
	echo("</form></p>");
}

// temporary
function get_s_status_type_doc($columnname)
{
	global $_COLUMN_HELP;
	global $_COLUMN_DESC;

	if(isset($_COLUMN_HELP[$columnname]))
	{
		echo("<h3>".$_COLUMN_DESC[$columnname]."</h3>");
		echo("<p class=\"colortext\">Column: ".$columnname."</p>");
		echo(format_help_block($_COLUMN_HELP[$columnname]));
	}
	else
	{
		echo("<p class=\"colortext\">No Help available</p>");
	}
}

// #################################################################################
// Main Process
// #################################################################################
if(is_opendb_valid_session())
{
	if(is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']))
	{
		// Get rid of select box value.
		if($HTTP_VARS['op'] == 'new')
			unset($HTTP_VARS['s_status_type']);
			
		if($HTTP_VARS['op'] == 'help')
		{
			echo _theme_header("Status Type Help", FALSE);
			echo("\n<h2>Status Type Help</h2>");

			echo("<pre>".
				get_s_status_type_doc($HTTP_VARS['column']).
				"</pre>");
		}
		else if($HTTP_VARS['op'] == 'delete')
		{
			if(is_valid_s_status_type($HTTP_VARS['s_status_type']))
			{
				$status_type_r = fetch_status_type_r($HTTP_VARS['s_status_type']);
				
				if( $status_type_r['closed_ind'] != 'Y' && $status_type_r['default_ind'] == 'Y' &&
						fetch_default_status_type_cnt() <= 1)
				{
					display_s_status_type_chooser($PHP_SELF, $HTTP_VARS['type'], $HTTP_VARS['s_status_type']);
					
					echo("\n<h3>Delete Status type</h3>");
					echo format_error_block(array('error'=>'Status type not deleted','detail'=>'Status type is default, and there are no other default records'));
				}
				else if(is_exists_items_with_status_type($HTTP_VARS['s_status_type']))// Validate that no items are attached for this status type.
				{
					// Display the chooser at the top whatever happens.
					display_s_status_type_chooser($PHP_SELF, $HTTP_VARS['type'], $HTTP_VARS['s_status_type']);

					echo("\n<h3>Delete Status type</h3>");
					echo format_error_block(array('error'=>'Status type not deleted','detail'=>'Status type cannot be deleted while '.$status_type_r['description'].' item instance(s) exist.'));
				}
				else
				{
					if($HTTP_VARS['confirmed'] == 'true')
					{
						if(delete_s_status_type($HTTP_VARS['s_status_type']))
						{
							display_s_status_type_chooser($PHP_SELF, $HTTP_VARS['type'], $HTTP_VARS['s_status_type']);
							
							echo("\n<h3>Delete Status type</h3>");
							echo("\n<div class=\"success\">Status type deleted</div>");
						}
						else
						{
							display_s_status_type_chooser($PHP_SELF, $HTTP_VARS['type'], $HTTP_VARS['s_status_type']);
							echo("\n<h3>Delete Status type</h3>");
							echo format_error_block(array('error'=>'Status type not deleted','detail'=>mysql_error()));
						}
					}
					else if($HTTP_VARS['confirmed'] != 'false')
					{
						display_s_status_type_chooser($PHP_SELF, $HTTP_VARS['type'], $HTTP_VARS['s_status_type']);
						echo("\n<h3>Delete Status type</h3>");
						echo(get_op_confirm_form($PHP_SELF, 
								"Are you sure you want to delete status type '".$HTTP_VARS['s_status_type']." - ".$status_type_r['description']."'?", 
								array('type'=>$HTTP_VARS['type'], 'op'=>'delete', 's_status_type'=>$HTTP_VARS['s_status_type'])));
					}
					else // confirmation required.
					{
						display_s_status_type_chooser($PHP_SELF, $HTTP_VARS['type'], $HTTP_VARS['s_status_type']);
						echo("\n<h3>Delete Status type</h3>");
						echo "\n<div class=\"success\">Status Type not deleted</div>";
					}
				}
			}
			else
			{
				echo format_error_block('Invalid status type specified');
			}
		}
		else if($HTTP_VARS['op'] == 'update')
		{
			display_s_status_type_chooser($PHP_SELF, $HTTP_VARS['type'], $HTTP_VARS['s_status_type']);
			echo("\n<h3>Update Status type</h3>");
					
			if(is_valid_s_status_type($HTTP_VARS['s_status_type']))
			{
				$status_type_r = fetch_status_type_r($HTTP_VARS['s_status_type']);
				
				// If default_ind is currently 'Y', and being set to 'N', or closed_ind being set 'Y' from 'N'
				if( (($HTTP_VARS['default_ind'] != 'Y' && $status_type_r['default_ind'] == 'Y') ||
					($HTTP_VARS['closed_ind'] == 'Y' && $status_type_r['closed_ind'] != 'Y' && $status_type_r['default_ind'] == 'Y')) &&
						fetch_default_status_type_cnt() <= 1)
				{
					echo format_error_block(
								array('error'=>'Status type not updated',
										'detail'=>'Status type is default, and there are no other default records'));
				}
				else if(user_type_cmp($status_type_r['min_create_user_type'], $HTTP_VARS['min_create_user_type']) > 0 && 
						is_exists_items_for_user_type_and_status_type($status_type_r['s_status_type'], $status_type_r['min_create_user_type']))
				{
					echo format_error_block(
								array('error'=>'Status type not updated',
									'detail'=>'Item instance(s) exist for user(s) whose type, is not compatible with the new \''.$_COLUMN_DESC['min_create_user_type'].'\' (min_create_user_type) value.'));
				}
				else if($HTTP_VARS['borrow_ind'] != $status_type_r['borrow_ind'] && $HTTP_VARS['borrow_ind'] != 'Y' && $HTTP_VARS['borrow_ind'] != 'N' && is_exists_borrowed_items_for_status_type($HTTP_VARS['s_status_type'], TRUE))
				{
					echo format_error_block(
								array('error'=>'Status type not updated',
									'detail'=>'Cannot update borrow_ind to \''.$HTTP_VARS['borrow_ind'].'\', as '.$status_type_r['description'].' item instance(s) exist, which are currently checked out.'));
				}
				else if($HTTP_VARS['borrow_ind'] != $status_type_r['borrow_ind'] && $HTTP_VARS['borrow_ind'] != 'Y' && $HTTP_VARS['borrow_ind'] != 'N' && $HTTP_VARS['borrow_ind'] != 'B' && is_exists_borrowed_items_for_status_type($HTTP_VARS['s_status_type']))
				{
					echo format_error_block(
								array('error'=>'Status type not updated',
									'detail'=>'Cannot update borrow_ind to \''.$HTTP_VARS['borrow_ind'].'\', as '.$status_type_r['description'].' item instance(s) exist, which have borrowed item(s) attached.'));
				}
				else
				{
					if(update_s_status_type($HTTP_VARS['s_status_type'], $HTTP_VARS['description'], $HTTP_VARS['img'], 
								$HTTP_VARS['insert_ind'], $HTTP_VARS['update_ind'], $HTTP_VARS['delete_ind'], 
								$HTTP_VARS['min_display_user_type'], $HTTP_VARS['min_create_user_type'],
								$HTTP_VARS['new_owner_instance_ind'], $HTTP_VARS['new_not_owner_instance_ind'],
								$HTTP_VARS['borrow_ind'], $HTTP_VARS['status_comment_ind'], $HTTP_VARS['default_ind'],
								$HTTP_VARS['closed_ind']))
					{
						echo "<div class=\"success\">Status type updated</a>";
					}
					else
					{
						echo format_error_block(array('error'=>'Status type not updated','detail'=>mysql_error()));
					}
				}
			}
			else
			{
				echo format_error_block('Invalid status type specified');
			}
		}
		else if($HTTP_VARS['op'] == 'insert')
		{
			if(strlen($HTTP_VARS['s_status_type'])>0 && !is_valid_s_status_type($HTTP_VARS['s_status_type']))
			{
				if(insert_s_status_type($HTTP_VARS['s_status_type'], $HTTP_VARS['description'], $HTTP_VARS['img'], 
								$HTTP_VARS['insert_ind'], $HTTP_VARS['update_ind'], $HTTP_VARS['delete_ind'], 
								$HTTP_VARS['min_display_user_type'], $HTTP_VARS['min_create_user_type'],
								$HTTP_VARS['new_owner_instance_ind'], $HTTP_VARS['new_not_owner_instance_ind'],
								$HTTP_VARS['borrow_ind'], $HTTP_VARS['status_comment_ind'], $HTTP_VARS['default_ind']))
				{
					display_s_status_type_chooser($PHP_SELF, $HTTP_VARS['type'], $HTTP_VARS['s_status_type']);
					echo("\n<h3>Insert Status type</h3>");
					echo "<div class=\"success\">Status type inserted.</a>";
				}
				else
				{
					display_s_status_type_chooser($PHP_SELF, $HTTP_VARS['type'], $HTTP_VARS['s_status_type']);
					echo format_error_block(array('error'=>'Status type ('.$HTTP_VARS['s_status_type'].') not inserted','detail'=>mysql_error()));
				}
			}
			else
			{
				if(strlen($HTTP_VARS['s_status_type'])>0)
				{
					// We are reloading the New form, so pass message down to be displayed there.
					$error_message = format_error_block('Status type exists');
					$HTTP_VARS['op'] = 'new';
				}
				else
					echo format_error_block('Invalid status type specified');
			}
		}
		
		// Allows reset of $HTTP_VARS['op'] to 'new' by insert process
		if(strlen($HTTP_VARS['op'])==0 || $HTTP_VARS['op'] == 'new' || $HTTP_VARS['op'] == 'edit')
		{
			// Include validation javascript here.
			echo get_validation_javascript();
			echo get_popup_javascript();

			display_s_status_type_chooser($PHP_SELF, $HTTP_VARS['type'], $HTTP_VARS['s_status_type']);
				
			if($HTTP_VARS['op'] == 'new')
			{
				echo("\n<br><h3>New Status type</h3>");
				if(strlen($error_message)>0)
					echo($error_message);

				echo("\n<table cellspacing=2 border=0>");
				echo("\n<form name=\"s_status_type\" action=\"$PHP_SELF\" method=\"post\">");
	
				echo("\n<input type=\"hidden\" name=\"op\" value=\"insert\">");
				echo("\n<input type=\"hidden\" name=\"type\" value=\"".$HTTP_VARS['type']."\">");
				
				display_edit_form(NULL, $HTTP_VARS);
				echo("\n<tr><td colspan=\"2\" align=center>");
				if($CONFIG_VARS['widgets.enable_javascript_validation']!==FALSE)
					echo("\n<input type=button value=\"Insert\" onclick=\"if(!checkForm(this.form)){return false;}else{this.form.submit();}\">");
				else
					echo("\n<input type=button value=\"Insert\" onclick=\"this.form.submit();\">");
				echo("\n</td></tr>");

				echo("\n</form>");
				echo("\n</table>");
			}
			else if($HTTP_VARS['op'] == 'edit' && is_valid_s_status_type($HTTP_VARS['s_status_type']))
			{
				echo("\n<br><h3>Edit Status type</h3>");

				$status_type_r = fetch_status_type_r($HTTP_VARS['s_status_type']);
				if($status_type_r!==FALSE)
				{
					echo("\n<table cellspacing=2 border=0>");
					echo("\n<form name=\"s_status_type\" action=\"$PHP_SELF\" method=\"post\">");
	
					echo("\n<input type=\"hidden\" name=\"op\" value=\"update\">");
					echo("\n<input type=\"hidden\" name=\"type\" value=\"".$HTTP_VARS['type']."\">");

					display_edit_form($status_type_r);
					
					echo("\n<tr><td colspan=\"2\" align=center>");
					
					if($CONFIG_VARS['widgets.enable_javascript_validation']!==FALSE)
					{
						echo("\n<input type=button value=\"Update\" onclick=\"if(!checkForm(this.form)){return false;}else{this.form.submit();}\">");
						echo("\n&nbsp;<input type=button value=\"Delete\" onclick=\"if(!checkForm(this.form)){return false;}else{this.form['op'].value='delete'; this.form.submit();}\">");
					}
					else
					{
						echo("\n<input type=button value=\"Update\" onclick=\"this.form.submit();\">");
						echo("\n&nbsp;<input type=button value=\"Delete\" onclick=\"this.form['op'].value='delete'; this.form.submit();\">");
					}
					echo("\n</td></tr>");

					echo("\n</form>");
					echo("\n</table>");
				}
				else
				{
					echo format_error_block('Status type ('.$HTTP_VARS['s_status_type'].') not found');
				}
			}
		}
	}//if(is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']))
}//if(is_opendb_valid_session())
?>