// File:	StepToGeom_MakeEllipse2d.cxx
// Created:	Thu Sep  1 13:57:24 1994
// Author:	Frederic MAUPAS
//		<fma@minox>
//:o9 abv 19.02.99: bm4_id_punch_b.stp #678: treatment of minR > maxR
//                  NOTE: parametrisation of resulting ellipse shifted on pi/2

#include <StepToGeom_MakeEllipse2d.ixx>
#include <StepGeom_Ellipse.hxx>
#include <StepGeom_Axis2Placement2d.hxx>
#include <Geom2d_AxisPlacement.hxx>
#include <StepToGeom_MakeAxisPlacement.hxx>
#include <gp_Ax2.hxx>
#include <gp_Ax22d.hxx>

#include <StdFail_NotDone.hxx>

//=============================================================================
// Creation d' un Ellipse de Geom2d a partir d' un Ellipse de Step
//=============================================================================

StepToGeom_MakeEllipse2d::StepToGeom_MakeEllipse2d
  ( const Handle(StepGeom_Ellipse)& C)
{
  StepGeom_Axis2Placement           AxisSelect;
  Handle(StepGeom_Axis2Placement2d) A;
  Handle(Geom2d_AxisPlacement)   A1;
  gp_Ax22d                       A2;
  Standard_Real                  majorR, minorR;

  AxisSelect  = C->Position();
  if (AxisSelect.CaseNum(AxisSelect.Value()) == 1) {
    StepToGeom_MakeAxisPlacement
      MkAxis(Handle(StepGeom_Axis2Placement2d)::DownCast(AxisSelect.Value()));
    A1 = MkAxis.Value();
    A2 = gp_Ax22d( A1->Ax2d() );
    majorR  = C->SemiAxis1(); 
    minorR  = C->SemiAxis2(); 
    if ( majorR - minorR >= 0. ) { //:o9 abv 19 Feb 99: bm4_id_punch_b.stp #678: protection
      theEllipse = new Geom2d_Ellipse(A2, majorR, minorR);
      done = Standard_True;
    }
    else {
      gp_Dir2d X = A2.XDirection();
      A2.SetXDirection ( gp_Dir2d ( X.X(), -X.Y() ) );
      theEllipse = new Geom2d_Ellipse(A2, majorR, minorR);
      done = Standard_True;
    }
  }
  else {
    done= Standard_False;
  }
}

//=============================================================================
// renvoi des valeurs
//=============================================================================

const Handle(Geom2d_Ellipse) &
      StepToGeom_MakeEllipse2d::Value() const
{
  StdFail_NotDone_Raise_if(!done == Standard_True,"");
  return theEllipse;
}
