// File:	StepToGeom_MakeCylindricalSurface.cxx
// Created:	Fri Jul  2 17:20:46 1993
// Author:	Martine LANGLOIS
//		<mla@mastox>

#include <StepToGeom_MakeCylindricalSurface.ixx>
#include <Geom_CylindricalSurface.hxx>
#include <StepGeom_Axis2Placement3d.hxx>
#include <StepToGeom_MakeAxis2Placement.hxx>
#include <Geom_Axis2Placement.hxx>
#include <gp_Ax2.hxx>
#include <StdFail_NotDone.hxx>
#include <UnitsMethods.hxx>

//=============================================================================
// Creation d' une CylindricalSurface de Geom a partir d' une 
// CylindricalSurface de Step
//=============================================================================

StepToGeom_MakeCylindricalSurface::StepToGeom_MakeCylindricalSurface
  ( const Handle(StepGeom_CylindricalSurface)& S)
{
  Standard_Real R;
  Handle(StepGeom_Axis2Placement3d) A;
  Handle(Geom_Axis2Placement)           A1;
  gp_Ax2                                A2;

  R   = S->Radius() * UnitsMethods::LengthFactor();
  A   = S->Position();
  StepToGeom_MakeAxis2Placement MkAxis2(A);
  A1  = MkAxis2.Value();
  A2  = A1->Ax2();
  theCylindricalSurface = new Geom_CylindricalSurface(A2, R);
  done = Standard_True;
}

//=============================================================================
// renvoi des valeurs
//=============================================================================

const Handle(Geom_CylindricalSurface) &
      StepToGeom_MakeCylindricalSurface::Value() const
{
  StdFail_NotDone_Raise_if(!done == Standard_True,"");
  return theCylindricalSurface;
}
