/***********************************************************************

     FONCTION :
     ----------
        File OpenGl_textcontextgroup :
 

     REMARQUES:
     ---------- 

     HISTORIQUE DES MODIFICATIONS   :
     --------------------------------
       xx-xx-xx : xxx ; Creation.
       03-09-97 : FMN ; Ajout traitement Begin/EndPrimitives()
       03-03-98 : CAL ; Modification des structures CALL_DEF_GROUP et STRUCTURE
       30-11-98 : FMN ; S4069 : Textes toujours visibles

************************************************************************/

/*----------------------------------------------------------------------*/
/*
 * Includes
 */ 

#define OCC2934   /* SAN 22/01/04 Texture mapped fonts on WNT */

#include <OpenGl_tgl_all.h>
#include <InterfaceGraphic_Graphic3d.hxx>
#include <OpenGl_tgl.h>
#include <OpenGl_tgl_funcs.h>
#include <OpenGl_tgl_subrs.h>
#include <OpenGl_context.h>
#include <OpenGl_tgl_utilgr.h>

/*----------------------------------------------------------------------*/

void EXPORT
call_togl_textcontextgroup
(
	CALL_DEF_GROUP * agroup,
	int noinsert
)
{
    /* for the group */
    Tchar   *fontid=NULL;
    Tfloat    textr, textg, textb;
    Tfloat    textrs, textgs, textbs;
    Tfloat    textspace;
    Tfloat    textexpan;
    int	    textstyle, textdisplaytype;
#if defined(OCC2934) && defined(WNT)
    int     texmappedfont;
#endif

    /* for the structure */
    Tchar   *Fontid=NULL;
    Tfloat    Textr, Textg, Textb;
    Tfloat    Textrs, Textgs, Textbs;
    Tfloat    Textspace;
    Tfloat    Textexpan;
    int	    Textstyle, Textdisplaytype;
#if defined(OCC2934) && defined(WNT)
    int     Texmappedfont;
#endif

/* ABD 29/10/04  Transform Persistence of Presentation( pan, zoom, rotate ) */
    /*int     TransPers = agroup->Struct->TransformPersistenceFlag;*/
/* ABD 29/10/04  Transform Persistence of Presentation( pan, zoom, rotate ) */

    /*
     * Si le groupe est ouvert cela signifie que BeginPrimitives
     * a ete utilise.
     * Dans le cas des markers composes, il faut refermer temporairement
     * le groupe pour eviter des insertions d'attributs aleatoires.
     */
    if (agroup->IsOpen) call_togl_closegroup (agroup);

    if( agroup->ContextText.IsDef )
    {
        textr = agroup->ContextText.Color.r;
        textg = agroup->ContextText.Color.g;
        textb = agroup->ContextText.Color.b;
        textrs = agroup->ContextText.ColorSubTitle.r;
        textgs = agroup->ContextText.ColorSubTitle.g;
        textbs = agroup->ContextText.ColorSubTitle.b;

        switch( agroup->ContextText.Font )
        {
            case 0 : /* Graphic3d_NOF_ASCII_MONO */
                fontid = CALL_PHIGS_ASCII_MONO;
                break;
            case 1 : /* Graphic3d_NOF_ASCII_SIMPLEX */
                fontid = CALL_PHIGS_ASCII_SIMPLEX;
                break;
            case 2 : /* Graphic3d_NOF_ASCII_DUPLEX */
                fontid = CALL_PHIGS_ASCII_DUPLEX;
                break;
            case 3 : /* Graphic3d_NOF_ASCII_COMPLEX */
                fontid = CALL_PHIGS_ASCII_COMPLEX;
                break;
            case 4 : /* Graphic3d_NOF_ASCII_TRIPLEX */
                fontid = CALL_PHIGS_ASCII_TRIPLEX;
                break;
            case 5 : /* Graphic3d_NOF_ASCII_ITALIC_COMPLEX */
                fontid = CALL_PHIGS_ASCII_ITALIC_COMPLEX;
                break;
            case 6 : /* Graphic3d_NOF_ASCII_ITALIC_TRIPLEX */
                fontid = CALL_PHIGS_ASCII_ITALIC_TRIPLEX;
                break;
            case 7 : /* Graphic3d_NOF_ASCII_SCRIPT_SIMPLEX */
                fontid = CALL_PHIGS_ASCII_SCRIPT_SIMPLEX;
                break;
            case 8 : /* Graphic3d_NOF_GREEK_MONO */
                fontid = CALL_PHIGS_GREEK_MONO;
                break;
            case 9 : /* Graphic3d_NOF_GREEK_SIMPLEX */
                fontid = CALL_PHIGS_GREEK_SIMPLEX;
                break;
            case 10 : /* Graphic3d_NOF_GREEK_COMPLEX */
                fontid = CALL_PHIGS_GREEK_COMPLEX;
                break;
            case 11 : /* Graphic3d_NOF_SYMBOL_MONO */
                fontid = CALL_PHIGS_SYMBOL_MONO;
                break;
            case 12 : /* Graphic3d_NOF_SYMBOL_SIMPLEX */
                fontid = CALL_PHIGS_SYMBOL_SIMPLEX;
                break;
            case 13 : /* Graphic3d_NOF_CARTOGRAPHIC_SIMPLEX */
                fontid = CALL_PHIGS_CARTOGRAPHIC_SIMPLEX;
                break;
            case 14 : /* Graphic3d_NOF_KANJI_MONO */
                fontid = CALL_PHIGS_KANJI_MONO;
                break;
            case 15 : /* Graphic3d_NOF_KATAKANA_MONO */
                fontid = CALL_PHIGS_KATAKANA_MONO;
                break;
            default :
                break;
        }

        textspace = (Tfloat) agroup->ContextText.Space;
        textexpan = (Tfloat) agroup->ContextText.Expan;
        textstyle = (int) agroup->ContextText.Style;
        textdisplaytype = (int) agroup->ContextText.DisplayType;
#if defined(OCC2934) && defined(WNT)
        texmappedfont = (int) agroup->ContextText.TextureMappedFont;
#endif

        Textr = agroup->Struct->ContextText.Color.r;
        Textg = agroup->Struct->ContextText.Color.g;
        Textb = agroup->Struct->ContextText.Color.b;

        Textrs = agroup->Struct->ContextText.ColorSubTitle.r;
        Textgs = agroup->Struct->ContextText.ColorSubTitle.g;
        Textbs = agroup->Struct->ContextText.ColorSubTitle.b;

        switch( agroup->Struct->ContextText.Font )
        {
            case 0 : /* Graphic3d_NOF_ASCII_MONO */
                Fontid = CALL_PHIGS_ASCII_MONO;
                break;
            case 1 : /* Graphic3d_NOF_ASCII_SIMPLEX */
                Fontid = CALL_PHIGS_ASCII_SIMPLEX;
                break;
            case 2 : /* Graphic3d_NOF_ASCII_DUPLEX */
                Fontid = CALL_PHIGS_ASCII_DUPLEX;
                break;
            case 3 : /* Graphic3d_NOF_ASCII_COMPLEX */
                Fontid = CALL_PHIGS_ASCII_COMPLEX;
                break;
            case 4 : /* Graphic3d_NOF_ASCII_TRIPLEX */
                Fontid = CALL_PHIGS_ASCII_TRIPLEX;
                break;
            case 5 : /* Graphic3d_NOF_ASCII_ITALIC_COMPLEX */
                Fontid = CALL_PHIGS_ASCII_ITALIC_COMPLEX;
                break;
            case 6 : /* Graphic3d_NOF_ASCII_ITALIC_TRIPLEX */
                Fontid = CALL_PHIGS_ASCII_ITALIC_TRIPLEX;
                break;
            case 7 : /* Graphic3d_NOF_ASCII_SCRIPT_SIMPLEX */
                Fontid = CALL_PHIGS_ASCII_SCRIPT_SIMPLEX;
                break;
            case 8 : /* Graphic3d_NOF_GREEK_MONO */
                Fontid = CALL_PHIGS_GREEK_MONO;
                break;
            case 9 : /* Graphic3d_NOF_GREEK_SIMPLEX */
                Fontid = CALL_PHIGS_GREEK_SIMPLEX;
                break;
            case 10 : /* Graphic3d_NOF_GREEK_COMPLEX */
                Fontid = CALL_PHIGS_GREEK_COMPLEX;
                break;
            case 11 : /* Graphic3d_NOF_SYMBOL_MONO */
                Fontid = CALL_PHIGS_SYMBOL_MONO;
                break;
            case 12 : /* Graphic3d_NOF_SYMBOL_SIMPLEX */
                Fontid = CALL_PHIGS_SYMBOL_SIMPLEX;
                break;
            case 13 : /* Graphic3d_NOF_CARTOGRAPHIC_SIMPLEX */
                Fontid = CALL_PHIGS_CARTOGRAPHIC_SIMPLEX;
                break;
            case 14 : /* Graphic3d_NOF_KANJI_MONO */
                Fontid = CALL_PHIGS_KANJI_MONO;
                break;
            case 15 : /* Graphic3d_NOF_KATAKANA_MONO */
                Fontid = CALL_PHIGS_KATAKANA_MONO;
                break;
            default :
                break;
        }

        Textspace = (Tfloat) agroup->Struct->ContextText.Space;
        Textexpan = (Tfloat) agroup->Struct->ContextText.Expan;
        Textstyle = (int) agroup->Struct->ContextText.Style;
        Textdisplaytype = (int) agroup->Struct->ContextText.DisplayType;
#if defined(OCC2934) && defined(WNT)
        Texmappedfont = (int) agroup->Struct->ContextText.TextureMappedFont;
#endif

        if( noinsert )
        {
            if( agroup->ContextText.IsSet )
                call_func_set_edit_mode( CALL_PHIGS_EDIT_REPLACE );
            else
                call_func_set_edit_mode( CALL_PHIGS_EDIT_INSERT );
            call_func_open_struct( agroup->Struct->Id );

            call_func_set_elem_ptr( 0 );
            call_func_set_elem_ptr_label( agroup->LabelBegin );
            if( agroup->PickId.IsSet )
                call_func_offset_elem_ptr( 1 );
            if( agroup->ContextLine.IsSet )
                call_func_offset_elem_ptr( CALL_DEF_CONTEXTLINE_SIZE );
            if( agroup->ContextFillArea.IsSet )
                call_func_offset_elem_ptr( CALL_DEF_CONTEXTFILLAREA_SIZE );
            if( agroup->ContextMarker.IsSet )
                call_func_offset_elem_ptr( CALL_DEF_CONTEXTMARKER_SIZE );
#if defined(OCC2934) && defined(WNT)
            if( agroup->ContextText.IsSet )
                call_func_offset_elem_ptr( 1 );
            call_func_set_tex_mapped_font( texmappedfont );
#endif
            if( agroup->ContextText.IsSet )
                call_func_offset_elem_ptr( 1 );
            call_func_set_text_font( fontid );
            if( agroup->ContextText.IsSet )
                call_func_offset_elem_ptr( 1 );
            call_func_set_char_space( textspace );
            if( agroup->ContextText.IsSet )
                call_func_offset_elem_ptr( 1 );
            call_func_set_char_expan( textexpan );
            if( agroup->ContextText.IsSet )
                call_func_offset_elem_ptr( 1 );
            call_subr_set_text_colr( textr, textg, textb );
            if( agroup->ContextText.IsSet )
                call_func_offset_elem_ptr( 1 );
            call_func_set_text_style( textstyle );
            if( agroup->ContextText.IsSet )
                call_func_offset_elem_ptr( 1 );
            call_func_set_text_display_type( textdisplaytype );
            if( agroup->ContextText.IsSet )
                call_func_offset_elem_ptr( 1 );
            call_subr_set_text_colr_subtitle( textrs, textgs, textbs );

            call_func_set_elem_ptr_label( agroup->LabelEnd );
            call_func_offset_elem_ptr(-call_util_context_group_place(agroup)-1);
            if( agroup->ContextLine.IsSet )
                call_func_offset_elem_ptr( CALL_DEF_CONTEXTLINE_SIZE );
            if( agroup->ContextFillArea.IsSet )
                call_func_offset_elem_ptr( CALL_DEF_CONTEXTFILLAREA_SIZE );
            if( agroup->ContextMarker.IsSet )
                call_func_offset_elem_ptr( CALL_DEF_CONTEXTMARKER_SIZE );
#if defined(OCC2934) && defined(WNT)
            if( agroup->ContextText.IsSet )
                call_func_offset_elem_ptr( 1 );
            call_func_set_tex_mapped_font( Texmappedfont );
#endif
/* ABD 29/10/04  Transform Persistence of Presentation( pan, zoom, rotate ) */
            /*call_func_offset_elem_ptr( 1 );*/
	    /*call_func_set_transform_persistence( TransPers );*/
/* ABD 29/10/04  Transform Persistence of Presentation( pan, zoom, rotate ) */
            if( agroup->ContextText.IsSet )
                call_func_offset_elem_ptr( 1 );
            call_func_set_text_font( Fontid );
            if( agroup->ContextText.IsSet )
                call_func_offset_elem_ptr( 1 );
            call_func_set_char_space( Textspace );
            if( agroup->ContextText.IsSet )
                call_func_offset_elem_ptr( 1 );
            call_func_set_char_expan( Textexpan );
            if( agroup->ContextText.IsSet )
                call_func_offset_elem_ptr( 1 );
            call_subr_set_text_colr( Textr, Textg, Textb );
            if( agroup->ContextText.IsSet )
                call_func_offset_elem_ptr( 1 );
            call_func_set_text_style( Textstyle );
            if( agroup->ContextText.IsSet )
                call_func_offset_elem_ptr( 1 );
            call_func_set_text_display_type( Textdisplaytype );
            if( agroup->ContextText.IsSet )
                call_func_offset_elem_ptr( 1 );
            call_subr_set_text_colr_subtitle( Textrs, Textgs, Textbs );
            call_func_close_struct();
        } /* no insert */

        if( noinsert == 0 )
        {
            call_func_set_edit_mode( CALL_PHIGS_EDIT_INSERT );
            call_func_open_struct( agroup->Struct->Id );

            call_func_set_elem_ptr( 0 );
            call_func_set_elem_ptr_label( agroup->LabelEnd );
            call_func_offset_elem_ptr(-call_util_context_group_place(agroup)-1);
#if defined(OCC2934) && defined(WNT)
            call_func_set_tex_mapped_font( texmappedfont );
#endif

/* ABD 29/10/04  Transform Persistence of Presentation( pan, zoom, rotate ) */
	    /*call_func_set_transform_persistence( TransPers );*/
/* ABD 29/10/04  Transform Persistence of Presentation( pan, zoom, rotate ) */

            call_func_set_text_font( fontid );
            call_func_set_char_space( textspace );
            call_func_set_char_expan( textexpan );
            call_subr_set_text_colr( textr, textg, textb );
	    call_func_set_text_style( textstyle );
	    call_func_set_text_display_type( textdisplaytype );
            call_subr_set_text_colr_subtitle( textrs, textgs, textbs );

            if( agroup->ContextLine.IsSet )
                call_func_offset_elem_ptr( CALL_DEF_CONTEXTLINE_SIZE );
            if( agroup->ContextFillArea.IsSet )
                call_func_offset_elem_ptr( CALL_DEF_CONTEXTFILLAREA_SIZE );
            if( agroup->ContextMarker.IsSet )
                call_func_offset_elem_ptr( CALL_DEF_CONTEXTMARKER_SIZE );
            if( !agroup->ContextText.IsSet )
            {
#if defined(OCC2934) && defined(WNT)
                call_func_set_tex_mapped_font( Texmappedfont );
#endif
                call_func_set_text_font( Fontid );
                call_func_set_char_space( Textspace );
                call_func_set_char_expan( Textexpan );
                call_subr_set_text_colr( Textr, Textg, Textb );
		call_func_set_text_style( Textstyle );
		call_func_set_text_display_type( Textdisplaytype );
                call_subr_set_text_colr_subtitle( Textrs, Textgs, Textbs );
            }
            call_func_close_struct();
        } /* insert */
    }
    /* Voir commentaire en debut de fonction */
    if (agroup->IsOpen) call_togl_opengroup (agroup);
    return;
}
