// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IGESSolid_ConeFrustum_HeaderFile
#define _IGESSolid_ConeFrustum_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_IGESSolid_ConeFrustum_HeaderFile
#include <Handle_IGESSolid_ConeFrustum.hxx>
#endif

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _gp_XYZ_HeaderFile
#include <gp_XYZ.hxx>
#endif
#ifndef _IGESData_IGESEntity_HeaderFile
#include <IGESData_IGESEntity.hxx>
#endif
class gp_XYZ;
class gp_Pnt;
class gp_Dir;


//! defines ConeFrustum, Type <156> Form Number <0> <br>
//!          in package IGESSolid <br>
//!          The Cone Frustum is defined by the center of the <br>
//!          larger circular face of the frustum, its radius, a unit <br>
//!          vector in the axis direction, a height in this direction <br>
//!          and a second circular face with radius which is lesser <br>
//!          than the first face. <br>
class IGESSolid_ConeFrustum : public IGESData_IGESEntity {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT IGESSolid_ConeFrustum();

//! This method is used to set the fields of the class <br>
//!           ConeFrustum <br>
//!       - Ht     : the Height of cone <br>
//!       - R1     : Radius of the larger face <br>
//!       - R2     : Radius of the smaller face (default 0) <br>
//!       - Center : Center of the larger face (default (0,0,0)) <br>
//!       - anAxis : Unit vector in axis direction (default (0,0,1)) <br>
Standard_EXPORT   void Init(const Standard_Real Ht,const Standard_Real R1,const Standard_Real R2,const gp_XYZ& Center,const gp_XYZ& anAxis) ;

//! returns the height of the cone frustum <br>
Standard_EXPORT   Standard_Real Height() const;

//! returns the radius of the larger face of the cone frustum <br>
Standard_EXPORT   Standard_Real LargerRadius() const;

//! returns the radius of the second face of the cone frustum <br>
Standard_EXPORT   Standard_Real SmallerRadius() const;

//! returns the center of the larger face of the cone frustum <br>
Standard_EXPORT   gp_Pnt FaceCenter() const;

//! returns the center of the larger face of the cone frustum <br>
//! after applying TransformationMatrix <br>
Standard_EXPORT   gp_Pnt TransformedFaceCenter() const;

//! returns the direction of the axis of the cone frustum <br>
Standard_EXPORT   gp_Dir Axis() const;

//! returns the direction of the axis of the cone frustum <br>
//! after applying TransformationMatrix <br>
Standard_EXPORT   gp_Dir TransformedAxis() const;
//Standard_EXPORT ~IGESSolid_ConeFrustum();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Real theHeight;
Standard_Real theR1;
Standard_Real theR2;
gp_XYZ theFaceCenter;
gp_XYZ theAxis;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
