// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Geom2d_Direction_HeaderFile
#define _Geom2d_Direction_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Geom2d_Direction_HeaderFile
#include <Handle_Geom2d_Direction.hxx>
#endif

#ifndef _Geom2d_Vector_HeaderFile
#include <Geom2d_Vector.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_Geom2d_Vector_HeaderFile
#include <Handle_Geom2d_Vector.hxx>
#endif
#ifndef _Handle_Geom2d_Geometry_HeaderFile
#include <Handle_Geom2d_Geometry.hxx>
#endif
class Standard_ConstructionError;
class gp_Dir2d;
class Geom2d_Vector;
class gp_Trsf2d;
class Geom2d_Geometry;



//!  The class Direction specifies a vector that is never null. <br>
//!  It is a unit vector. <br>
class Geom2d_Direction : public Geom2d_Vector {

public:
 // Methods PUBLIC
 // 

//! Creates a unit vector with it 2 cartesian coordinates. <br>
//!  Raised if Sqrt( X*X + Y*Y) <= Resolution from gp. <br>
Standard_EXPORT Geom2d_Direction(const Standard_Real X,const Standard_Real Y);

//! Creates a persistent copy of <me>. <br>
Standard_EXPORT Geom2d_Direction(const gp_Dir2d& V);

//! Assigns the coordinates X and Y to this unit vector, <br>
//! then normalizes it. <br>
//! Exceptions <br>
//! Standard_ConstructionError if Sqrt(X*X + <br>
//! Y*Y) is less than or equal to gp::Resolution(). <br>
Standard_EXPORT   void SetCoord(const Standard_Real X,const Standard_Real Y) ;

//! Converts the gp_Dir2d unit vector V into this unit vector. <br>
Standard_EXPORT   void SetDir2d(const gp_Dir2d& V) ;


//! Assigns a value to the X coordinate of this unit vector, then normalizes it. <br>
//! Exceptions <br>
//! Standard_ConstructionError if the value assigned <br>
//! causes the magnitude of the vector to become less <br>
//! than or equal to gp::Resolution(). <br>
Standard_EXPORT   void SetX(const Standard_Real X) ;

//! Assigns a value to the Y coordinate of this unit vector, then normalizes it. <br>
//! Exceptions <br>
//! Standard_ConstructionError if the value assigned <br>
//! causes the magnitude of the vector to become less <br>
//! than or equal to gp::Resolution(). <br>
Standard_EXPORT   void SetY(const Standard_Real Y) ;

//! Converts this unit vector into a gp_Dir2d unit vector. <br>
Standard_EXPORT   gp_Dir2d Dir2d() const;

//! returns 1.0 <br>
Standard_EXPORT   Standard_Real Magnitude() const;

//! returns 1.0 <br>
Standard_EXPORT   Standard_Real SquareMagnitude() const;

//! Computes the cross product between <me> and <Other>. <br>
Standard_EXPORT   Standard_Real Crossed(const Handle(Geom2d_Vector)& Other) const;
  Standard_Real operator ^(const Handle(Geom2d_Vector)& Other) const
{
  return Crossed(Other);
}


//! Applies the transformation T to this unit vector, then normalizes it. <br>
Standard_EXPORT   void Transform(const gp_Trsf2d& T) ;

//! Creates a new object which is a copy of this unit vector. <br>
Standard_EXPORT   Handle_Geom2d_Geometry Copy() const;
//Standard_EXPORT ~Geom2d_Direction();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
