#!/usr/bin/perl
# -d

$storage=0;
$lang=0;
$err=0;
$passwd_file=0;
$passwd_pgsql=0;
$passwd_mysql=0;
$customlog=0;
$berkeley_db=0;
$gigabase_db=0;

open(IN,  "src/oops.cfg");
while( <IN> ) {
	$in=$_;
	$out=$in;
	if( $in =~ /nameserver\s+[0-9.]+/ ) {
		$out=$in; $out=~ s/[0-9.]+/127.0.0.1/;
		$out="#$out";
	}
#	if( $in =~ /http_port\s+[0-9]+/ ) {
#		$out=$in; $out=~ s/[0-9]+/13128/;
#	}
#	if( $in =~ /icp_port\s+[0-9]+/ ) {
#		$out=$in; $out=~ s/[0-9]+/13130/;
#	}
	if( $in =~ /^logfile\s+\/(.*)/ ) {
		$out = "logfile\t/var/log/oops/oops.log\n";
	}
	if( $in =~ /^#logfile\s+/ ) {
		$out = "";
	}
	if( $in =~ /^accesslog\s+/ ) {
		$out = "accesslog\t/var/log/oops/access.log\n";
	}
	if( $in =~ /^#accesslog\s+/ ) {
		$out = "";
	}
	if( $in =~ /icons-host\s+/ ) {
		$out=$in;
		$out=~ s/ss5.paco.net/127.0.0.1/;
	}
	if( $in =~ /^#always_check_freshness$/ ) {
		$out = "always_check_freshness\n";
	}
	if( $in =~ /^local-domain/ ) {
		$out = "#$in";
	}
	if( $in =~ /^local-networks/ ) {
		$out = "local-networks\t10/8 192.168/16\n"
	}
	#storage {..}
	if( $in =~ /storage\s+\{/ ) { $storage=1; }
	if( $storage==1 && $in =~ /path\s+/ ) { 
		$out=$in; 
		$out =~ s/\/usr\/lib/\/var\/spool/;
	}
	if( $storage==1 && $in=~ /\}/ ) { $storage=0; }
	#module lang {..}
	if( $in=~ /^module\s+lang\s+\{/ ) { $lang=1; }
	if( $lang==1 ) { $out="#$in"; }
	if( $lang==1 && $in=~ /\}/ ) { $lang=0; $out="#$in"; }
	#module err {..}
	if( $in=~ /module\s+err\s+\{/ ) { $err=1; }
	if( $err==1 && $in=~ /lang\s+ru/ ) { 
		$out=$in;
		$out=~ s/(.*lang\s+)(ru)/$1us/;
	}
	#module passwd_pgsql {..} -- not implemeted filename changes
	if( $in=~ /module\s+passwd_pgsql\s+\{/ ) { $passwd_pgsql=1; }
	if( $passwd_pgsql==1 ) { $out="#$in"; }
	if( $passwd_pgsql==1 && $in=~ /\}/ ) { $passwd_pgsql=0; $out="#$in"; }
	#module passwd_mysql {..} -- not implemeted filename changes
	if( $in=~ /^module\s+passwd_mysql\s+\{/ ) { $passwd_mysql=1; }
	if( $passwd_mysql==1 ) { $out="#$in"; }
	if( $passwd_mysql==1 && $in=~ /\}/ ) { $passwd_mysql=0; $out="#$in"; }
	#module customlog {..}
	if( $in=~ /module\s+customlog\s\{/ ) { $customlog=1; }
	if( $customlog==1 && $in=~ /path\s+\// ) { $out=$in; $out=~ s/\/usr\/local\/oops\/logs\//\/var\/log\/oops\//; }
	if( $customlog==1 && $in=~ /\}/ ) { $customlog=0; }
	#module berkeley_db {..}
	if( $in=~ /^module\s+berkeley_db\s+\{/ ) { $berkeley_db=1; }
	if( $berkeley_db==1 && $in=~ /\s+dbhome\s+\// ) { $out=$in; $out=~ s/\/usr\/lib/\/var\/spool/; }
	if( $berkeley_db==1 && $in=~ /\}/ ) { $berkeley_db=0; }
	#module gigabase_db {..}
	if( $in=~ /module\s+gigabase_db\s+\{/ ) { $gigabase_db=1; }
	if( $gigabase_db==1 ) { $out=""; }
	if( $gigabase_db==1 && $in=~ /\}/ ) { $gigabase_db=0; $out=""; }

	print $out;
}

close( IN );
