#!/usr/bin/perl
#
# updatehours.cgi
#
# Copyright 1999 -- 2001, onShore Development Inc. <URL:http://www.onshore-devel.com/>
#
#
# This program is free software under the terms of the GNU General Public
# License (GPL). A copy of the GPL, "COPYING", should have been made
# available with this software.  If not, a copy may be obtained at 
# http://www.fsf.org/copyleft/gpl.html
#
#
# $Id: updatehours.cgi,v 1.7 2001/08/29 22:22:45 adam Exp $ 

use CGI qw(:standard);
use ADB;

require 'etc/timesheet.conf';
require 'lib/common-funcs.pl';

# record the URL that wsused to generate the search that is
# submiting to us.
my $result_url = param('search_url');

my $dbconn = 0;
my $current_user = remote_user;


sub approve_hours {
    my $hid = shift;
    my $tempcurrent = shift;
    my $temptarget = shift;
    unless ($dbconn) {
	$dbconn = new ADB($Conf::DBADDR,$Conf::SQLDB);
	if ( ! $dbconn->is_ok ) {
	    $oops = $dbconn->errorstring;
	    &error("Failed connection to backend updatehours: $oops");
	}
    }

    my $current;
    $current = 0 if $tempcurrent eq 'n';
    $current = 1 if $tempcurrent eq 'y';

    my $target;
    $target = 0 if $temptarget eq 'n';
    $target = 1 if $temptarget eq 'y';

    # Set up our approval data
    my $date_sql;
    my $today = &dbdate_today;
    
    if ( $current != $target ) {
	if ( $target ) {
	    $date_sql = "approval_date = '$today' ";
	} else {
	    $date_sql = "approval_date = '$Conf::DUMMY_APPROVAL_DATE' ";
	}
	my $sql = "UPDATE $Conf::HOURS_DB set ";
	$sql .= $date_sql;
	$sql .= "WHERE hours_id = $hid;";
	my $sqlresult = $dbconn->query($sql);
	if ( ! $sqlresult ) {
	    my $oops = $dbconn->errorstring;
	    &error("Approval error on hours ID $hid: $oops", $sql);
	}
    }
}



# Here is where the real action starts

$dbconn = new ADB($Conf::DBADDR,$Conf::SQLDB);
if ( !$dbconn->is_ok ) {
    $oops = $dbconn->errorstring;
    &error("Failed connection to backend: $oops");
}

unless ( &is_superuser($current_user, $dbconn) ) {
    &user_error("You do not have sufficient permissions.");
}



foreach $name (param()) {
    my $hours;
    my $status;
    my $changeto;
    if ($name =~ /hours(\S*)status/) {
	$hours = $1;
	$status = param( hours . $hours . status );
	$changeto = param( hours . $hours . set );
	unless ( $changeto ) {
	    &error("Could not find desired state for hours entry: $hours");
	}
	if ( $changeto && $status ne $changeto ) {
	    &approve_hours($hours, $status, $changeto);
	}
    }		
}

print redirect($result_url);





