#!/usr/bin/perl 
# Take a file with SQL table creation and turn it
# into SGML for a Database Dictionary.
#
# Author: Greg Gallagher <ggallag@onShore.com>
# Revised by: Adam Di Carlo <adam@onshore-devel.com>
#
# $Date: 2001/08/29 01:58:15 $
# $Revision: 1.4 $
#

use strict;

my @tables;
my $num_tables;
my $table;
my %table_defs;
my $sqlfile = $ARGV[0];
my $line;
my $field_name;
my $field_type;
my $def;

if ($ARGV[0] eq '') {
    print "usage: sql2sgml <file>\n";
    print "	- where <file> is a SQL table creation script\n";
    exit 1;
}

open(SQL, "$sqlfile") || die "Couldn't open $sqlfile: $!\n";

while($line = <SQL>) {

    chop($line);

    # grab the table name, put it in the array
    if($line =~ /^CREATE\s+TABLE\s+(\w+)\s+\((.*)\/\/\s*(.*)$/) {
        push @tables, $1;
        $table = $1;
        $table_defs{$table}{table_description} = [ $3, undef ];
    }

    # grab the field name, field type and definition
    if ($line =~ /^\t+(\w+)\t+(\w*),?\t+\/\/\s*(.*)$/) {
        $field_name = $1;
        $field_type = $2;
        $def = $3;
        
        # make the structure
        $table_defs{$table}{$field_name} = [$field_type, $def];
        
    }
}

close(SQL);

# print out the tables, their names and their definitions
print "<para>\nThere are some tables in the database.  They are listed below:";

foreach $table (sort keys %table_defs){
    print "<table frame=\"all\">\n";
    print "<title>$table -- $table_defs{$table}{table_description}[0]</title>\n";
    print "<tgroup cols=\"3\" colsep=\"1\" rowsep=\"1\">\n";
    print "<colspec align=\"left\">";
    print "<thead>\n<row>\n";
    print "<entry align=\"center\" valign=\"middle\">Field Name</entry>\n";
    print "<entry align=\"center\" valign=\"middle\">Data Type</entry>\n";
    print "<entry align=\"center\" valign=\"middle\">Field Definition</entry>\n";
    print "</row>\n";
    print "</thead>\n<tbody>\n";

    foreach my $field_name (keys %{$table_defs{$table}}) {
        if ($field_name !~ /table_description/) {
            ($field_type, $def) = @{$table_defs{$table}{$field_name}};
            print "<row>\n";
            print "<entry align=\"left\" valign=\"middle\">$field_name</entry>\n";
            print "<entry align=\"center\" valign=\"middle\">$field_type</entry>\n";
            print "<entry align=\"left\" valign=\"middle\">$def</entry>\n";
            print "</row>\n";
        }
    }
    
    print "</tbody>\n</table>\n";
}

exit 0;

