/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef OMMODULE_H
#define OMMODULE_H

#include <string>
#include <libgnomecanvasmm.h>
#include "canvas/Module.h"
#include "OmGtkObject.h"
using std::string;

namespace LibOmClient {
class PortModel;
class NodeModel;
class MetadataModel;
class ControlModel;
}
using namespace LibOmClient;

namespace OmGtk {
	
class NodeControlWindow;
class PatchController;
class OmPatchBayArea;
class OmPort;


/** A module in a patch.
 *
 * This base class is extended for various types of modules - SubpatchModule,
 * DSSIModule, etc.
 *
 * \ingroup OmGtk
 */
class OmModule : public PatchBay::Module, public OmGtkObject
{
public:
	OmModule(OmPatchBayArea* patch_bay, NodeModel* node_model, PatchController* patch_controller);
	virtual ~OmModule();
	
	virtual void add_om_port(PortModel* pm, bool resize=true);
	
	virtual OmPort* port(const string& port_name) {
		return (OmPort*)Module::port(port_name);
	}

	virtual void store_location();
	void move_to(double x, double y);

	void path(const string& new_path);

	void metadata_update(const MetadataModel* const mm);

	virtual void show_control_window();
	virtual void on_double_click() { show_control_window(); }
	
	virtual void menu_learn();
	virtual void menu_rename();
	virtual void menu_remove();
	virtual void menu_disconnect_all();
	void show_menu(GdkEventButton* event) { m_menu.popup(event->button, event->time); }

	PatchController*   parent_controller()     { return m_parent; }
	NodeModel*         node_model()            { return m_node_model; }
	NodeControlWindow* control_window()        { return m_dialog; }
	void control_window(NodeControlWindow* cw) { m_dialog = cw; }

protected:
	Gtk::Menu          m_menu;
	PatchController*   m_parent;
	NodeModel*         m_node_model;
	NodeControlWindow* m_dialog;
};


} // namespace OmGtk

#endif // OMMODULE_H
