
// Include Qt stuff first to avoid ambiguities with 'debug' symbol
#include "intedit.h"
#include "floatedit.h"
#include "float1d.h"
#include "complex1d.h"
#include "float3d.h"
#include "boolbutton.h"
#include "enumbox.h"
#include "stringbox.h"

#include "jdxwidget.h"
#include "jdxblockwidget.h"



#include <odinpara/jdxtypes.h>
#include <odinpara/jdxblock.h>
#include <odinpara/jdxfunction.h>
#include <odinpara/jdxarrays.h>
#include <odinpara/jdxfilter.h>


/**
  *
  * Helper class to analayze the value range of a (scalar) JDX parameter
  */
class RangeHelper {

public:
  double minval;
  double maxval;

  RangeHelper(const JcampDxClass& ldr) {
    minval=ldr.get_minval();
    maxval=ldr.get_maxval();
  }

  bool has_range() {
    if(maxval>minval) return true;
    else return false;
  }

  double get_stepsize(unsigned int maxsteps) {
    Log<OdinQt> odinlog("RangeHelper","get_stepsize");

    double result=fabs(maxval-minval)/double(maxsteps);
    double mantisse=log10(result);
    mantisse=int(mantisse-1.0);
    result=double(int(result*pow(10.0,-mantisse)))*pow(10.0,mantisse);

    ODINLOG(odinlog,normalDebug) << "minval=" << minval << STD_endl;
    ODINLOG(odinlog,normalDebug) << "maxval=" << maxval << STD_endl;
    ODINLOG(odinlog,normalDebug) << "mantisse=" << mantisse << STD_endl;
    ODINLOG(odinlog,normalDebug) << "stepsize=" << result << STD_endl;

    return result;
  }

};


/////////////////////////////////////////////////////////////////////////



JDXwidget::JDXwidget(JcampDxClass& ldr,unsigned int columns, QWidget *parent, bool doneButton, const char* omittext, bool storeLoadButtons )
              : QWidget(parent), val(ldr) {

  Log<OdinQt> odinlog(&val,"JDXwidget(...)");

  vport=this;

  widget_cache=0;


  blockwidget=0;
  intslider=0;
  intedit=0;
  floatslider=0;
  floatedit=0;
  enumwidget=0;
  boolwidget=0;
  floatArrempty=0;
  floatArrwidget1=0;
  floatArredit=0;
//  doubleArrwidget1=0;
  floatArrwidget2=0;
  complexArrwidget=0;
  stringwidget=0;
  filenamewidget=0;
  funcwidget=0;
  formulawidget=0;
  triplewidget=0;

  grid=0;

  rows=1;
  cols=1;

  if(columns<1) columns=1;

  bool cast_success=true;

  ldrlabel_uncut=replaceStr(ldr.get_label(),omittext,"",allOccurences);
  ldrlabel=ldrlabel_uncut;

  label_cut=false;
  if(ldrlabel.length()>_MAX_LABEL_LENGTH_) {
    label_cut=true;
    ldrlabel=ldrlabel_uncut.substr(0,_MAX_LABEL_LENGTH_)+"...";
  }
  
  STD_string unit(ldr.get_unit());
  if(unit!="") ldrlabel+=" ["+unit+"]";

  ODINLOG(odinlog,normalDebug) << "ldrlabel/omittext=" << ldrlabel  << "/" << omittext << STD_endl;

  grid=new GuiGridLayout( vport, 1, 1, false);

  ODINLOG(odinlog,normalDebug) << "grid & layout done" << STD_endl;



/*---------------- JDX types BEGIN ------------------------*/


  /*---------------- JcampDxBlock ------------------------*/
  JcampDxBlock* dumblock=ldr.cast(dumblock);
  if(dumblock) {
    label_cut=false;
    if(dumblock->is_embedded()) cols=2;
    blockwidget=new JcampDxBlockWidget(*dumblock,columns,vport,doneButton,false,omittext,storeLoadButtons);
    ODINLOG(odinlog,normalDebug) << "JcampDxBlock: JcampDxBlockWidget done" << STD_endl;
    GuiGridLayout::Alignment alignment = GuiGridLayout::Default;
    if(dumblock->numof_pars()<_MAX_SUBWIDGETS_FOR_ALIGNCENT_) alignment=GuiGridLayout::VCenter;
    set_widget(blockwidget ,alignment, true);
    ODINLOG(odinlog,normalDebug) << "JcampDxBlock: set_widget done" << STD_endl;
    connect(blockwidget,SIGNAL(valueChanged()),this,SLOT(emitValueChanged()));
    connect(blockwidget,SIGNAL(doneButtonPressed()),this,SLOT(emitDone()));
    ODINLOG(odinlog,normalDebug) << "JcampDxBlock: connect done" << STD_endl;
  }
  ODINLOG(odinlog,normalDebug) << "JcampDxBlock done" << STD_endl;


  /*---------------- JDXint  ------------------------*/

  int* dumint=ldr.cast(dumint);
  if(dumint) {
    RangeHelper intrange(ldr);
    if(intrange.has_range() && ldr.get_parmode()==edit) {
      cols=2;
      long step=int(intrange.get_stepsize(_MAX_SLIDER_STEPS_));
      if(step<1) step=1;
      ODINLOG(odinlog,normalDebug) << "processing >" << ldrlabel << "<" <<  STD_endl;
      intslider=new intScientSlider(int(intrange.minval),int(intrange.maxval),step,*dumint,vport,ldrlabel.c_str());
      set_widget(intslider);
      connect(intslider,SIGNAL(intScientSliderValueChanged( int )),this,SLOT(changeJDXint( int )));
      connect(this,SIGNAL(newintval( int )),intslider,SLOT(setintScientSliderValue( int )));

    } else {
      intedit=new intLineBox(*dumint,vport,ldrlabel.c_str());
      set_widget(intedit);
      connect(intedit,SIGNAL(intLineBoxValueChanged( int )),this,SLOT(changeJDXint( int )));
      connect(this,SIGNAL(newintval( int )),intedit,SLOT(setintLineBoxValue( int )));
    }
  }
  ODINLOG(odinlog,normalDebug) << "JDXint done" << STD_endl;


  /*---------------- JDXfloat & JDXdouble ------------------------*/

  float* dumfloat=ldr.cast(dumfloat);
  double* dumdouble=ldr.cast(dumdouble);
  if(dumfloat || dumdouble ) {
    float val=0.0;
    if(dumfloat) val=(*dumfloat);
    if(dumdouble) val=(*dumdouble);
    RangeHelper floatrange(ldr);
    if(floatrange.has_range() && ldr.get_parmode()==edit) {
      cols=2;
      floatslider=new floatScientSlider(floatrange.minval,floatrange.maxval,floatrange.get_stepsize(_MAX_SLIDER_STEPS_),val,_FLOAT_DIGITS_,vport,ldrlabel.c_str());
      set_widget(floatslider);
      connect(floatslider,SIGNAL(floatScientSliderValueChanged( float )),this,SLOT(changeJDXfloat( float )));
      connect(this,SIGNAL(newfloatval( float )),floatslider,SLOT(setfloatScientSliderValue( float )));
    } else {
      floatedit=new floatLineBox(val,_FLOAT_DIGITS_,vport,ldrlabel.c_str());
      set_widget(floatedit);
      connect(floatedit,SIGNAL(floatLineBoxValueChanged( float )),this,SLOT(changeJDXfloat( float )));
      connect(this,SIGNAL(newfloatval( float )),floatedit,SLOT(setfloatLineBoxValue( float )));
    }
  }
  ODINLOG(odinlog,normalDebug) << "JDXfloat & JDXdouble done" << STD_endl;


  /*---------------- JDXenum ------------------------*/

  JDXenum* dumenum=ldr.cast(dumenum);
  if(dumenum) {
    enumwidget=new enumBox(dumenum->get_alternatives(),vport,ldrlabel.c_str());
    enumwidget->setValue(dumenum->get_item_index());
    set_widget(enumwidget);
    ODINLOG(odinlog,normalDebug) << "widget done" << STD_endl;
    connect(enumwidget,SIGNAL(newVal( int )), this,SLOT(changeJDXenum( int )));
    connect(this,SIGNAL(newenumval( int )),enumwidget,SLOT(setValue( int )));
    ODINLOG(odinlog,normalDebug) << "connect done" << STD_endl;
  } else cast_success=false;
  ODINLOG(odinlog,normalDebug) << "JDXenum done" << STD_endl;



  /*---------------- JDXbool ------------------------*/

  bool* dumbool=ldr.cast(dumbool);
  if(dumbool) {
    boolwidget=new buttonBox("Yes","No",*dumbool, vport, ldrlabel.c_str());
    set_widget(boolwidget);
    connect(boolwidget,SIGNAL(buttonToggled(bool)), this,SLOT(changeJDXbool( bool )));
    connect(this,SIGNAL(newboolval( bool )),boolwidget,SLOT(setToggleState( bool )));
  } else cast_success=false;
  ODINLOG(odinlog,normalDebug) << "JDXbool done" << STD_endl;


  /*---------------- JDXaction ------------------------*/

  JDXaction* dumaction=ldr.cast(dumaction);
  if(dumaction && (dumaction->get_parmode()==edit) ) {
    actionwidget=new 	buttonBox("Now",vport,ldrlabel.c_str());
    set_widget(actionwidget);
    connect(actionwidget,SIGNAL(buttonClicked()), this,SLOT(changeJDXaction()));
  } else cast_success=false;
  ODINLOG(odinlog,normalDebug) << "JDXaction done" << STD_endl;


  /*---------------- JDXfloatArr ------------------------*/


  farray* dumfarray=ldr.cast(dumfarray);
  if(dumfarray) {
    create_or_update_floatArrwidget(*dumfarray,true);
  } else cast_success=false;
  ODINLOG(odinlog,normalDebug) << "JDXfloatArr done" << STD_endl;


  /*---------------- JDXdoubleArr ------------------------*/


  darray* dumdarray=ldr.cast(dumdarray);
  if(dumdarray) {
    ODINLOG(odinlog,normalDebug) << "dumdarray=" << (void*)dumdarray << "/" << STD_string(dumdarray->get_extent()) << STD_endl;
    farray farr(dumdarray->get_extent());
    for(unsigned int i=0; i<farr.total(); i++) farr[i]=(*dumdarray)[i];
    ODINLOG(odinlog,normalDebug) << "farr=" << STD_string(farr.get_extent()) << STD_endl;
    create_or_update_floatArrwidget(farr,true);
  } else cast_success=false;
  ODINLOG(odinlog,normalDebug) << "JDXdoubleArr done" << STD_endl;


  /*---------------- JDXcomplexArr ------------------------*/



  carray* dumcarray=ldr.cast(dumcarray);
  if(dumcarray) {
    ODINLOG(odinlog,normalDebug) << "cast succesful" << STD_endl;
    ODINLOG(odinlog,normalDebug) << "dumcarray->dim()=" << dumcarray->dim() << STD_endl;
    if(dumcarray->dim()==1) {
      fvector ampvec=amplitude(*dumcarray);
      fvector phavec=phase(*dumcarray);

      rows=3;
      cols=2;
      ODINLOG(odinlog,normalDebug) << "rows/cols=" << rows << "/" << cols << STD_endl;

      ArrayScale x_axprops=val.get_gui_props().scale[xPlotScale];
      ArrayScale y1_axprops=val.get_gui_props().scale[yPlotScaleLeft];
      ArrayScale y2_axprops=val.get_gui_props().scale[yPlotScaleRight];
      bool fixedsize=val.get_gui_props().fixedsize;


      complexArrwidget=new complexfloatBox1D(ampvec.c_array(),phavec.c_array(),dumcarray->length(),vport,ldrlabel.c_str(),fixedsize,
                                     x_axprops.get_label_with_unit().c_str(), y1_axprops.get_label_with_unit().c_str(), y2_axprops.get_label_with_unit().c_str(),
                                     x_axprops.minval,x_axprops.maxval,val.get_gui_props().fixedsize);
      set_widget(complexArrwidget, GuiGridLayout::Default, true);
      connect(this,SIGNAL(newcomplexArr( const float*, const float*, int, float, float)),
        complexArrwidget,SLOT(refresh( const float*, const float*, int, float, float)));
    }
  } else cast_success=false;
  ODINLOG(odinlog,normalDebug) << "JDXcomplexArr done" << STD_endl;


  /*---------------- JDXfunction ------------------------*/


  JDXfilter("dummy"); // created dummy to force initialization of registered_functions (in USING_WIN32/DLL)
  ODINLOG(odinlog,normalDebug) << "Testing for function" << STD_endl;
  JDXfunction* dumfunc=ldr.cast(dumfunc);
  if(dumfunc) {
    ODINLOG(odinlog,normalDebug) << "LDR is function" << STD_endl;
    cols=2;
    funcwidget=new enumBox(dumfunc->get_alternatives(),vport,ldrlabel.c_str(),true,true);
    ODINLOG(odinlog,normalDebug) << "funcwidget done" << STD_endl;
    funcwidget->setValue(dumfunc->get_function_index());
    ODINLOG(odinlog,normalDebug) << "setValue done" << STD_endl;
    set_widget(funcwidget);
    ODINLOG(odinlog,normalDebug) << "set_widget done" << STD_endl;
    connect(funcwidget,SIGNAL(newVal( int )), this,SLOT(changeJDXfunction( int )));
    connect(funcwidget,SIGNAL(edit()), this,SLOT(editJDXfunction()));
    connect(funcwidget,SIGNAL(info()), this,SLOT(infoJDXfunction()));
    connect(this,SIGNAL(newfuncval( int )),funcwidget,SLOT(setValue( int )));
    ODINLOG(odinlog,normalDebug) << "connect done" << STD_endl;
  } else cast_success=false;
  ODINLOG(odinlog,normalDebug) << "JDXfunction done" << STD_endl;


  /*---------------- JDXstring ------------------------*/


  STD_string* dumstring=ldr.cast(dumstring);
  if(dumstring) {
    cols=2;
    stringwidget=new stringBox(dumstring->c_str(),vport,ldrlabel.c_str());
    set_widget(stringwidget);
    connect(stringwidget,SIGNAL(stringBoxTextEntered( const char* )), this,SLOT(changeJDXstring( const char* )));
    connect(this,SIGNAL(newstringval( const char* )),stringwidget,SLOT(setstringBoxText( const char* )));
  } else cast_success=false;
  ODINLOG(odinlog,normalDebug) << "JDXstring done" << STD_endl;


  /*---------------- JDXfileName ------------------------*/


  JDXfileName* dumfileName=ldr.cast(dumfileName);
  if(dumfileName) {
    cols=2;
    filenamewidget=new stringBox(dumfileName->c_str(),vport,ldrlabel.c_str(),"Browse");
    set_widget(filenamewidget);
    connect(filenamewidget,SIGNAL(stringBoxTextEntered( const char* )), this,SLOT(changeJDXfileName( const char* )));
    connect(filenamewidget,SIGNAL(stringBoxButtonPressed()), this,SLOT(browseJDXfileName()));
    connect(this,SIGNAL(newfilenameval( const char* )),filenamewidget,SLOT(setstringBoxText( const char* )));
  } else cast_success=false;
  ODINLOG(odinlog,normalDebug) << "JDXfileName done" << STD_endl;


  /*---------------- JDXformula ------------------------*/


  JDXformula* dumformula=ldr.cast(dumformula);
  if(dumformula) {
    cols=2;
    formulawidget=new stringBox(dumformula->c_str(),vport,ldrlabel.c_str(),"Syntax");
    set_widget(formulawidget);
    connect(formulawidget,SIGNAL(stringBoxTextEntered( const char* )), this,SLOT(changeJDXformula( const char* )));
    connect(formulawidget,SIGNAL(stringBoxButtonPressed()), this,SLOT(infoJDXformula()));
    connect(this,SIGNAL(newformulaval( const char* )),formulawidget,SLOT(setstringBoxText( const char* )));
  } else cast_success=false;
  ODINLOG(odinlog,normalDebug) << "JDXformula done" << STD_endl;


  /*---------------- JDXtriple ------------------------*/


  JDXtriple* dumtriple=ldr.cast(dumtriple);
  if(dumtriple) {
    cols=2;
    triplewidget=new floatLineBox3D((*dumtriple)[0],(*dumtriple)[1],(*dumtriple)[2],_FLOAT_DIGITS_,vport,ldrlabel.c_str());
    set_widget(triplewidget);
    connect(triplewidget,SIGNAL(floatLineBox3DValueChanged(float,float,float)), this,SLOT(changeJDXtriple(float,float,float)));
    connect(this,SIGNAL(newtripleval(float,float,float)),triplewidget,SLOT(setfloatLineBox3DValue(float,float,float)));
  } else cast_success=false;
  ODINLOG(odinlog,normalDebug) << "JDXtriple done" << STD_endl;


/*---------------- JDX types swith END ------------------------*/

  if(!cast_success) ODINLOG(odinlog,normalDebug) << "Unable to proces parameter >" << ldrlabel << "<" << STD_endl;

  return;
}


void JDXwidget::write_pixmap(const char* fname, const char* format, bool dump_all) const {
  if(floatArrwidget2) floatArrwidget2->write_pixmap(fname, format, dump_all);
}

void JDXwidget::write_map_legend(const char* fname, const char* format) const {
  if(floatArrwidget2) floatArrwidget2->write_map_legend(fname, format);
}



JDXwidget::~JDXwidget(){
  // do not acces 'val' here because it might be deleted already
  if(blockwidget) delete blockwidget;
  if(intslider) delete intslider;
  if(intedit) delete intedit;
  if(floatslider) delete floatslider;
  if(floatedit) delete floatedit;
  if(enumwidget) delete enumwidget;
  if(boolwidget) delete boolwidget;
  if(floatArrempty) delete floatArrempty;
  if(floatArrwidget1) delete floatArrwidget1;
  if(floatArredit) delete floatArredit;
  if(floatArrwidget2) delete floatArrwidget2;
//  if(doubleArrwidget1) delete doubleArrwidget1;
  if(complexArrwidget) delete complexArrwidget;
  if(funcwidget) delete funcwidget;
  if(stringwidget) delete stringwidget;
  if(filenamewidget) delete filenamewidget;
  if(formulawidget) delete formulawidget;
  if(triplewidget) delete triplewidget;
  if(grid) delete grid;
}

STD_string JDXwidget::get_label() const {return val.get_label();}

void JDXwidget::set_widget(QWidget *widget, GuiGridLayout::Alignment alignment, bool override_enabled) {
  Log<OdinQt> odinlog(&val,"set_widget");

  widget_cache=widget;

  parameterMode parmode=val.get_parmode();
  ODINLOG(odinlog,normalDebug) << "parmode(" << ldrlabel << ")=" << parmode << STD_endl;
  if(parmode==hidden) return;
  bool enabled=true;
  if(parmode>=noedit) enabled=false;
  if(override_enabled) enabled=true;
  widget_cache->setEnabled(enabled);
  ODINLOG(odinlog,normalDebug) << "parameterMode done" << STD_endl;

  bool show_tooltip=label_cut;
  STD_string tooltip=ldrlabel_uncut;
  STD_string descr=val.get_description();
  if(descr!="") {
    tooltip+=": "+descr;
    tooltip=justificate(tooltip);
    show_tooltip=true;
  }
  if(show_tooltip) add_tooltip(widget_cache,tooltip.c_str());

  grid->add_widget( widget, 0, 0, alignment);
  widget->show();
}


unsigned int JDXwidget::get_sizedfarray_size_and_factor(unsigned int& nx, unsigned int& ny, unsigned int& nz) const {
  Log<OdinQt> odinlog(&val,"get_sizedfarray_size_and_factor");

  PixmapProps pixprops=val.get_gui_props().pixmap;

  int dim=sizedfarray.dim();
  nx=sizedfarray.size(dim-1);
  ny=sizedfarray.size(dim-2);
  nz=1;
  if(dim==3) nz=sizedfarray.size(dim-3);
  unsigned int factor=1;
  ODINLOG(odinlog,normalDebug) << "ny/nx=" << ny << "/" << nx << STD_endl;
  ODINLOG(odinlog,normalDebug) << "minsize/maxsize=" << pixprops.minsize << "/" << pixprops.maxsize << STD_endl;
  if (nx >= ny)   factor=(unsigned int)secureDivision(pixprops.minsize,ny);
  else            factor=(unsigned int)secureDivision(pixprops.minsize,nx);
  if(!factor) factor=1;
  if( (factor*nx) > pixprops.maxsize) factor=(unsigned int)secureDivision(pixprops.maxsize,nx);
  if( (factor*ny) > pixprops.maxsize) factor=(unsigned int)secureDivision(pixprops.maxsize,ny);
  if(!factor) factor=1;
  return factor;
}






void JDXwidget::create_or_update_floatArrwidget(const farray& arr, bool initial) {
  Log<OdinQt> odinlog(&val,"create_or_update_floatArrwidget");

  rows=2;
  cols=2;

  ArrayScale x_axprops=val.get_gui_props().scale[xPlotScale];
  ArrayScale y_axprops=val.get_gui_props().scale[yPlotScaleLeft];

  sizedfarray=arr;
  sizedfarray.autosize();
  unsigned int newdim=sizedfarray.dim();
  unsigned int newsize=sizedfarray.total();
  if(newdim==3) newdim=2; // treat 2D and 3D equally
  if(newsize==0) newdim=0; // treat zero size as zero dim
  ODINLOG(odinlog,normalDebug) << "newdim/newsize=" << newdim << "/" << newsize << STD_endl;


  if(!initial) {
    unsigned int olddim=oldfarraysize.dim();
    unsigned int oldsize=oldfarraysize.total();
    if(olddim==3) olddim=2; // treat 2D and 3D equally
    bool delete_old=false;
    if(newdim!=olddim) delete_old=true;
    if(newdim==1 && (newsize!=oldsize) && (newsize==1 || oldsize==1)) delete_old=true;
    if(newdim>1 && sizedfarray.get_extent()!=oldfarraysize) delete_old=true;
    ODINLOG(odinlog,normalDebug) << "newdim/olddim/newsize/oldsize/delete_old=" << newdim << "/" << olddim << "/" << newsize << "/" << oldsize << "/" << delete_old << STD_endl;
    if(delete_old) {
      if(floatArrempty)   {floatArrempty->hide();   delete floatArrempty;   floatArrempty=0;}
      if(floatArrwidget1) {floatArrwidget1->hide(); delete floatArrwidget1; floatArrwidget1=0;}
      if(floatArredit)    {floatArredit->hide();    delete floatArredit;    floatArredit=0;}
      if(floatArrwidget2) {floatArrwidget2->hide(); delete floatArrwidget2; floatArrwidget2=0;}
    }
  }


  if(newdim==0) {
    if(!floatArrempty) {
      floatArrempty=new QLabel(this);
      floatArrempty->setText((ldrlabel+"(Empty)").c_str());
      set_widget(floatArrempty);
    }
  }


  if(newdim==1) {
    if(newsize==1) {
      rows=1;
      cols=1;
      if(floatArredit) {
        emit newfloatval( sizedfarray[0] );
      } else {
        floatArredit=new floatLineBox(sizedfarray[0],_FLOAT_DIGITS_,vport,ldrlabel.c_str());
        set_widget(floatArredit);
        connect(floatArredit,SIGNAL(floatLineBoxValueChanged( float )),this,SLOT(changeJDXfloat( float )));
        connect(this,SIGNAL(newfloatval( float )),floatArredit,SLOT(setfloatLineBoxValue( float )));
      }
    }

    if(newsize>1) {
      rows=3;
      ODINLOG(odinlog,normalDebug) << "x_label/unit=" << x_axprops.label << "/" << x_axprops.unit << STD_endl;
      ODINLOG(odinlog,normalDebug) << "y_label/unit=" << y_axprops.label << "/" << y_axprops.unit << STD_endl;
      if(floatArrwidget1) {
        emit newfloatArr1( sizedfarray.c_array(), sizedfarray.length(), x_axprops.minval,x_axprops.maxval );
      } else {
        floatArrwidget1=new floatBox1D(sizedfarray.c_array(),sizedfarray.length(),vport,ldrlabel.c_str(),val.get_gui_props().fixedsize,
                                       x_axprops.get_label_with_unit().c_str(),y_axprops.get_label_with_unit().c_str(),
                                       x_axprops.minval,x_axprops.maxval,val.get_gui_props().fixedsize);
        set_widget(floatArrwidget1, GuiGridLayout::Default, true);
        connect(this,SIGNAL(newfloatArr1( const float*, int, float, float)), floatArrwidget1,SLOT(refresh( const float*, int, float, float)));
      }
    }
  }

  if(newdim==2) {
    ArrayScale dispscale=val.get_gui_props().scale[displayScale];
    ODINLOG(odinlog,normalDebug) << "dispscale.minval/maxval=" << dispscale.minval << "/" << dispscale.maxval << STD_endl;
    if(val.get_gui_props().pixmap.autoscale) {
      dispscale.minval=sizedfarray.minvalue();
      dispscale.maxval=sizedfarray.maxvalue();
      ODINLOG(odinlog,normalDebug) << "Autoscaling with min/max=" << dispscale.minval << "/" << dispscale.maxval << STD_endl;
      sizedfarray.normalize();
    }
    if(floatArrwidget2) {
      ODINLOG(odinlog,normalDebug) << "Emitting new c_array" << STD_endl;
      emit newfloatArr2( sizedfarray.c_array(),dispscale.minval,dispscale.maxval);

      mapfarray=val.get_gui_props().pixmap.overlay_map;
//      mapfarray.normalize();
      if(mapfarray.total()) {
        ODINLOG(odinlog,normalDebug) << "New overlay_map" << STD_endl;
        float mapmin, mapmax;
        val.get_gui_props().pixmap.get_overlay_range(mapmin, mapmax);
        emit newfloatArrMap(mapfarray.c_array(), mapmin, mapmax, val.get_gui_props().pixmap.overlay_rectsize);
      }

    } else {
      unsigned int nx,ny,nz;
      unsigned int factor=get_sizedfarray_size_and_factor(nx,ny,nz);
      bool colormap=val.get_gui_props().pixmap.color;
      overlay_map=val.get_gui_props().pixmap.overlay_map; // create local copy for c_array()
      bool olm_firescale=val.get_gui_props().pixmap.overlay_firescale;
      float olm_rectsize=val.get_gui_props().pixmap.overlay_rectsize;
      const float* olm=0;
      int olm_x=1;
      int olm_y=1;
      int olm_z=1;
      float olm_upp=0.0;
      float olm_low=0.0;
      if(overlay_map.length()) {
        val.get_gui_props().pixmap.get_overlay_range(olm_low, olm_upp);

//        olm_upp=overlay_map.maxvalue();
//        olm_low=overlay_map.minvalue();
//        overlay_map.normalize();
        olm=overlay_map.c_array();
        int olm_dim=overlay_map.dim();
        if(olm_dim>2) olm_z=overlay_map.size(olm_dim-3);
        if(olm_dim>1) olm_y=overlay_map.size(olm_dim-2);
        if(olm_dim>0) olm_x=overlay_map.size(olm_dim-1);
        ODINLOG(odinlog,normalDebug) << "olm/olm_z/olm_y/olm_x=" << olm << "/" << olm_z << "/" << olm_y << "/" << olm_x << STD_endl;
      }


      floatArrwidget2=new floatBox3D(sizedfarray.c_array(),dispscale.minval,dispscale.maxval,nx,ny,nz,factor,vport,ldrlabel.c_str(),
        olm,olm_low,olm_upp,olm_x,olm_y,olm_z,olm_firescale,olm_rectsize,colormap);
      set_widget(floatArrwidget2, GuiGridLayout::Default, true);
      connect(floatArrwidget2,SIGNAL(clicked(int,int,int)),this,SLOT(emitClicked(int, int, int)));
      connect(floatArrwidget2,SIGNAL(newProfile(const float*, int, bool, int)),this,SLOT(emitNewProfile(const float*, int, bool, int)));
      connect(floatArrwidget2,SIGNAL(newMask(const float*, int)),this,SLOT(emitNewMask(const float*, int)));
      connect(this,SIGNAL(newfloatArr2( const float*, float, float)),floatArrwidget2,SLOT(refresh( const float*, float, float)));
      connect(this,SIGNAL(newfloatArrMap( const float*, float, float, float)),floatArrwidget2,SLOT(refreshMap( const float*, float, float, float )));
    }
  }

  oldfarraysize=sizedfarray.get_extent();
}




void JDXwidget::emitValueChanged() {
  emit valueChanged();
}


void JDXwidget::emitDone() {
  emit doneButtonPressed();
}


void JDXwidget::updateWidget() {
  Log<OdinQt> odinlog(&val,"updateWidget");
  emit updateSubWidget();

  if(blockwidget) blockwidget->updateWidget();

  // for all 1D/2D plots, get again, might have been changed
  ArrayScale x_axprops=val.get_gui_props().scale[xPlotScale];
  PixmapProps pixprops=val.get_gui_props().pixmap;

  if(intslider || intedit) {
    ODINLOG(odinlog,normalDebug) << "newintval(" << val.get_label() << ")=" << val.printvalstring() << STD_endl;
    emit newintval( atoi(val.printvalstring().c_str()) );
  }

  if(floatslider || floatedit) {
    float* dumfloat=val.cast(dumfloat);
    double* dumdouble=val.cast(dumdouble);
    float floatval=0.0;
    if(dumfloat) floatval=(*dumfloat);
    if(dumdouble) floatval=(*dumdouble);
    emit newfloatval( floatval );
  }

  if(enumwidget) {
   JDXenum* dumenum=val.cast(dumenum);
   if(dumenum) emit newenumval( dumenum->get_item_index() );
  }

  if(boolwidget) {
   bool* dumbool=val.cast(dumbool);
   if(dumbool) emit newboolval(*dumbool);
  }

  if(complexArrwidget) {
    carray* dumcarray=val.cast(dumcarray);
    if(dumcarray) {
      if(dumcarray->dim()==1) {
        fvector ampvec=amplitude(*dumcarray);
        fvector phavec=phase(*dumcarray);
        emit newcomplexArr( ampvec.c_array(), phavec.c_array(), dumcarray->length(), x_axprops.minval,x_axprops.maxval);
      }
    }
  }

  if(floatArrempty || floatArrwidget1 || floatArrwidget2 || floatArredit) {
    farray* dumfarray=val.cast(dumfarray);
    if(dumfarray) {
      create_or_update_floatArrwidget(*dumfarray,false);
    }
    darray* dumdarray=val.cast(dumdarray);
    if(dumdarray) {
      ODINLOG(odinlog,normalDebug) << "dumdarray=" << (void*)dumdarray << "/" << STD_string(dumdarray->get_extent()) << STD_endl;
      farray farr(dumdarray->get_extent());
      for(unsigned int i=0; i<farr.total(); i++) farr[i]=(*dumdarray)[i];
      create_or_update_floatArrwidget(farr,false);
    }
  }

  if(funcwidget) {
    JDXfunction* dumfunc=val.cast(dumfunc);
    if(dumfunc) emit newfuncval( dumfunc->get_function_index() );
    ODINLOG(odinlog,normalDebug) << "get_function_index()=" << dumfunc->get_function_index() << STD_endl;

    for(STD_list<JDXwidgetDialog*>::iterator it=subdialogs.begin(); it!=subdialogs.end(); ++it) {
      (*it)->updateWidget();
    }
  }

  if(stringwidget) {
    STD_string* dumstring=val.cast(dumstring);
    if(dumstring) {
      const char* str=dumstring->c_str();
      ODINLOG(odinlog,normalDebug) << "str=" << str << STD_endl;
      emit newstringval(str);
    }
  }

  if(filenamewidget) {
    JDXfileName* dumfileName=val.cast(dumfileName);
    if(dumfileName) emit newfilenameval( dumfileName->c_str() );
  }

  if(formulawidget) {
    JDXformula* dumformula=val.cast(dumformula);
    if(dumformula) emit newformulaval( dumformula->c_str() );
  }

  if(triplewidget) {
    JDXtriple* dumtriple=val.cast(dumtriple);
    if(dumtriple) emit newtripleval( (*dumtriple)[0],(*dumtriple)[1],(*dumtriple)[2] );
  }

}

void JDXwidget::deleteDialogs() {
  emit deleteSubDialogs();
  for(STD_list<JDXwidgetDialog*>::iterator it=subdialogs.begin(); it!=subdialogs.end(); ++it) {
    (*it)->hide();
//    delete (*it);
  }
  subdialogs.clear();
}


void JDXwidget::changeJDXint( int newval ) {
  int* dumint=val.cast(dumint);
  if(dumint) (*dumint)=newval;
  long* dumlong=val.cast(dumlong);
  if(dumlong) (*dumlong)=newval;
  emit valueChanged();
}


void JDXwidget::changeJDXfloat( float newval ) {
  Log<OdinQt> odinlog(&val,"changeJDXfloat");
  ODINLOG(odinlog,normalDebug) << "newval=" << newval << STD_endl;
  float* dumfloat=val.cast(dumfloat);
  if(dumfloat) (*dumfloat)=newval;
  double* dumdouble=val.cast(dumdouble);
  if(dumdouble) (*dumdouble)=newval;
  farray* dumfarray=val.cast(dumfarray);
  if(dumfarray && dumfarray->length()) dumfarray[0]=newval;
  darray* dumdarray=val.cast(dumdarray);
  if(dumdarray && dumdarray->length()) dumdarray[0]=newval;
 //  STD_string dummy=JDXdouble(newval).printvalstring();
//  val.parsevalstring(dummy);
  ODINLOG(odinlog,normalDebug) << "val=" << val.printvalstring() << STD_endl;
  emit valueChanged();
}


void JDXwidget::changeJDXenum( int newval ) {
  JDXenum* dumenum=val.cast(dumenum);
  if(dumenum) dumenum->set_item_index(newval);
  emit valueChanged();
}


void JDXwidget::changeJDXbool( bool newval ) {
  bool* dumbool=val.cast(dumbool);
  if(dumbool) (*dumbool)=newval;
  emit valueChanged();
}


void JDXwidget::changeJDXaction() {
  JDXaction* dumaction=val.cast(dumaction);
  if(dumaction) dumaction->trigger_action();
  emit valueChanged();
}


void JDXwidget::changeJDXfunction( int newval ) {
  Log<OdinQt> odinlog(&val,"changeJDXfunction");
  ODINLOG(odinlog,normalDebug) << "newval=" << newval << STD_endl;
  deleteDialogs();
  JDXfunction* dumfunc=val.cast(dumfunc);
  if(dumfunc) dumfunc->set_function(newval);
  emit valueChanged();
}


void JDXwidget::changeJDXstring( const char* newval ) {
  Log<OdinQt> odinlog(&val,"changeJDXstring");
  ODINLOG(odinlog,normalDebug) << "newval=" << newval << STD_endl;
  STD_string* dumstring=val.cast(dumstring);
  if(dumstring) {
    STD_string newval_str=STD_string(newval); // direct assignment gives bogus results on MacOS 10.4 with GCC4 and std::string
    (*dumstring)=newval_str;
    ODINLOG(odinlog,normalDebug) << "newval_str/dumstring=" << newval_str << "/" << (*dumstring) << STD_endl;
  }
  emit valueChanged();
}


void JDXwidget::changeJDXfileName( const char* newval ) {
  JDXfileName* dumfilename=val.cast(dumfilename);
  if(dumfilename) {
    STD_string newvalstr(newval);
    (*dumfilename)=newvalstr;
  }
  emit valueChanged();
}


void JDXwidget::changeJDXformula( const char* newval ) {
  JDXformula* dumformula=val.cast(dumformula);
  if(dumformula) (*dumformula)=newval;
  emit valueChanged();
}


void JDXwidget::changeJDXtriple( float xval,float yval,float zval ) {
  JDXtriple* dumtriple=val.cast(dumtriple);
  if(dumtriple) {
    (*dumtriple)[0]=xval;
    (*dumtriple)[1]=yval;
    (*dumtriple)[2]=zval;
  }
  emit valueChanged();
}


void JDXwidget::browseJDXfileName() {
  Log<OdinQt> odinlog(&val,"browseJDXfileName");
  JDXfileName* dumfilename=val.cast(dumfilename);
  if(dumfilename) {
    STD_string suffix=dumfilename->get_suffix();
    ODINLOG(odinlog,normalDebug) << "suffix=" << suffix << STD_endl;
    if(suffix!="") suffix=STD_string(val.get_label())+" (*."+suffix+")";
    STD_string startdir=dumfilename->get_defaultdir(); // local copy for c_str()
    ODINLOG(odinlog,normalDebug) << "startdir/suffix=" << startdir << "/" << suffix << STD_endl;
    STD_string fname;
    if(dumfilename->is_dir())  fname=get_directory("Please select a directory", startdir.c_str(), vport);
    else                       fname=get_open_filename("Please select a file", startdir.c_str(), suffix.c_str(), vport);
    if (fname!="") {
      (*dumfilename)=fname;
      filenamewidget->setstringBoxText(fname.c_str());
    }
  }

  emit valueChanged();
}


void JDXwidget::infoJDXformula() {
  JDXformula* dumformula=val.cast(dumformula);
  if(dumformula) {
    message_question((justificate(dumformula->get_syntax(),0,false,_INFOBOX_LINEWIDTH_)).c_str(), val.get_label().c_str(), vport);
  }
  emit valueChanged();
}


void JDXwidget::editJDXfunction() {
  JDXfunction* dumfunc=val.cast(dumfunc);
  if(dumfunc) {
    JDXwidgetDialog* dlg=new JDXwidgetDialog(*(dumfunc->get_funcpars_block()),1,vport);
    subdialogs.push_back(dlg);
    connect(dlg,SIGNAL(valueChanged()), this,SLOT(emitValueChanged()));
  }
  emit valueChanged();
}


void JDXwidget::infoJDXfunction() {
  JDXfunction* dumfunc=val.cast(dumfunc);
  if(dumfunc) {
    message_question((justificate(dumfunc->get_funcdescription(),0,false,_INFOBOX_LINEWIDTH_)).c_str(), (dumfunc->get_label()+STD_string(" info")).c_str(), vport);
  }
}

