## Copyright (C) 2005 Shai Ayal
##
## This program is free software; you can redistribute it and/or modify it
## under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
##
## OctPlot is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with OctPlot; see the file COPYING.  If not, write to the Free
## Software Foundation, 59 Temple Place - Suite 330, Boston, MA
## 02111-1307, USA.

## -*- texinfo -*-
## @deftypefn {Function File} {}  colorbar ()
## Adds a colorbar to the side of the current axis
## @end deftypefn
## @seealso{pcolor,colormap}

## Author: shaia

function colorbar()
  ca = gca();
  cpos=get(ca,"position")(:);
  
  npos = cpos.*[1,1,0.8,1]';
  bpos = cpos.*[0,1,0.1,1]' + [cpos(1)+0.9*cpos(3),0,0,0]';

  set(ca,"position",npos);
  na = axes();
  set(na,"position",bpos);
  npcl = get(ca,"clim");
  cm   = colormap();

  set(na,"clim",[0,1]);

  x = [0,1]'*ones(1,size(cm,1));
  y = ones(2,1)*linspace(npcl(1),npcl(2),size(cm,1));
  z = ones(2,1)*linspace(0,1,size(cm,1));
  pcolor(x,y,z);
  axis([0 1 npcl(1) npcl(2)]);
  set(gca(),"xtick",[]);
  
  set(gcf(),"currentaxes",ca);

endfunction
