

%  This simple example shows how to do basic texture mapping.

vtk_init;

VTK_DATA_ROOT = vtkGetDataRoot();

%  Load in the texture map. A texture is any unsigned char image. If it
%  is not of this type, you will have to map it through a lookup table
%  or by using vtkImageShiftScale.
bmpReader = vtkBMPReader();
bmpReader.SetFileName(strcat(VTK_DATA_ROOT,"/Data/masonry.bmp"));
atext = vtkTexture();
atext.SetInput(bmpReader.GetOutput());
atext.InterpolateOn();

%  Create a plane source and actor. The vtkPlanesSource generates
%  texture coordinates.
plane = vtkPlaneSource();
planeMapper = vtkPolyDataMapper();
planeMapper.SetInput(plane.GetOutput());
planeActor = vtkActor();
planeActor.SetMapper(planeMapper);
planeActor.SetTexture(atext);

%  Create the RenderWindow, Renderer and both Actors
ren = vtkRenderer();
renWin = vtkRenderWindow();
renWin.AddRenderer(ren);
iren = vtkRenderWindowInteractor();
iren.SetRenderWindow(renWin);

%  Add the actors to the renderer, set the background and size
ren.AddActor(planeActor);
ren.SetBackground(0.1, 0.2, 0.4);
renWin.SetSize(500, 500);

cam1 = ren.GetActiveCamera();
cam1.Elevation(-30);
cam1.Roll(-20);
ren.ResetCameraClippingRange();


% renWin.Render();
vtkInitializeInteractor(iren);
