## Copyright (C) 2004  Dragan Tubic
## 
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
## 
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details. 
## 
## You should have received a copy of the GNU General Public License
## along with this file.  If not, write to the Free Software Foundation,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

## -*- texinfo -*-
## @deftypefn {Function File} {} vtk_pcolor(@var{x},@var{y},@var{c},[@var{prop},@var{val}])
## Displays a surface plot defined by @var{x},@var{y} matrices,
## where @var{x} and @var{y} are typically formed by meshgrid.
## @var{c} is a matrix to give a color scale.
##
## Optional @var{prop},@var{val} arguments can be used to change
## properties of the plot.  Currently, valid properties are
## ";Interp;".
## 
## @end deftypefn
## @seealso{vtk_surf, vtk_mesh}

## Author: Dragan Tubic

function vtk_pcolor( varargin )
  
  valid_props = ";;";
  
  [no_numerical_params, first_prop_index, line_spec_index] = vtk_parse_params(valid_props, all_va_args);
  
  if ( no_numerical_params < 3 | no_numerical_params > 3 )
    error("Syntax is vtk_surf( x, y, c )");
  end
  
  if ( no_numerical_params == 3 )
    x = nth (varargin,1);
    y = nth (varargin,2);
    z = x*0;
    c = nth (varargin,3);
  end
  
  [nr nc] = size(x);
  
  if ( nr < 2 | nc < 2 )
    error("input has to be at least 2xN or Nx2 matrix");
  end	
  
  m=nc; n=nr;
  i=0:m-2;
  j=0:n-2;
  [i,j]=meshgrid(i,j);
  i=i(:); j=j(:);
  t=[i*n+j,i*n+(j+1),(i+1)*n+(j+1) ; i*n+j (i+1)*n+(j+1),(i+1)*n+j];  %1; one way to construct the triangles
  if ( first_prop_index > 0 )
    f=vtk_trisurf(t+1,x(:),y(:),z(:),c(:),'Interpolation','Flat',varargin{first_prop_index:length(varargin)});
  else
    f=vtk_trisurf(t+1,x(:),y(:),z(:),c(:),'Interpolation','Flat');
  end
  
endfunction
