## Copyright (C) 2004  Dragan Tubic
## 
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
## 
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details. 
## 
## You should have received a copy of the GNU General Public License
## along with this file.  If not, write to the Free Software Foundation,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

## -*- texinfo -*-
## @deftypefn {Function File} {} vtk_blackonwhite()
## Changes the background to be white with black axes and outline.  To
## change the color of the background and axes to something else, please
## refer to the source code of this function.
## @end deftypefn

## Author: Jonathan Stickel


function vtk_blackonwhite()

  f=vtk_figure(0);

  f.renderer.SetBackground(1,1,1)
  f.outline_actor.GetProperty.SetColor(0,0,0)
  f.axes.GetProperty.SetColor(0,0,0)
  f.axes.GetAxisTitleTextProperty.SetColor(0,0,0)
  f.axes.GetAxisTitleTextProperty.ShadowOff

  ## change color of title (assume it is the only textactor)
  nprops = f.renderer.GetProps.GetNumberOfItems;
  for i = 0:nprops-1;
    if ( f.renderer.GetProps.GetItemAsObject(i).IsA("vtkTextActor") )
      f.renderer.GetProps.GetItemAsObject(i).GetTextProperty.SetColor(0,0,0)
      break
    endif
  endfor 

  ## change color of text of color bar, if it exists
  nprops = f.renderer.GetProps.GetNumberOfItems;
  for i = 0:nprops-1;
    if ( f.renderer.GetProps.GetItemAsObject(i).IsA("vtkScalarBarActor") )
      f.renderer.GetProps.GetItemAsObject(i).GetTitleTextProperty.SetColor(0,0,0)
      f.renderer.GetProps.GetItemAsObject(i).GetLabelTextProperty.SetColor(0,0,0)
      break
    endif
  endfor 

  vtk_update(f);

endfunction
