/*

Copyright (C) 1996 John W. Eaton
Copyright (C) 2004 Dragan Tubic

This file is part of Octave.

Octave is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

Octave is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with Octave; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef __OCTAVE_VTK_INIT__
#define __OCTAVE_VTK_INIT__

// The following must be defined for recent versions of Octave.
#define TYPEID_HAS_CLASS
#include <octave/config.h>
#include <octave/ov-base.h>
#ifdef HAVE_SLLIST_H
#define LIST SLList
#define LISTSIZE length
#define SUBSREF_STRREF
#else
#include <list>
#define LIST std::list
#define LISTSIZE size
#define SUBSREF_STRREF &
#endif

#include <string>
#include <map>
#include <inttypes.h>
// Threads
#include <pthread.h>
/// X window and Motif related stuff
//#include <Xm/Xm.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
				
extern XtAppContext vtk_app_context;
extern std::map<Atom, unsigned int> vtk_delete_window_atoms;

int vtk_event_loop();


class vtkObjectBase;

class 
vtk_object : public octave_base_value
{
public:

  vtk_object ( vtkObjectBase *pointer, bool belongs_to_octave = false );

  ~vtk_object (void);

	static void print_ref_table();
	
	unsigned int uint_value (bool req_int=false, bool frc_str_conv=false) const;

	octave_uint64 uint64_scalar_value (void) const; 

	octave_uint32 uint32_scalar_value (void) const; 
	
	
  bool is_defined (void) const;

  // since we are a function, we won't see do_index_op
  octave_value do_index_op (const octave_value_list &, int);

  // x.v = y    x(idx).v = y      x{idx}.v = y
  octave_value subsasgn (const std::string& type,
                         const LIST<octave_value_list>& idx,
                         const octave_value& rhs);

  // x.v    x(idx).v    x{idx}.v
  octave_value subsref (const std::string SUBSREF_STRREF type,
			const LIST<octave_value_list>& idx);

  // [i,j] = x(i)
  octave_value_list do_multi_index_op (int, const octave_value_list&);
  
	// [i,j] = x.v(...)
  octave_value_list subsref (const std::string SUBSREF_STRREF type,
			     const LIST<octave_value_list>& idx,
			     int nargout);
			
  void print (std::ostream& os, bool pr_as_read=false) const;
					 
private:

  vtk_object (void);

  vtk_object (const vtk_object& s );
	  
	vtkObjectBase*  vtk_pointer;

	static std::map<uintptr_t, int>& get_reference_map();
	
	std::string vtk_class;
	
  DECLARE_OCTAVE_ALLOCATOR

  DECLARE_OV_TYPEID_FUNCTIONS_AND_DATA
};

#include "vtkCommand.h"

// Allow Octave to use the vtkCommand features

class vtkOctaveCommand : public vtkCommand
{
public:
  static vtkOctaveCommand *New() { return new vtkOctaveCommand; };

  void SetObject(vtk_object *o);
	
	void SetFunctionName(const char* function_name );
	
  void Execute(vtkObject *ptr, unsigned long eventtype, void *CallData);
 
  vtk_object *obj;
protected:
	std::string function;
  vtkOctaveCommand();
  ~vtkOctaveCommand(); 
};

#endif // __OCTAVE_VTK_INIT__

