## Copyright (C) 2004  Dragan Tubic
## 
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
## 
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details. 
## 
## You should have received a copy of the GNU General Public License
## along with this file.  If not, write to the Free Software Foundation,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

## -*- texinfo -*-
## @deftypefn {Function File} {[@var{n}, @var{pidx}, @var{lidx}] =} vtk_parse_params(@var{props}, @var{args})
## Octaviz internal function for processing format parameters.
## @end deftypefn
## @seealso{vtk_get_line_spec}

## Author: Dragan Tubic

function [no_numerical_params, first_prop_index, line_spec_index] = vtk_parse_params(valid_props, varargin)
  %% Get the type of each parameter.
  %% General syntax is func(par1,...,parN,"property1",value1,...,"propertyK",valueK)
  %% Properties begin with the first string parameter. Each property needs a value.
	
  %% Get the types	
  no_params = length(varargin);
  num_type = zeros(1,no_params);
  str_type = zeros(1,no_params);
  
  for i = 1:no_params
    num_type(i) = isnumeric(varargin{i});
    str_type(i) = ischar(varargin{i});
  end
  
  %% Index of the first property
  first_prop = min( find( str_type ) );
  
  if ( isempty(first_prop) )
    %% No strings at all, thus no properties nor m**lab LineSpecs
    first_prop_index = -1;
    line_spec_index = -1;
    num_ind = find( num_type );
    no_numerical_params = max(find(num_ind));
    return;
  end
  
  num_ind = find( num_type );
  no_numerical_params = num_ind( max(find(num_ind < first_prop )) );
  
  %% Check if the fist string is m**lab LineSpec
  %% For now the most simple check: if the string is shorter than 5 
  %% characters it is LineSpec
  if ( length( varargin{first_prop} ) < 5 )
    line_spec_index = first_prop;
    first_prop = first_prop+1;
    if ( first_prop > no_params )
      first_prop_index = -1;
      return;
    end
  else
    line_spec_index = -1;	
    first_prop_index = first_prop;
  end
  
  %% After the first property every second parameter has to be string.
  %% Also, since each property needs a value, the number of parameters
  %% after (and including) first_prop has to be even. Hence 
  %% sum(str_type(first_prop:2:no_params)) == (no_params - first_prop + 1)/2
  if ( sum(str_type(first_prop:2:no_params)) ~= (no_params - first_prop + 1)/2 )
    error("Each property has to be followed by its value");
  end
  
  for i = first_prop:2:no_params
    ind = index( valid_props, strcat(";",varargin{i},";") );
    if ( ind < 1 )
      msg = strcat("Unknown property: \"",varargin{i},"\"\n");
      msg = strcat(msg,"Valid properties are:");
      props = split(valid_props,";");
      [nr nc] = size(props);
      for k = 1:nr
	msg = strcat(msg,props(k,:),"\n");
      end
      error(msg);
    end
  end
  
  first_prop_index = first_prop;
  
endfunction
