

%  This example shows how to generate and manipulate texture coordinates.
%  A random cloud of points is generated and then triangulated with 
%  vtkDelaunay3D. Since these points do not have texture coordinates,
%  we generate them with vtkTextureMapToCylinder.

vtk_init;

VTK_DATA_ROOT = vtkGetDataRoot();

%  Begin by generating 25 random points in the unit sphere.
sphere = vtkPointSource();
sphere.SetNumberOfPoints(25);

%  Triangulate the points with vtkDelaunay3D. This generates a convex hull
%  of tetrahedron.
delny = vtkDelaunay3D();
delny.SetInput(sphere.GetOutput());
delny.SetTolerance(0.01);

%  The triangulation has texture coordinates generated so we can map
%  a texture onto it.
tmapper = vtkTextureMapToCylinder();
tmapper.SetInput(delny.GetOutput());
tmapper.PreventSeamOn();

%  We scale the texture coordinate to get some repeat patterns.
xform = vtkTransformTextureCoords();
xform.SetInput(tmapper.GetOutput());
xform.SetScale(4, 4, 1);

%  vtkDataSetMapper internally uses a vtkGeometryFilter to extract the
%  surface 
%  then passed to an internal vtkPolyDataMapper which does the
%  rendering.
mapper = vtkDataSetMapper();
mapper.SetInput(xform.GetOutput());

%  A texture is loaded using an image reader. Textures are simply images.
%  The texture is eventually associated with an actor.
bmpReader = vtkBMPReader();
bmpReader.SetFileName(strcat(VTK_DATA_ROOT,"/Data/masonry.bmp"));
atext = vtkTexture();
atext.SetInput(bmpReader.GetOutput());
atext.InterpolateOn();
triangulation = vtkActor();
triangulation.SetMapper(mapper);
triangulation.SetTexture(atext);

%  Create the standard rendering stuff.
ren = vtkRenderer();
renWin = vtkRenderWindow();
renWin.AddRenderer(ren);
iren = vtkRenderWindowInteractor();
iren.SetRenderWindow(renWin);

%  Add the actors to the renderer, set the background and size
ren.AddActor(triangulation);
ren.SetBackground(1, 1, 1);
renWin.SetSize(300, 300);


% renWin.Render();
vtkInitializeInteractor(iren);
