function save_fig(device, file)

# save_fig(device, file)
#
# save current plot figure in 'file' for 'device' type.
#
# What is saved is all that is available in the plot buffer. To see what is
# available, type `plreplot'.
# To clear the plot buffer type `plbop' (botton of page).
#
# *Usual* devices are:
#	
#	ps         PostScript File (monochrome)
#	psc        PostScript File (color)
#	plmeta     PLPLOT Native Meta-File (can be displayed with 'plrender')
#	xfig       Xfig file
#	pbm        PDB (PPM) Driver
#	lj_hpgl    HP Laserjet III, HPGL emulation mode
#	hp7470     HP 7470 Plotter File (HPGL Cartridge, Small Plotter)
#	hp7580     HP 7580 Plotter File (Large Plotter)

global __pl __pl_inited

if (!exist("__pl_inited") || plglevel == 0)
	warning("Nothing to save");
	return
endif

__pl_strm = plgstrm + 1;
        
if (nargin == 2 && isstr(device) & isstr(file))
	 	cur_fig = plgstrm;
	 	f = min(find(__pl.open == 0));
	 	if (isempty(f))
	 		f = plmkstrm;
	 	endif
		new_fig = figure(f, device, file);
		plcpstrm(cur_fig, 0);
		plreplot;
		closefig(f)
		plsstrm(cur_fig)
else
	help save_fig
endif	

endfunction
