/*
 * Correctly rounded arcsine and arccosine
 *
 * Copyright (C) 2004-2011 David Defour, Catherine Daramy-Loirat,
 * Florent de Dinechin, Matthieu Gallet, Nicolas Gast, Christoph Quirin Lauter,
 * and Jean-Michel Muller
 *
 * This file is part of crlibm, the correctly rounded mathematical library,
 * which has been developed by the Arénaire project at École normale supérieure
 * de Lyon.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include "crlibm.h"
#include "crlibm_private.h"

#define RNROUNDCST 1.00277296776935912123020172797003775857085744686284e+00
#define RDROUNDCST 1.53329341668337408143884997262066747209318683475599e-19

#define RNROUNDCSTASINPI 1.00000001500000000000000000000000000000000000000000e+00
#define RDROUNDCSTASINPI 0.827180612553027674871408692069962853565812110900878906e-24

#define ASINSIMPLEBOUND 0x3e300000 
#define ACOSSIMPLEBOUND 0x3e400000

#define ASINPISIMPLEBOUND 0x3c300000
#define ACOSPISIMPLEBOUND 0x3c900000
#define ASINPINOSUBNORMALBOUND 0xa5000000

#define EXTRABOUND  0x3f500000  
#define EXTRABOUND2 0x3f020000

#define PIHALFH 1.57079632679489655799898173427209258079528808593750e+00
#define PIHALFM 6.12323399573676603586882014729198302312846062338790e-17
#define PIHALFL -1.49738490485916983294350817710599200835275047616952e-33

#define PIHALFRU 0.15707963267948967800435866593034006655216217041015625e1 

#define PIRU  0.3141592653589793560087173318606801331043243408203125e1
#define PIH   0.3141592653589793115997963468544185161590576171875e1
#define PIM   0.12246467991473532071737640294583966046256921246775800638e-15
#define PIL   -0.29947698097183396658870163542119840167055009523390379678e-32

#define RECPRPIH 0.318309886183790691216444201927515678107738494873046875
#define RECPRPIM -0.19678676675182485881895190914091814184147410411859432932679681016452e-16
#define RECPRPIL -0.10721436282893004003289965208411408821619722030338845557662168511367e-32

#define MRECPRPIH -0.318309886183790691216444201927515678107738494873046875
#define MRECPRPIM 0.19678676675182485881895190914091814184147410411859432932679681016452e-16
#define MRECPRPIL 0.10721436282893004003289965208411408821619722030338845557662168511367e-32

#define HALFPLUSULP      0.50000000000000011102230246251565404236316680908203125
#define HALFMINUSHALFULP 0.499999999999999944488848768742172978818416595458984375

#define TWO1000  0.107150860718626732094842504906000181056140481170553360744e302
#define TWOM1000 0.933263618503218878990089544723817169617091446371708024622e-301
#define TWO999   0.535754303593133660474212524530000905280702405852766803722e301

#define ASINBADCASEX   0.47810755953933303796787868122919462621212005615234375
#define ASINBADCASEYRU 0.49849878588087548347829169870237819850444793701171875
#define ASINBADCASEYRD 0.498498785880875427967140467444551177322864532470703125


#define p0_quick_coeff_19h  1.28394578033992016324882357025671808514744043350219726562500000000000000000000000e-02
#define p0_quick_coeff_17h  1.11230171262417399519195626567125145811587572097778320312500000000000000000000000e-02
#define p0_quick_coeff_15h  1.39970189350021451124561622236797120422124862670898437500000000000000000000000000e-02
#define p0_quick_coeff_13h  1.73513233791185925158906400156411109492182731628417968750000000000000000000000000e-02
#define p0_quick_coeff_11h  2.23721986984502102524530187110940460115671157836914062500000000000000000000000000e-02
#define p0_quick_coeff_9h   3.03819437875142428495678359468001872301101684570312500000000000000000000000000000e-02
#define p0_quick_coeff_7h   4.46428571490314687886247213555179769173264503479003906250000000000000000000000000e-02
#define p0_quick_coeff_5h   7.49999999999713951037705328417359851300716400146484375000000000000000000000000000e-02
#define p0_quick_coeff_3h   1.66666666666666712925959359381522517651319503784179687500000000000000000000000000e-01
#define p0_quick_coeff_1h   1.00000000000000000000000000000000000000000000000000000000000000000000000000000000e+00

#define mi_i              asinPolyQuickMiddleTbl[16 * index + 0]
#define p_quick_coeff_0h  asinPolyQuickMiddleTbl[16 * index + 1]
#define p_quick_coeff_0m  asinPolyQuickMiddleTbl[16 * index + 2]
#define p_quick_coeff_1h  asinPolyQuickMiddleTbl[16 * index + 3]
#define p_quick_coeff_1m  asinPolyQuickMiddleTbl[16 * index + 4]
#define p_quick_coeff_2h  asinPolyQuickMiddleTbl[16 * index + 5]
#define p_quick_coeff_3h  asinPolyQuickMiddleTbl[16 * index + 6]
#define p_quick_coeff_4h  asinPolyQuickMiddleTbl[16 * index + 7]
#define p_quick_coeff_5h  asinPolyQuickMiddleTbl[16 * index + 8]
#define p_quick_coeff_6h  asinPolyQuickMiddleTbl[16 * index + 9]
#define p_quick_coeff_7h  asinPolyQuickMiddleTbl[16 * index + 10]
#define p_quick_coeff_8h  asinPolyQuickMiddleTbl[16 * index + 11]
#define p_quick_coeff_9h  asinPolyQuickMiddleTbl[16 * index + 12]
#define p_quick_coeff_10h asinPolyQuickMiddleTbl[16 * index + 13]
#define p_quick_coeff_11h asinPolyQuickMiddleTbl[16 * index + 14]
#define p_quick_coeff_12h asinPolyQuickMiddleTbl[16 * index + 15]

#define MI_9 0.87500000000078237416545334781403653323650360107421875

#define p9_quick_coeff_0h 1.01072102056824553173441927356179803609848022460937500000000000000000000000000000e+00
#define p9_quick_coeff_1h -8.82981536812866424357437722392205614596605300903320312500000000000000000000000000e-02
#define p9_quick_coeff_2h 2.10353760393442237863759203264635289087891578674316406250000000000000000000000000e-02
#define p9_quick_coeff_3h -6.65063923819934552095212154654291225597262382507324218750000000000000000000000000e-03
#define p9_quick_coeff_4h 2.40768516599235756631136595729003602173179388046264648437500000000000000000000000e-03
#define p9_quick_coeff_5h -9.43873142704901193882072174545783127541653811931610107421875000000000000000000000e-04
#define p9_quick_coeff_6h 3.89946181164527888064752492169873221428133547306060791015625000000000000000000000e-04
#define p9_quick_coeff_7h -1.67200190558221219085804909454395783541258424520492553710937500000000000000000000e-04
#define p9_quick_coeff_8h 7.37040535228812338126858083597880977322347462177276611328125000000000000000000000e-05
#define p9_quick_coeff_9h -3.32003992244226181431050737291599261880037374794483184814453125000000000000000000e-05
#define p9_quick_coeff_10h 1.53656152855036036170705004977321550541091710329055786132812500000000000000000000e-05
#define p9_quick_coeff_11h -7.04415207421768136802344914548790200115035986527800559997558593750000000000000000e-06


#define p0_accu_coeff_1h 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000e+00
#define p0_accu_coeff_3h 1.66666666666666657414808128123695496469736099243164062500000000000000000000000000e-01
#define p0_accu_coeff_3m 9.25185853854296757512770104458324356634117384146900539554358999794203555211424828e-18
#define p0_accu_coeff_5h 7.49999999999999972244424384371086489409208297729492187500000000000000000000000000e-02
#define p0_accu_coeff_5m 2.77555756157123848551244900139306363413139848179272961559149734966922551393508911e-18
#define p0_accu_coeff_7h 4.46428571428571438484134148438897682353854179382324218750000000000000000000000000e-02
#define p0_accu_coeff_7m -9.91270564650888671257031422999640405542600950171395167431764861021292745135724545e-19
#define p0_accu_coeff_9h 3.03819444444444440589503386718206456862390041351318359375000000000000000000000000e-02
#define p0_accu_coeff_9m 3.85497067132392282371332994114988395042540962791093560324551248186253360472619534e-19
#define p0_accu_coeff_11h 2.23721590909090918553037141691675060428678989410400390625000000000000000000000000e-02
#define p0_accu_coeff_11m -9.46970190235819944882493359250540536388374860744029243297958942093828227370977402e-19
#define p0_accu_coeff_13h 1.73527644230769238775646812200648128055036067962646484375000000000000000000000000e-02
#define p0_accu_coeff_13m -6.73286913315360860061003796178520710524664576113391175476996508564297982957214117e-19
#define p0_accu_coeff_15h 1.39648437499999850813781065994589880574494600296020507812500000000000000000000000e-02
#define p0_accu_coeff_17h 1.15518008961409714141499449624461703933775424957275390625000000000000000000000000e-02
#define p0_accu_coeff_19h 9.76160952911427071132521859908592887222766876220703125000000000000000000000000000e-03
#define p0_accu_coeff_21h 8.39033581342360154642356917520373826846480369567871093750000000000000000000000000e-03
#define p0_accu_coeff_23h 7.31252573485535913022648202286291052587330341339111328125000000000000000000000000e-03
#define p0_accu_coeff_25h 6.44721419032266533644115469314783695153892040252685546875000000000000000000000000e-03
#define p0_accu_coeff_27h 5.73995473599474108350459999883241835050284862518310546875000000000000000000000000e-03
#define p0_accu_coeff_29h 5.15465255859299739671364193327462999150156974792480468750000000000000000000000000e-03
#define p0_accu_coeff_31h 4.64401037031901206542094939777598483487963676452636718750000000000000000000000000e-03
#define p0_accu_coeff_33h 4.37957744519422778606276835944299818947911262512207031250000000000000000000000000e-03
#define p0_accu_coeff_35h 3.08318270558301894476715965254243201343342661857604980468750000000000000000000000e-03
#define p0_accu_coeff_37h 6.23791382502981474333925149267088272608816623687744140625000000000000000000000000e-03

#define p_accu_coeff_0h  asinPolyAccuMiddleTbl[32 * index + 0]
#define p_accu_coeff_0m  asinPolyAccuMiddleTbl[32 * index + 1]
#define p_accu_coeff_1h  asinPolyAccuMiddleTbl[32 * index + 2]
#define p_accu_coeff_1m  asinPolyAccuMiddleTbl[32 * index + 3]
#define p_accu_coeff_2h  asinPolyAccuMiddleTbl[32 * index + 4]
#define p_accu_coeff_2m  asinPolyAccuMiddleTbl[32 * index + 5]
#define p_accu_coeff_3h  asinPolyAccuMiddleTbl[32 * index + 6]
#define p_accu_coeff_3m  asinPolyAccuMiddleTbl[32 * index + 7]
#define p_accu_coeff_4h  asinPolyAccuMiddleTbl[32 * index + 8]
#define p_accu_coeff_4m  asinPolyAccuMiddleTbl[32 * index + 9]
#define p_accu_coeff_5h  asinPolyAccuMiddleTbl[32 * index + 10]
#define p_accu_coeff_5m  asinPolyAccuMiddleTbl[32 * index + 11]
#define p_accu_coeff_6h  asinPolyAccuMiddleTbl[32 * index + 12]
#define p_accu_coeff_6m  asinPolyAccuMiddleTbl[32 * index + 13]
#define p_accu_coeff_7h  asinPolyAccuMiddleTbl[32 * index + 14]
#define p_accu_coeff_7m  asinPolyAccuMiddleTbl[32 * index + 15]
#define p_accu_coeff_8h  asinPolyAccuMiddleTbl[32 * index + 16]
#define p_accu_coeff_8m  asinPolyAccuMiddleTbl[32 * index + 17]
#define p_accu_coeff_9h  asinPolyAccuMiddleTbl[32 * index + 18]
#define p_accu_coeff_10h asinPolyAccuMiddleTbl[32 * index + 19]
#define p_accu_coeff_11h asinPolyAccuMiddleTbl[32 * index + 20]
#define p_accu_coeff_12h asinPolyAccuMiddleTbl[32 * index + 21]
#define p_accu_coeff_13h asinPolyAccuMiddleTbl[32 * index + 22]
#define p_accu_coeff_14h asinPolyAccuMiddleTbl[32 * index + 23]
#define p_accu_coeff_15h asinPolyAccuMiddleTbl[32 * index + 24]
#define p_accu_coeff_16h asinPolyAccuMiddleTbl[32 * index + 25]
#define p_accu_coeff_17h asinPolyAccuMiddleTbl[32 * index + 26]
#define p_accu_coeff_18h asinPolyAccuMiddleTbl[32 * index + 27]
#define p_accu_coeff_19h asinPolyAccuMiddleTbl[32 * index + 28]
#define p_accu_coeff_20h asinPolyAccuMiddleTbl[32 * index + 29]
#define p_accu_coeff_21h asinPolyAccuMiddleTbl[32 * index + 30]
#define p_accu_coeff_22h asinPolyAccuMiddleTbl[32 * index + 31]

#define p9_accu_coeff_0h 1.01072102056824553173441927356179803609848022460937500000000000000000000000000000e+00
#define p9_accu_coeff_0m 1.39129934510313097947345056199237890632902839379463674068793110905062349047511816e-20
#define p9_accu_coeff_1h -8.82981536812866424357437722392205614596605300903320312500000000000000000000000000e-02
#define p9_accu_coeff_1m 2.41792724167186006978828150786347532734726726246399404474107797113902051933109760e-18
#define p9_accu_coeff_2h 2.10353760393441266418612656252662418410181999206542968750000000000000000000000000e-02
#define p9_accu_coeff_2m 1.08336737333055412851633739558643005025128690376628494418387305131545872427523136e-18
#define p9_accu_coeff_3h -6.65063923820143239329372164547748980112373828887939453125000000000000000000000000e-03
#define p9_accu_coeff_3m -3.26520170221686406454105223534078119197675928213141878161951403569673857418820262e-19
#define p9_accu_coeff_4h 2.40768516606927433787443959545271354727447032928466796875000000000000000000000000e-03
#define p9_accu_coeff_4m -1.97265146971483602383336920707508202998297784121844945705998020102356349525507540e-19
#define p9_accu_coeff_5h -9.43873142126153748948658162021274620201438665390014648437500000000000000000000000e-04
#define p9_accu_coeff_5m -1.00627526920533400945274389592272919368733418903938436114037235924456581415142864e-20
#define p9_accu_coeff_6h 3.89946159535203471478703729502512942417524755001068115234375000000000000000000000e-04
#define p9_accu_coeff_6m -1.68716106145871574328060887792714981312318371720271803146373734705321112414821982e-21
#define p9_accu_coeff_7h -1.67200258171404256496775375673280450428137555718421936035156250000000000000000000e-04
#define p9_accu_coeff_7m 1.19784970040097203700724589956273625590162416200800595011445592863452702658833005e-20
#define p9_accu_coeff_8h 7.37067653300902520495385683574340873747132718563079833984375000000000000000000000e-05
#define p9_accu_coeff_9h -3.31971960015731878111157338029357788400375284254550933837890625000000000000000000e-05
#define p9_accu_coeff_10h 1.52100265651915579552836896293221968790021492168307304382324218750000000000000000e-05
#define p9_accu_coeff_11h -7.06684216556374468498364499469133193088055122643709182739257812500000000000000000e-06
#define p9_accu_coeff_12h 3.32174016771150049044582924784307920162973459810018539428710937500000000000000000e-06
#define p9_accu_coeff_13h -1.57676504579047108034364592377141178758392925374209880828857421875000000000000000e-06
#define p9_accu_coeff_14h 7.54770805302124936124669781628560016883966454770416021347045898437500000000000000e-07
#define p9_accu_coeff_15h -3.63931772276869473623270951831432107326236291555687785148620605468750000000000000e-07
#define p9_accu_coeff_16h 1.76596931693785619791949872102454488498324280953966081142425537109375000000000000e-07
#define p9_accu_coeff_17h -8.61593313016896376739609539688324879591618810081854462623596191406250000000000000e-08
#define p9_accu_coeff_18h 4.22538400682347749169000988064132107169257324130740016698837280273437500000000000e-08
#define p9_accu_coeff_19h -2.12414533709850257115170054159070112120843987213447690010070800781250000000000000e-08
#define p9_accu_coeff_20h 1.04941939883081181921218176284101020190320241454173810780048370361328125000000000e-08



static const double asinPolyQuickMiddleTbl[128] = {
0.30177669529663886383019644199521280825138092041015625,                                     // mi_1     
3.06555683602418194144689778113388456404209136962890625000000000000000000000000000e-01,	     // p_coeff_0h	 
1.37864228855288786229514205458277346294726855883500333047053665325165638932958245e-19,	     // p_coeff_0m	 
1.04890120337530645677759366662940010428428649902343750000000000000000000000000000e+00,	     // p_coeff_1h	 
-1.03997489957388085277493589447823941146606896923035995294881672634801361709833145e-16,     // p_coeff_1m	 
1.74124328129031780143520791170885786414146423339843750000000000000000000000000000e-01,	     // p_coeff_2h	 
2.50143932843980842939402009506011381745338439941406250000000000000000000000000000e-01,	     // p_coeff_3h	 
1.67670575222466200493443011509953066706657409667968750000000000000000000000000000e-01,	     // p_coeff_4h	 
2.01779349315375722273557812513899989426136016845703125000000000000000000000000000e-01,	     // p_coeff_5h	 
1.98874061108935212827120153633586596697568893432617187500000000000000000000000000e-01,	     // p_coeff_6h	 
2.35900184842710441968094414733059238642454147338867187500000000000000000000000000e-01,	     // p_coeff_7h	 
2.67930172148400869147621961019467562437057495117187500000000000000000000000000000e-01,	     // p_coeff_8h	 
3.24866122351198272077965611970284953713417053222656250000000000000000000000000000e-01,	     // p_coeff_9h	 
3.92983759990528369598905555903911590576171875000000000000000000000000000000000000e-01,	     // p_coeff_10h	 
4.95395034513885057503301823089714162051677703857421875000000000000000000000000000e-01,	     // p_coeff_11h	 
6.17581482281306048953695153613807633519172668457031250000000000000000000000000000e-01,	     // p_coeff_12h	 
0.393283046242751843646345832894439809024333953857421875,  		                     // mi_2  
4.04199666960039116769820566332782618701457977294921875000000000000000000000000000e-01,	     // p_coeff_0h	 
-7.29414577305862355348006038497258990002592122212580672446953500287492033749003895e-21,     // p_coeff_0m	 
1.08764522696446319649510314775398001074790954589843750000000000000000000000000000e+00,	     // p_coeff_1h	 
7.18002807945845121967809924279486007735232949667977808694274699519155547022819519e-17,	     // p_coeff_1m	 
2.53009602569167157959384439891437068581581115722656250000000000000000000000000000e-01,	     // p_coeff_2h	 
3.32153251441154206968775497443857602775096893310546875000000000000000000000000000e-01,	     // p_coeff_3h	 
2.92932692232720115477206945797661319375038146972656250000000000000000000000000000e-01,	     // p_coeff_4h	 
3.67616411036137902268450261544785462319850921630859375000000000000000000000000000e-01,	     // p_coeff_5h	 
4.41363028117747802081538566199014894664287567138671875000000000000000000000000000e-01,	     // p_coeff_6h	 
5.81535898184487698436839764326578006148338317871093750000000000000000000000000000e-01,	     // p_coeff_7h	 
7.75300865782017067928677533927839249372482299804687500000000000000000000000000000e-01,	     // p_coeff_8h	 
1.06930850499925678143142704357160255312919616699218750000000000000000000000000000e+00,	     // p_coeff_9h	 
1.49812947255186612594002326659392565488815307617187500000000000000000000000000000e+00,	     // p_coeff_10h	 
2.15844993342769164712535712169483304023742675781250000000000000000000000000000000e+00,	     // p_coeff_11h	 
3.06928679300128992579743680835235863924026489257812500000000000000000000000000000e+00,	     // p_coeff_12h	 
0.466506350946100212251366201599012129008769989013671875,				     // mi_3 
4.85336867180323261461438733022077940404415130615234375000000000000000000000000000e-01,	     // p_coeff_0h	 
2.48687685471405101032185714779683260767432502103446885499682394993214984424412251e-18,	     // p_coeff_0m	 
1.13055943592368102201817237073555588722229003906250000000000000000000000000000000e+00,	     // p_coeff_1h	 
8.31884808460703843039094509953103826114589262451931572783792034897487610578536987e-17,	     // p_coeff_1m	 
3.37060423475326498277127029723487794399261474609375000000000000000000000000000000e-01,	     // p_coeff_2h	 
4.41819848339723264540879199557821266353130340576171875000000000000000000000000000e-01,	     // p_coeff_3h	 
4.72912200341658373048403518623672425746917724609375000000000000000000000000000000e-01,	     // p_coeff_4h	 
6.48901300732837138518505071260733529925346374511718750000000000000000000000000000e-01,	     // p_coeff_5h	 
9.02760918994661598624418274994241073727607727050781250000000000000000000000000000e-01,	     // p_coeff_6h	 
1.33957799576799718721531462506391108036041259765625000000000000000000000000000000e+00,	     // p_coeff_7h	 
2.03975089767692541187216193065978586673736572265625000000000000000000000000000000e+00,	     // p_coeff_8h	 
3.19221018967622649498139253410045057535171508789062500000000000000000000000000000e+00,	     // p_coeff_9h	 
5.09007693218536960699793780804611742496490478515625000000000000000000000000000000e+00,	     // p_coeff_10h	 
8.32900562875201266876956651685759425163269042968750000000000000000000000000000000e+00,	     // p_coeff_11h	 
1.35684931403507018643495030119083821773529052734375000000000000000000000000000000e+01,	     // p_coeff_12h	 
0.52950849718750470085382175966515205800533294677734375,				     // mi_4
5.58021066268902909968119274708442389965057373046875000000000000000000000000000000e-01,	     // p_coeff_0h	 
9.12034392087434999453497016043152989309974709890359127750780743326686206273734570e-20,	     // p_coeff_0m	 
1.17882180572684136521388609253335744142532348632812500000000000000000000000000000e+00,	     // p_coeff_1h	 
2.42941652280796864299660766500640409154688815034626482580737416583360754884779453e-18,	     // p_coeff_1m	 
4.33698001053000381510571514809271320700645446777343750000000000000000000000000000e-01,	     // p_coeff_2h	 
5.92141175601994751431789154594298452138900756835937500000000000000000000000000000e-01,	     // p_coeff_3h	 
7.45525652675174788086565058620180934667587280273437500000000000000000000000000000e-01,	     // p_coeff_4h	 
1.13828091051635160724231354834046214818954467773437500000000000000000000000000000e+00,	     // p_coeff_5h	 
1.80888030356391027453355491161346435546875000000000000000000000000000000000000000e+00,	     // p_coeff_6h	 
3.03311161272506835118178969423752278089523315429687500000000000000000000000000000e+00,	     // p_coeff_7h	 
5.24261669742490976631188459577970206737518310546875000000000000000000000000000000e+00,	     // p_coeff_8h	 
9.29745896553562900521683332044631242752075195312500000000000000000000000000000000e+00,	     // p_coeff_9h	 
1.68115356121078072249019896844401955604553222656250000000000000000000000000000000e+01,	     // p_coeff_10h	 
3.11875660002322234731764183379709720611572265625000000000000000000000000000000000e+01,	     // p_coeff_11h	 
5.76621480399203818478781613521277904510498046875000000000000000000000000000000000e+01,	     // p_coeff_12h	 
0.58569471503532011258386091867578215897083282470703125,				     // mi_5   	 
6.25736902820868912122875826753443107008934020996093750000000000000000000000000000e-01,	     // p_coeff_0h	 
1.09771341515678393197247834713042073087550408801910172083143857335585380496922880e-20,	     // p_coeff_0m	 
1.23375797792237640315704538807040080428123474121093750000000000000000000000000000e+00,	     // p_coeff_1h	 
-1.59140559577392273960428308971385735880640476257478696520131222769123269245028496e-17,     // p_coeff_1m	 
5.49960162399266483390647408668883144855499267578125000000000000000000000000000000e-01,	     // p_coeff_2h	 
8.03296584298027416259913024987326934933662414550781250000000000000000000000000000e-01,	     // p_coeff_3h	 
1.17423627321739276752055047836620360612869262695312500000000000000000000000000000e+00,	     // p_coeff_4h	 
2.01583293591475243289323771023191511631011962890625000000000000000000000000000000e+00,	     // p_coeff_5h	 
3.64900021733109003463368935626931488513946533203125000000000000000000000000000000e+00,	     // p_coeff_6h	 
6.93854486506604661855135418591089546680450439453125000000000000000000000000000000e+00,	     // p_coeff_7h	 
1.36226794507666699729497850057668983936309814453125000000000000000000000000000000e+01,	     // p_coeff_8h	 
2.74281125080204652988413727143779397010803222656250000000000000000000000000000000e+01,	     // p_coeff_9h	 
5.63049247624184658889134880155324935913085937500000000000000000000000000000000000e+01,	     // p_coeff_10h	 
1.18700353964991606403600599151104688644409179687500000000000000000000000000000000e+02,	     // p_coeff_11h	 
2.55076107485252919104823376983404159545898437500000000000000000000000000000000000e+02,	     // p_coeff_12h	 
0.636905131730956863833625902771018445491790771484375, 					     // mi_6  
6.90477178468776764397318856936180964112281799316406250000000000000000000000000000e-01,	     // p_coeff_0h	 
3.39469506786599975391257859730058491397981612722623695477253136232320684939622879e-18,	     // p_coeff_0m	 
1.29711412734153253012436834978871047496795654296875000000000000000000000000000000e+00,	     // p_coeff_1h	 
-4.95712225725049321877947559927504147795821978121980078135777603165479376912117004e-17,     // p_coeff_1m	 
6.94991224248453054457286270917393267154693603515625000000000000000000000000000000e-01,	     // p_coeff_2h	 
1.10848340356457941702217340207425877451896667480468750000000000000000000000000000e+00,	     // p_coeff_3h	 
1.87458354117332537391860114439623430371284484863281250000000000000000000000000000e+00,	     // p_coeff_4h	 
3.65157801390048675216348783578723669052124023437500000000000000000000000000000000e+00,	     // p_coeff_5h	 
7.55165652847091450894367881119251251220703125000000000000000000000000000000000000e+00,	     // p_coeff_6h	 
1.63735362549250531571942701702937483787536621093750000000000000000000000000000000e+01,	     // p_coeff_7h	 
3.66799061204043113093575811944901943206787109375000000000000000000000000000000000e+01,	     // p_coeff_8h	 
8.42542910813925374213795294053852558135986328125000000000000000000000000000000000e+01,	     // p_coeff_9h	 
1.97368592013039233279414474964141845703125000000000000000000000000000000000000000e+02,	     // p_coeff_10h	 
4.75165552896886765665840357542037963867187500000000000000000000000000000000000000e+02,	     // p_coeff_11h	 
1.14668095983602756859909277409315109252929687500000000000000000000000000000000000e+03,	     // p_coeff_12h	 
0.68427230447631171017519591259770095348358154296875,					     // mi_7 	 
7.53605330605588874526290510402759537100791931152343750000000000000000000000000000e-01,	     // p_coeff_0h	 
-6.81399026788433814240085924387948818667013384621768622671778015131849315366707742e-20,     // p_coeff_0m	 
1.37131588394733516800272354885237291455268859863281250000000000000000000000000000e+00,	     // p_coeff_1h	 
5.75522635997281408409017033924079017806689197384387157718776961701223626732826233e-17,	     // p_coeff_1m	 
8.82290262843787198576706032326910644769668579101562500000000000000000000000000000e-01,	     // p_coeff_2h	 
1.56510752146510800919543271447764709591865539550781250000000000000000000000000000e+00,	     // p_coeff_3h	 
3.07048550645086359978108703217003494501113891601562500000000000000000000000000000e+00,	     // p_coeff_4h	 
6.85588913497096008597964100772514939308166503906250000000000000000000000000000000e+00,	     // p_coeff_5h	 
1.63125257116160859993669873801991343498229980468750000000000000000000000000000000e+01,	     // p_coeff_6h	 
4.06593958002900990322814323008060455322265625000000000000000000000000000000000000e+01,	     // p_coeff_7h	 
1.04739642911711854367240448482334613800048828125000000000000000000000000000000000e+02,	     // p_coeff_8h	 
2.76645653402371124229830456897616386413574218750000000000000000000000000000000000e+02,	     // p_coeff_9h	 
7.45184231247284060373203828930854797363281250000000000000000000000000000000000000e+02,	     // p_coeff_10h	 
2.06663648786018939063069410622119903564453125000000000000000000000000000000000000e+03,	     // p_coeff_11h	 
5.75344088930418638483388349413871765136718750000000000000000000000000000000000000e+03,	     // p_coeff_12h	 
0.7285533905932444209696541292942129075527191162109375,					     // mi_8   
8.16207699480864135033186812506755813956260681152343750000000000000000000000000000e-01,	     // p_coeff_0h	 
1.13998759014226814082709277093003596330685011160153518976201336698750310461036861e-20,	     // p_coeff_0m	 
1.45987741598546749699494284868706017732620239257812500000000000000000000000000000e+00,	     // p_coeff_1h	 
1.00585284375539824516783136958955684505754068277117579954804682529356796294450760e-16,	     // p_coeff_1m	 
1.13339308477403566399743795045651495456695556640625000000000000000000000000000000e+00,	     // p_coeff_2h	 
2.27840492593358323603069948148913681507110595703125000000000000000000000000000000e+00,	     // p_coeff_3h	 
5.22734481752265178755578745040111243724822998046875000000000000000000000000000000e+00,	     // p_coeff_4h	 
1.35483951828855158083797505241818726062774658203125000000000000000000000000000000e+01,	     // p_coeff_5h	 
3.74970966332361186346133763436228036880493164062500000000000000000000000000000000e+01,	     // p_coeff_6h	 
1.08680173096203162685924326069653034210205078125000000000000000000000000000000000e+02,	     // p_coeff_7h	 
3.25593435218005822662235004827380180358886718750000000000000000000000000000000000e+02,	     // p_coeff_8h	 
1.00013553235534163832198828458786010742187500000000000000000000000000000000000000e+03,	     // p_coeff_9h	 
3.13330209627358499346883036196231842041015625000000000000000000000000000000000000e+03,	     // p_coeff_10h	 
1.01324957719780304614687338471412658691406250000000000000000000000000000000000000e+04,	     // p_coeff_11h	 
3.27393534650766232516616582870483398437500000000000000000000000000000000000000000e+04	     // p_coeff_12h	 
};


static const double asinPolyAccuMiddleTbl[258] = {
3.06555683602418194144689778113388456404209136962890625000000000000000000000000000e-01,		   // p_coeff_0h	 
1.38398751617026410180086928097698669616246328887899420551771401122209681489039212e-19,		   // p_coeff_0m	 
1.04890120337530645677759366662940010428428649902343750000000000000000000000000000e+00,		   // p_coeff_1h	 
-1.03082627287649058162739898016810705246384011505786371110104937542928382754325867e-16,	   // p_coeff_1m	 
1.74124328129031780143520791170885786414146423339843750000000000000000000000000000e-01,		   // p_coeff_2h	 
-1.22415542219236523063144722572481689558635471916500300770813680628634756430983543e-17,	   // p_coeff_2m	 
2.50143932843971239510239001901936717331409454345703125000000000000000000000000000e-01,		   // p_coeff_3h	 
-4.13151149720064821141736364751386140320745355927365902171111144980386598035693169e-18,	   // p_coeff_3m	 
1.67670575222510526147701170884829480201005935668945312500000000000000000000000000e-01,		   // p_coeff_4h	 
9.08471320692536034881317437634606200189439625594786317797080243963137036189436913e-18,		   // p_coeff_4m	 
2.01779349344123004605933147104224190115928649902343750000000000000000000000000000e-01,		   // p_coeff_5h	 
-2.81327768912778086871203966934740276353563377312707108335310124402894871309399605e-18,	   // p_coeff_5m	 
1.98874061057130652185875874238263349980115890502929687500000000000000000000000000e-01,		   // p_coeff_6h	 
4.84208641776008377910230190635861197948724910162295737015014651660749223083257675e-18,		   // p_coeff_6m	 
2.35900148032034129297329627661383710801601409912109375000000000000000000000000000e-01,		   // p_coeff_7h	 
-7.70265627820459694705350308676046582995139915634938421185040624550310894846916199e-18,	   // p_coeff_7m	 
2.67930188076546671460675952403107658028602600097656250000000000000000000000000000e-01,		   // p_coeff_8h	 
-1.74203278137786025999080009256505191287370077696727496685547009747097035869956017e-17,	   // p_coeff_8m	 
3.24889007694808218396076426870422437787055969238281250000000000000000000000000000e-01,		   // p_coeff_9h	 
3.92992300726306809099952488395501859486103057861328125000000000000000000000000000e-01,		   // p_coeff_10h	 
4.88578374389609604300233058893354609608650207519531250000000000000000000000000000e-01,		   // p_coeff_11h	 
6.11426267619878727188620359811466187238693237304687500000000000000000000000000000e-01,		   // p_coeff_12h	 
7.76087253732093085289989176089875400066375732421875000000000000000000000000000000e-01,		   // p_coeff_13h	 
9.92362795771243533238248346606269478797912597656250000000000000000000000000000000e-01,		   // p_coeff_14h	 
1.28020190849177639691447438963223248720169067382812500000000000000000000000000000e+00,		   // p_coeff_15h	 
1.66202082783864191206646410137182101607322692871093750000000000000000000000000000e+00,		   // p_coeff_16h	 
2.17134697355479078240136914246249943971633911132812500000000000000000000000000000e+00,		   // p_coeff_17h	 
2.85144941725608758176235824066679924726486206054687500000000000000000000000000000e+00,		   // p_coeff_18h	 
3.76113082197504100534501958463806658983230590820312500000000000000000000000000000e+00,		   // p_coeff_19h	 
4.98320258065187005058760405518114566802978515625000000000000000000000000000000000e+00,		   // p_coeff_20h	 
6.83567147351494863727339179604314267635345458984375000000000000000000000000000000e+00,		   // p_coeff_21h	 
9.17671174961649249723905086284503340721130371093750000000000000000000000000000000e+00,		   // p_coeff_22h	 
4.04199666960039116769820566332782618701457977294921875000000000000000000000000000e-01,		   // p_coeff_0h	 
-6.46825370068901234687011200856515476665908008275043725957432344531028434175823350e-21,	   // p_coeff_0m	 
1.08764522696446319649510314775398001074790954589843750000000000000000000000000000e+00,		   // p_coeff_1h	 
7.20122509204450857334003577729908463703780203035882678808121681868215091526508331e-17,		   // p_coeff_1m	 
2.53009602569167157959384439891437068581581115722656250000000000000000000000000000e-01,		   // p_coeff_2h	 
-2.62855515233500204494953653812414612827096270443634484781370019845780916512012482e-17,	   // p_coeff_2m	 
3.32153251441150376699340540653793141245841979980468750000000000000000000000000000e-01,		   // p_coeff_3h	 
-2.17141385535786665092496720426544052591009587195721927677105611564911669120192528e-17,	   // p_coeff_3m	 
2.92932692232876656923679092869861051440238952636718750000000000000000000000000000e-01,		   // p_coeff_4h	 
-2.54506532782342113657805222827712812531223364242776927013345300565561046823859215e-17,	   // p_coeff_4m	 
3.67616411055874059421455513074761256575584411621093750000000000000000000000000000e-01,		   // p_coeff_5h	 
-6.76970835849273256879417289105284614692988316998734608931354017613557516597211361e-18,	   // p_coeff_5m	 
4.41363027759851866971274603201891295611858367919921875000000000000000000000000000e-01,		   // p_coeff_6h	 
-2.90651996480231385490406350336172813253854649135862232844917940610685036517679691e-18,	   // p_coeff_6m	 
5.81535855061384165942683921457501128315925598144531250000000000000000000000000000e-01,		   // p_coeff_7h	 
2.15506151894707480118506866417280461854749969158187919426872269923478597775101662e-17,		   // p_coeff_7m	 
7.75301235143548206352193119528237730264663696289062500000000000000000000000000000e-01,		   // p_coeff_8h	 
-5.09980429509694427469186543286592667631136122693286116813737862685229629278182983e-17,	   // p_coeff_8m	 
1.06935418322891551135001009242841973900794982910156250000000000000000000000000000e+00,		   // p_coeff_9h	 
1.49796852292175275422891900234390050172805786132812500000000000000000000000000000e+00,		   // p_coeff_10h	 
2.13528146071462776589555687678512185811996459960937500000000000000000000000000000e+00,		   // p_coeff_11h	 
3.08095882478763538614430217421613633632659912109375000000000000000000000000000000e+00,		   // p_coeff_12h	 
4.49525762116327154416239864076487720012664794921875000000000000000000000000000000e+00,		   // p_coeff_13h	 
6.61832853156151212914437564904801547527313232421875000000000000000000000000000000e+00,		   // p_coeff_14h	 
9.82196882969892293147040618350729346275329589843750000000000000000000000000000000e+00,		   // p_coeff_15h	 
1.46763291696545170594845330924727022647857666015625000000000000000000000000000000e+01,		   // p_coeff_16h	 
2.20625545956168913619421800831332802772521972656250000000000000000000000000000000e+01,		   // p_coeff_17h	 
3.33428595472074320582578366156667470932006835937500000000000000000000000000000000e+01,		   // p_coeff_18h	 
5.06298287402715487814930384047329425811767578125000000000000000000000000000000000e+01,		   // p_coeff_19h	 
7.72361044088683854624832747504115104675292968750000000000000000000000000000000000e+01,		   // p_coeff_20h	 
1.19605340680796203400859667453914880752563476562500000000000000000000000000000000e+02,		   // p_coeff_21h	 
1.80182167313889749493682757019996643066406250000000000000000000000000000000000000e+02,		   // p_coeff_22h	 
4.85336867180323261461438733022077940404415130615234375000000000000000000000000000e-01,		   // p_coeff_0h	 
2.48711731548431450339898686061161136444646421020973452165048200868113781325519085e-18,		   // p_coeff_0m	 
1.13055943592368102201817237073555588722229003906250000000000000000000000000000000e+00,		   // p_coeff_1h	 
8.33253077521152707672020411779329031688034814541986283753516318029141984879970551e-17,		   // p_coeff_1m	 
3.37060423475326498277127029723487794399261474609375000000000000000000000000000000e-01,		   // p_coeff_2h	 
-1.06567668725757610844479862637418971752325776427227331522029629695680341683328152e-17,	   // p_coeff_2m	 
4.41819848339719767338351630314718931913375854492187500000000000000000000000000000e-01,		   // p_coeff_3h	 
1.00442163349492148002936541754087371062381994416120786772772532913222676143050194e-17,		   // p_coeff_3m	 
4.72912200341745858622743980959057807922363281250000000000000000000000000000000000e-01,		   // p_coeff_4h	 
4.32579192702017095690398912101462577298397752038590716172627992364141391590237617e-18,		   // p_coeff_4m	 
6.48901300757961929654982213833136484026908874511718750000000000000000000000000000e-01,		   // p_coeff_5h	 
5.53173550473638312502352924376368778723557407693469517573348070982319768518209457e-17,		   // p_coeff_5m	 
9.02760918723618410730580308154458180069923400878906250000000000000000000000000000e-01,		   // p_coeff_6h	 
1.83127184204758972652773042458306136013081307308989972848500826785311801359057426e-17,		   // p_coeff_6m	 
1.33957791852745100591448590421350672841072082519531250000000000000000000000000000e+00,		   // p_coeff_7h	 
-8.08660441258249393782142982707336982340679568071958871477988850529072806239128113e-17,	   // p_coeff_7m	 
2.03975126091931757699171612330246716737747192382812500000000000000000000000000000e+00,		   // p_coeff_8h	 
1.39326386720348649025304457272644525059897659732127683795965822355356067419052124e-16,		   // p_coeff_8m	 
3.19232532691492343346340021525975316762924194335937500000000000000000000000000000e+00,		   // p_coeff_9h	 
5.08990447700057480062696413369849324226379394531250000000000000000000000000000000e+00,		   // p_coeff_10h	 
8.24681325581985547046315332408994436264038085937500000000000000000000000000000000e+00,		   // p_coeff_11h	 
1.35339383861901847438957702252082526683807373046875000000000000000000000000000000e+01,		   // p_coeff_12h	 
2.24533939052931295066173333907499909400939941406250000000000000000000000000000000e+01,		   // p_coeff_13h	 
3.75945346965856899146274372469633817672729492187500000000000000000000000000000000e+01,		   // p_coeff_14h	 
6.34457878603441614018265681806951761245727539062500000000000000000000000000000000e+01,		   // p_coeff_15h	 
1.07811054823829493898301734589040279388427734375000000000000000000000000000000000e+02,		   // p_coeff_16h	 
1.84306463662936579339657328091561794281005859375000000000000000000000000000000000e+02,		   // p_coeff_17h	 
3.16759786376428792209480889141559600830078125000000000000000000000000000000000000e+02,		   // p_coeff_18h	 
5.47025706678748861122585367411375045776367187500000000000000000000000000000000000e+02,		   // p_coeff_19h	 
9.49215135261129944410640746355056762695312500000000000000000000000000000000000000e+02,		   // p_coeff_20h	 
1.66325303120893772756971884518861770629882812500000000000000000000000000000000000e+03,		   // p_coeff_21h	 
2.81005886721817250872845761477947235107421875000000000000000000000000000000000000e+03,		   // p_coeff_22h	 
5.58021066268902909968119274708442389965057373046875000000000000000000000000000000e-01,		   // p_coeff_0h	 
9.14056635248981946291334736807400951779846267656755277007663007537985322414897382e-20,		   // p_coeff_0m	 
1.17882180572684136521388609253335744142532348632812500000000000000000000000000000e+00,		   // p_coeff_1h	 
2.57506761959083747975269601591872190204330911429892510960959484123122820165008307e-18,		   // p_coeff_1m	 
4.33698001053000381510571514809271320700645446777343750000000000000000000000000000e-01,		   // p_coeff_2h	 
-1.13987489167043526825762332057111190978471845558278249810335580605169525370001793e-17,	   // p_coeff_2m	 
5.92141175601989977472783266421174630522727966308593750000000000000000000000000000e-01,		   // p_coeff_3h	 
1.51434599074934130528344780896022003291074232766760462864930047999223461374640465e-17,		   // p_coeff_3m	 
7.45525652675293803994804875401314347982406616210937500000000000000000000000000000e-01,		   // p_coeff_4h	 
-4.95666529120828261720386639182573717908098482969568576717023233868530951440334320e-17,	   // p_coeff_4m	 
1.13828091056041680317889586149249225854873657226562500000000000000000000000000000e+00,		   // p_coeff_5h	 
6.30476130024642952826684347359752494928069360322596403900519135277136228978633881e-17,		   // p_coeff_5m	 
1.80888030309746783430568939365912228822708129882812500000000000000000000000000000e+00,		   // p_coeff_6h	 
6.53471855925770582546264336577217040248932212759963578108113324560690671205520630e-17,		   // p_coeff_6m	 
3.03311143845375674743536364985629916191101074218750000000000000000000000000000000e+00,		   // p_coeff_7h	 
-2.14585117370534459252749227343052173552538040022033549725222201232099905610084534e-16,	   // p_coeff_7m	 
5.24261747644370590393236852833069860935211181640625000000000000000000000000000000e+00,		   // p_coeff_8h	 
-5.46512862978737750269761176067830595023185492192796530730447557289153337478637695e-17,	   // p_coeff_8m	 
9.29779331096978367554584110621362924575805664062500000000000000000000000000000000e+00,		   // p_coeff_9h	 
1.68111140106672962701850337907671928405761718750000000000000000000000000000000000e+01,		   // p_coeff_10h	 
3.08802874723923395094971056096255779266357421875000000000000000000000000000000000e+01,		   // p_coeff_11h	 
5.74616531317601229034153220709413290023803710937500000000000000000000000000000000e+01,		   // p_coeff_12h	 
1.08089434897446437844337197020649909973144531250000000000000000000000000000000000e+02,		   // p_coeff_13h	 
2.05202846011656902192044071853160858154296875000000000000000000000000000000000000e+02,		   // p_coeff_14h	 
3.92662709897826516680652275681495666503906250000000000000000000000000000000000000e+02,		   // p_coeff_15h	 
7.56557048606022931380721274763345718383789062500000000000000000000000000000000000e+02,		   // p_coeff_16h	 
1.46649727257876816111092921346426010131835937500000000000000000000000000000000000e+03,		   // p_coeff_17h	 
2.85782276299161503629875369369983673095703125000000000000000000000000000000000000e+03,		   // p_coeff_18h	 
5.59751274793538505036849528551101684570312500000000000000000000000000000000000000e+03,		   // p_coeff_19h	 
1.10145801644146959006320685148239135742187500000000000000000000000000000000000000e+04,		   // p_coeff_20h	 
2.15676400725272833369672298431396484375000000000000000000000000000000000000000000e+04,		   // p_coeff_21h	 
4.10662669419021476642228662967681884765625000000000000000000000000000000000000000e+04,		   // p_coeff_22h	 
6.25736902820868912122875826753443107008934020996093750000000000000000000000000000e-01,		   // p_coeff_0h	 
1.03044861946200352361105560063972534424839340803290894401332555840866689322865568e-20,		   // p_coeff_0m	 
1.23375797792237640315704538807040080428123474121093750000000000000000000000000000e+00,		   // p_coeff_1h	 
-1.56943153280384722085732805658465945105123195556662968330741136924189049750566483e-17,	   // p_coeff_1m	 
5.49960162399266483390647408668883144855499267578125000000000000000000000000000000e-01,		   // p_coeff_2h	 
4.77724544586887245869366226653936105958167895554379589473370515406713820993900299e-17,		   // p_coeff_2m	 
8.03296584298018756520320948766311630606651306152343750000000000000000000000000000e-01,		   // p_coeff_3h	 
8.24298592592304193429233278946371287822415169276122487440616737330856267362833023e-18,		   // p_coeff_3m	 
1.17423627321674173273891028657089918851852416992187500000000000000000000000000000e+00,		   // p_coeff_4h	 
6.51885136427795249608596859127055587343811181939758764292136561380175407975912094e-18,		   // p_coeff_4m	 
2.01583293601212298895575258939061313867568969726562500000000000000000000000000000e+00,		   // p_coeff_5h	 
-1.74898605368430358273924263609101302050140983100449953990818130478146485984325409e-16,	   // p_coeff_5m	 
3.64900022085783248826373892370611429214477539062500000000000000000000000000000000e+00,		   // p_coeff_6h	 
1.43304714197470670030886399120078425706334125872346008101487768726656213402748108e-16,		   // p_coeff_6m	 
6.93854439566079062018388867727480828762054443359375000000000000000000000000000000e+00,		   // p_coeff_7h	 
-3.60750117305009285790273957823616258349535174413877380850124154676450416445732117e-16,	   // p_coeff_7m	 
1.36226702672788579917551032849587500095367431640625000000000000000000000000000000e+01,		   // p_coeff_8h	 
5.62980642478103599614115253967152086402971956392848884576096679666079580783843994e-16,		   // p_coeff_8m	 
2.74292117002245703361040796153247356414794921875000000000000000000000000000000000e+01,		   // p_coeff_9h	 
5.63167951919359666135278530418872833251953125000000000000000000000000000000000000e+01,		   // p_coeff_10h	 
1.17466533739617389642262423876672983169555664062500000000000000000000000000000000e+02,		   // p_coeff_11h	 
2.48208400271530678082854137755930423736572265625000000000000000000000000000000000e+02,		   // p_coeff_12h	 
5.30187120971580611694662366062402725219726562500000000000000000000000000000000000e+02,		   // p_coeff_13h	 
1.14298685390676246242946945130825042724609375000000000000000000000000000000000000e+03,		   // p_coeff_14h	 
2.48365898527212812041398137807846069335937500000000000000000000000000000000000000e+03,		   // p_coeff_15h	 
5.43413912381613681645831093192100524902343750000000000000000000000000000000000000e+03,		   // p_coeff_16h	 
1.19616511180501001945231109857559204101562500000000000000000000000000000000000000e+04,		   // p_coeff_17h	 
2.64708277570606114750262349843978881835937500000000000000000000000000000000000000e+04,		   // p_coeff_18h	 
5.88376889385143513209186494350433349609375000000000000000000000000000000000000000e+04,		   // p_coeff_19h	 
1.31386216977166535798460245132446289062500000000000000000000000000000000000000000e+05,		   // p_coeff_20h	 
3.03303368112601048778742551803588867187500000000000000000000000000000000000000000e+05,		   // p_coeff_21h	 
6.82215743360355845652520656585693359375000000000000000000000000000000000000000000e+05,		   // p_coeff_22h	 
6.90477178468776764397318856936180964112281799316406250000000000000000000000000000e-01,		   // p_coeff_0h	 
3.39466231816613032388245073452427079551490712938188829689289960356290976051241159e-18,		   // p_coeff_0m	 
1.29711412734153253012436834978871047496795654296875000000000000000000000000000000e+00,		   // p_coeff_1h	 
-4.91536443957924304285159601199758593586250555616465329755726543226046487689018250e-17,	   // p_coeff_1m	 
6.94991224248453054457286270917393267154693603515625000000000000000000000000000000e-01,		   // p_coeff_2h	 
4.14055567174545404801311585696815622965502227300336503257316422832445823587477207e-18,		   // p_coeff_2m	 
1.10848340356455987709693999931914731860160827636718750000000000000000000000000000e+00,		   // p_coeff_3h	 
4.16266958244922006708243033738862584564114206709881105261672473716316744685173035e-17,		   // p_coeff_3m	 
1.87458354117322345544494055502582341432571411132812500000000000000000000000000000e+00,		   // p_coeff_4h	 
1.01371418047977543599188915056692109774560397669751488081146817421540617942810059e-16,		   // p_coeff_4m	 
3.65157801416010441286630339163821190595626831054687500000000000000000000000000000e+00,		   // p_coeff_5h	 
1.26536476346012852031977695308463633490816727090143289924384362166165374219417572e-16,		   // p_coeff_5m	 
7.55165652946598697781155351549386978149414062500000000000000000000000000000000000e+00,		   // p_coeff_6h	 
-2.14190464475496048348382959343551268818198527301224776131505223020212724804878235e-16,	   // p_coeff_6m	 
1.63735347750204702776954945875331759452819824218750000000000000000000000000000000e+01,		   // p_coeff_7h	 
1.51055732062479748503833695277300766424363764363347772956558401347137987613677979e-15,		   // p_coeff_7m	 
3.66799013891310394797073968220502138137817382812500000000000000000000000000000000e+01,		   // p_coeff_8h	 
-1.96467879903428952233615671924270070336884016354295212636316136922687292098999023e-15,	   // p_coeff_8m	 
8.42583880764557306974893435835838317871093750000000000000000000000000000000000000e+01,		   // p_coeff_9h	 
1.97380229224487067085647140629589557647705078125000000000000000000000000000000000e+02,		   // p_coeff_10h	 
4.69729422521515630251087713986635208129882812500000000000000000000000000000000000e+02,		   // p_coeff_11h	 
1.13246616901346669692429713904857635498046875000000000000000000000000000000000000e+03,		   // p_coeff_12h	 
2.76004978747814584494335576891899108886718750000000000000000000000000000000000000e+03,		   // p_coeff_13h	 
6.78908667818280082428827881813049316406250000000000000000000000000000000000000000e+03,		   // p_coeff_14h	 
1.68324374222143451333977282047271728515625000000000000000000000000000000000000000e+04,		   // p_coeff_15h	 
4.20216193300401428132317960262298583984375000000000000000000000000000000000000000e+04,		   // p_coeff_16h	 
1.05540980227414402179419994354248046875000000000000000000000000000000000000000000e+05,		   // p_coeff_17h	 
2.66494483142128563486039638519287109375000000000000000000000000000000000000000000e+05,		   // p_coeff_18h	 
6.76009364551451755687594413757324218750000000000000000000000000000000000000000000e+05,		   // p_coeff_19h	 
1.72216034198046685196459293365478515625000000000000000000000000000000000000000000e+06,		   // p_coeff_20h	 
4.49188704440361727029085159301757812500000000000000000000000000000000000000000000e+06,		   // p_coeff_21h	 
1.15993861480669919401407241821289062500000000000000000000000000000000000000000000e+07,		   // p_coeff_22h	 
7.53605330605588874526290510402759537100791931152343750000000000000000000000000000e-01,		   // p_coeff_0h	 
-6.86303578932659590324882262388685086010663787564085999357010869914574868744239211e-20,	   // p_coeff_0m	 
1.37131588394733516800272354885237291455268859863281250000000000000000000000000000e+00,		   // p_coeff_1h	 
5.85729819349925155946752593741546617096794483808830378279708384070545434951782227e-17,		   // p_coeff_1m	 
8.82290262843787198576706032326910644769668579101562500000000000000000000000000000e-01,		   // p_coeff_2h	 
5.16377114572074856584788281695076928068533622922381409736658497422467917203903198e-17,		   // p_coeff_2m	 
1.56510752146505316417801623174455016851425170898437500000000000000000000000000000e+00,		   // p_coeff_3h	 
-4.39163602371923391288987498767894166026634554891340533888666186612681485712528229e-17,	   // p_coeff_3m	 
3.07048550644979600932060748164076358079910278320312500000000000000000000000000000e+00,		   // p_coeff_4h	 
-1.10182145686314872930592860300828689006905830376995686359364867712429258972406387e-16,	   // p_coeff_4m	 
6.85588913581356962367863161489367485046386718750000000000000000000000000000000000e+00,		   // p_coeff_5h	 
4.35622325486244782178679451752414705321823684735019210911843856592895463109016418e-16,		   // p_coeff_5m	 
1.63125257206586802283254655776545405387878417968750000000000000000000000000000000e+01,		   // p_coeff_6h	 
-1.42810985056358952027816317128163090933704222357941704402151117392349988222122192e-16,	   // p_coeff_6m	 
4.06593902603693564401510229799896478652954101562500000000000000000000000000000000e+01,		   // p_coeff_7h	 
1.26451118649566617072575681437226509832616233499485991487176761438604444265365601e-15,		   // p_coeff_7m	 
1.04739604506448415577324340119957923889160156250000000000000000000000000000000000e+02,		   // p_coeff_8h	 
-4.21355762035756719251654947961735015460869348269401513107368373312056064605712891e-16,	   // p_coeff_8m	 
2.76663345345012544385099317878484725952148437500000000000000000000000000000000000e+02,		   // p_coeff_9h	 
7.45270800399650397594086825847625732421875000000000000000000000000000000000000000e+02,		   // p_coeff_10h	 
2.03955855522386173106497153639793395996093750000000000000000000000000000000000000e+03,		   // p_coeff_11h	 
5.65453975726426688197534531354904174804687500000000000000000000000000000000000000e+03,		   // p_coeff_12h	 
1.58480736247709683084394782781600952148437500000000000000000000000000000000000000e+04,		   // p_coeff_13h	 
4.48292577388124118442647159099578857421875000000000000000000000000000000000000000e+04,		   // p_coeff_14h	 
1.27817476628451069700531661510467529296875000000000000000000000000000000000000000e+05,		   // p_coeff_15h	 
3.66953462486772332340478897094726562500000000000000000000000000000000000000000000e+05,		   // p_coeff_16h	 
1.05988028936582896858453750610351562500000000000000000000000000000000000000000000e+06,		   // p_coeff_17h	 
3.07766344983369577676057815551757812500000000000000000000000000000000000000000000e+06,		   // p_coeff_18h	 
8.97598008321647346019744873046875000000000000000000000000000000000000000000000000e+06,		   // p_coeff_19h	 
2.63006417766936272382736206054687500000000000000000000000000000000000000000000000e+07,		   // p_coeff_20h	 
7.97293238009131550788879394531250000000000000000000000000000000000000000000000000e+07,		   // p_coeff_21h	 
2.35266135040413618087768554687500000000000000000000000000000000000000000000000000e+08,		   // p_coeff_22h	 
8.16207699480864135033186812506755813956260681152343750000000000000000000000000000e-01,		   // p_coeff_0h	 
1.10010191397663675140086054218782967355131241568134164879148861881930088202352636e-20,		   // p_coeff_0m	 
1.45987741598546749699494284868706017732620239257812500000000000000000000000000000e+00,		   // p_coeff_1h	 
1.03784174873658842691949705484313598874177727812186111666648002938018180429935455e-16,		   // p_coeff_1m	 
1.13339308477403566399743795045651495456695556640625000000000000000000000000000000e+00,		   // p_coeff_2h	 
6.19984751477578508212901866489819694255822369395765580879498202193644829094409943e-17,		   // p_coeff_2m	 
2.27840492593338828086757530400063842535018920898437500000000000000000000000000000e+00,		   // p_coeff_3h	 
1.29623917002581965214107410636027293901696556366158474826733026930014602839946747e-16,		   // p_coeff_3m	 
5.22734481752082214001120519242249429225921630859375000000000000000000000000000000e+00,		   // p_coeff_4h	 
-3.48196612292005370465186545711763157537164151090688934964134659821866080164909363e-16,	   // p_coeff_4m	 
1.35483951862735629845246876357123255729675292968750000000000000000000000000000000e+01,		   // p_coeff_5h	 
-4.53291289318611746967298644014774748053833951222640202827207644986629020422697067e-17,	   // p_coeff_5m	 
3.74970966548151878328098973724991083145141601562500000000000000000000000000000000e+01,		   // p_coeff_6h	 
3.16809448186690022670167104047109366061463187579094746837427010177634656429290771e-15,		   // p_coeff_6m	 
1.08680147858936038574029225856065750122070312500000000000000000000000000000000000e+02,		   // p_coeff_7h	 
-6.36137089188991992639408248982314785589906210028221522634339635260403156280517578e-15,	   // p_coeff_7m	 
3.25593310030335430838022148236632347106933593750000000000000000000000000000000000e+02,		   // p_coeff_8h	 
1.91287227671501587672951512619431386699611966073497626439348096027970314025878906e-14,		   // p_coeff_8m	 
1.00022684509519501716567901894450187683105468750000000000000000000000000000000000e+03,		   // p_coeff_9h	 
3.13368188220144656952470541000366210937500000000000000000000000000000000000000000e+03,		   // p_coeff_10h	 
9.97418849150001005909871309995651245117187500000000000000000000000000000000000000e+03,		   // p_coeff_11h	 
3.21620985996262825210578739643096923828125000000000000000000000000000000000000000e+04,		   // p_coeff_12h	 
1.04841470601619919762015342712402343750000000000000000000000000000000000000000000e+05,		   // p_coeff_13h	 
3.44929702756780723575502634048461914062500000000000000000000000000000000000000000e+05,		   // p_coeff_14h	 
1.14386293806761899031698703765869140625000000000000000000000000000000000000000000e+06,		   // p_coeff_15h	 
3.81954181095832167193293571472167968750000000000000000000000000000000000000000000e+06,		   // p_coeff_16h	 
1.28314429144318234175443649291992187500000000000000000000000000000000000000000000e+07,		   // p_coeff_17h	 
4.33370274414261654019355773925781250000000000000000000000000000000000000000000000e+07,		   // p_coeff_18h	 
1.46996088810462892055511474609375000000000000000000000000000000000000000000000000e+08,		   // p_coeff_19h	 
5.00961200009291708469390869140625000000000000000000000000000000000000000000000000e+08,		   // p_coeff_20h	 
1.77139381348167872428894042968750000000000000000000000000000000000000000000000000e+09,		   // p_coeff_21h	 
6.08314919055301284790039062500000000000000000000000000000000000000000000000000000e+09		   // p_coeff_22h	 
};
