%%NAME
%%  etitle - print title of plot
%%
%%SYNOPSIS
%%  etitle ([text[,distance[,fontSize]]])
%%
%%PARAMETER(S)
%%  text     title text
%%  distance distance from plot area
%%  fontSize fontsize of text
%%
%%GLOBAL PARAMETER(S)
%%  ePlotTitleText
%%  ePlotTitleDistance
%%  ePlotTitleFontSize
%%  ePlotTitleTextFont
%%  ePlotAreaPos
%%  ePlotAreaWidth
%%  ePlotAreaHeight
% written by Stefan Mueller stefan.mueller@fgan.de 2002

function etitle(text,distance,fontSize)
  if  nargin >3
    usage('etitle([text[,distance[,fontSize]]])');
  end
  eglobpar;
  if nargin>0
    ePlotTitleText=text;
  end
  if nargin>1
    ePlotTitleDistance=distance;
  end
  if nargin>2
    ePlotTitleFontSize=fontSize;
  end
  if strcmp(ePlotTitleText,'')~=1
    etext(ePlotTitleText,ePlotAreaPos(1)+ePlotAreaWidth/2,...
       ePlotAreaPos(2)+ePlotAreaHeight+ePlotTitleDistance,...
       ePlotTitleFontSize,0,ePlotTitleTextFont,0);
  end
