%%NAME
%%  epolari  - draw polar image of a matrix 
%%
%%SYNOPSIS
%%  epolari(image[,colorMap])
%%
%%PARAMETER(S)
%%  matrix     matrix for image 
%%             each value of the matrix is a row index of the colormap
%%  colorMap   define own colormap  
%% 
%%GLOBAL PARAMETER(S)
%%  eImageDefaultColorMap
%%  ePolarPlotAreaCenterPos
%%  ePolarPlotAreaRadMax
%%  ePolarPlotAreaAngEnd
%%  ePolarPlotAreaAngStart
%%  ePolarPlotAreaRadMin
%%  ePolarPlotAreaRadMax
% written by Stefan Mueller stefan.mueller@fgan.de 1997

function epolari(image,colorMap)
  if nargin>5
    usage ('epolari(image[,colorMap])');
  end
  eglobpar;
  if nargin<2
    colorMap=ecolors(eImageDefaultColorMap);
  end
  if nargin<1
    [image colorMap]=eppmread([ePath 'default.ppm']);
    ePlotTitleText='Photo';     
  end

  % write title
  eptitle;

  nSteps=size(image,2);
  dPhi=(ePolarPlotAreaAngEnd-ePolarPlotAreaAngStart)/nSteps;
  radiusMin=ePolarPlotAreaRadMin*eFac;
  radiusMax=ePolarPlotAreaRadMax*eFac;
  dRadius=radiusMax-radiusMin;
  sectorH=dPhi/180*pi*radiusMax;
  fprintf(eFile,'gsave %1.2f %1.2f translate\n',...
           ePolarPlotAreaCenterPos(1)*eFac,...
           ePolarPlotAreaCenterPos(2)*eFac);
  fprintf(eFile,'%1.2f rotate\n',ePolarPlotAreaAngStart+dPhi/2);
  for i=1:nSteps
    fprintf(eFile,'%1.2f rotate\n',dPhi*(i-1));
    eclippol(eFile,0,0,radiusMin,radiusMax,-dPhi/2,dPhi/2);
    eimagexy(eFile,image(:,i)',colorMap,...
             radiusMin,-sectorH/2,dRadius,sectorH);
    eclippol(eFile);
    fprintf(eFile,'%1.2f rotate\n',-dPhi*(i-1));
  end
  fprintf(eFile,'grestore\n');
