%%NAME
%%  epline  - draw polyline 
%%
%%SYNOPSIS
%%  epline(xData,yData[,lineWidth[,dash[,color]]])
%%
%%PARAMETER(S)
%%  xData       vector of x-values of polyline
%%  yData       vector of y-values of polyline
%%  lineWidth   width of polyline 
%%  dash        if dash=0 then draw solid lines
%%              if dash<0 then fill polyline
%%              else value of dash is the distance of dashes 
%%  color       vector of polyline color ([r g b])
%% 
%%GLOBAL PARAMETER(S)
%%  eLineColor
%%  eLineDash
%%  eLineWidth
% written by Stefan Mueller stefan.mueller@fgan.de 2000

function epline (xData,yData,lineWidth,dash,color)
  if nargin<2 | nargin>5
    usage ('epline (xData,yData,[,lineWidth[,dash[,color]]])');
  end
  eglobpar;
  if nargin==5
    eLineColor=color;
  end
  if nargin>3
    eLineDash=dash;
  end
  if nargin>2
    eLineWidth=lineWidth;
  end
  xData=xData*eFac;
  yData=yData*eFac;
  if dash<0
    exyplotf(eFile,0,0,xData,yData,eLineColor);
  else
    exyplot( eFile,0,0,xData,yData,eLineColor,eLineDash*eFac,...
           eLineWidth*eFac);
  end
