%%NAME
%%  elines  - draw lines 
%%
%%SYNOPSIS
%%  elines(xData,yData[,lineWidth[,dash[,color]]])
%%
%%PARAMETER(S)
%%  xData       matrix(2xn) of x0,x1-data of lines
%%  yData       matrix(2xn) of y0,y1-data of lines
%%  lineWidth   width of polyline 
%%  dash        if dash=0 then draw solid lines
%%              else value of dash is the distance of dashes 
%%  color       vector of polyline color ([r g b])
%% 
%%GLOBAL PARAMETER(S)
%%  eLineColor
%%  eLineDash
%%  eLineWidth
% written by Stefan Mueller stefan.mueller@fgan.de 1999

function elines (xData,yData,lineWidth,dash,color)
  if nargin<2 | nargin>5
    usage ('elines (xData,yData,[,lineWidth[,dash[,color]]])');
  end
  eglobpar;
  if nargin==5
    eLineColor=color;
  end
  if nargin>3
    eLineDash=dash;
  end
  if nargin>2
    eLineWidth=lineWidth;
  end
  [xr xc]=size(xData);
  if xr>2
    xData=xData';
    xc=xr;
  end
  xData=reshape(xData,1,2*xc);
  [yr yc]=size(yData);
  if yr>2
    yData=yData';
    yc=yr;
  end
  yData=reshape(yData,1,2*yc);
    exyline(eFile,0,0,xData*eFac,yData*eFac,...
            eLineColor,eLineDash*eFac,eLineWidth*eFac);
