eopen('demo9.eps')                      % open eps-file and write eps-head
eglobpar;

%make title image 
[titleImg titleCM]=eppmread([ePath 'default.ppm']); % read image
swCM=titleCM(:,1)+titleCM(:,2)+titleCM(:,3);
swCM=swCM/max(swCM);
titleCM=[swCM swCM swCM]; 
eppmwrit('title.ppm',titleImg,titleCM); % save image

%make background image
[backImg backCM]=eshadoi; % get default shadow image
backCM(:,2:3)=0; % red colormap
eppmwrit('backgr.ppm',backImg,backCM); % save image

%make logo image
[logoImg logoCM]=eshadois; % get default shadow image
eppmwrit('logo.ppm',logoImg,logoCM); % save image

%content
lf=setstr(10); %linefeed
contenttext=[
  'New features:' lf ...
  '#import and export of images###'  lf ...
  '#quiverplots###' lf ...
  '#new symbols###' lf ...
  '#new demos###' lf  ...
  '#mix shadow plots###' lf ...
  '#import of matlab eps-files###' lf ...
  '#bugs removed in eisoline, esubeps, ebitmap...###' lf ...
  ];
fid=fopen('content.txt','w');
fprintf(fid,'%s',contenttext);
fclose(fid);

% make cover

ecdcover('The EpsTk',...
         'Graphic for Octave & MATLAB(R)',...
         'St.Mueller',...
         'Version 1.9',...
         '2001',...
         [1 1 0],...
         'title.ppm','backgr.ppm',...
         'logo.ppm','content.txt');
         

eclose
eview
