% standard plot
eopen('demo2.eps')                      % open eps-file and write eps-head
eglobpar                                % get access to global parameters
ePlotTitleText='Standard Plot';         % set title
eXAxisSouthLabelText='Sector [No]';     % set South Label of XAxis
eXAxisSouthScaleType=1;                 % set classes scaling
eYAxisWestLabelText='Range [km]';       % set West Label of YAxis
eYAxisEastLabelText='Outlook';          % set East Label of YAxis
eXAxisNorthVisible=0;                   % switch North-XAxis off
eYAxisEastValueVisible=0;               % switch East-YAxis Values off
eXGridVisible=1;                        % switch x-Grid on
eYGridVisible=1;                        % switch y-Grid on
etext('demo only',eWinWidth/2,eWinHeight/2,40,0,1,...   %print text
     atan(eWinHeight/eWinWidth)*180/pi,[0.8 0.8 0.8])
eXAxisSouthScale=[1999 1 2005];
eaxes([0 0 6],[0 10 50])               % scale axes

% 1. plot lines
x=0:0.1:2*pi;
eplot(x,sin(x)*15+30,'street',0,[0.8 0.8 0],3) %solid line 
eplot(x,sin(x)*15+33,'power line',5,[1 0 1]) % dash plot
eplot(x,sin(x)*15+36,'railway',0,[0.3 0.3 0.4],1) % solid line

% 2. plot symbols 
x=0:0.5:2*pi;
edsymbol('spire','spire.psd',0.3,0.3,0,0,90) % define symbol with name 'spire'
eplot(x,cos(x)*10+20,'tree','spire',[0 0.7 0])

% 3. plot area
lake=[1 30;1.3 35;1.5 32;2 40;2.5 25;1.6 15;1.4 17;1.2 24;1 30];
eplot(lake(:,1),lake(:,2),'water',-1,[0.5 0.5 1]); % filled area,dash<0
eplot(lake(:,1),lake(:,2),'water limit',0,[0 0 0]); % solid line around the area

% 4. plot bars 
x=0.5:1:5.5;
[xb yb]=ebar(sin(x)*8+9,0,1,3);     % 1. bars
eplot(xb,yb,'forest',-1,[0.5 0.7 0])
eplot(xb,yb,'',0,[0 0 0]) 
[xb yb]=ebar(cos(x)*8+5,0,2,3);     % 2. bars
eplot(xb,yb,'town',-1,[0.8 0 0])
eplot(xb,yb,'',0,[0 0 0])
[xb yb]=ebar(cos(x)*8+9,0,3,3);     % 3. bars
eplot(xb,yb,'sea',-1,[0 0 1])
eplot(xb,yb,'',0,[0 0 0])
eplot

% write parameters
eParamPos=[80,70];
eParamFontSize=5;
eparam('Altitude','232 m')
eparam('Power','100 W')

% axis
eaxis(50,110,100,'s',[0 0 10],40,[1 0 0]);

eclose                                  % close ps output
eview                                   % start ghostview with eps-file
