%%NAME
%%  eclose - finish plot(s) and close EPS-file 
%%
%%SYNOPSIS
%%  eclose ([endOfPage[,message]])
%%
%%PARAMETER(S)
%%  endOfPage   switch for the postscript command 'showpage'
%%              if endOfPage=1 then append 'showpage' (default)
%%              else 'showpage' will not append
%%  message     switch for file written message 
%%              if message=1 then write message (default)
%%              else message
%%
%%GLOBAL PARAMETER(S)
%%  eWinFrameVisible
%%  eWinTimeStampVisible
% written by Stefan Mueller stefan.mueller@fgan.de 1997

function eclose(endOfPage,message)
  eglobpar;
  if nargin>2
    usage('eclose([endOfPage[,message]])');
  end
  if nargin<2
    message=1;
  end
  if nargin<1
    endOfPage=1;
  end
  if ePlotLineNr>0
    eplot
    ePlotLineNr=0;
  end
  if ePolarPlotLineNr>0
    epolar
    ePolarPlotLineNr=0;
  end
  if eWinTimeStampVisible
    timeStamp=clock;
    timeStampText=sprintf('epsTk %d.%d.%d %d:%d:%d File:%s',...
                          timeStamp(3),timeStamp(2),timeStamp(1),...
                          timeStamp(4),timeStamp(5),timeStamp(6),...
                          eFileName);
    etext(timeStampText,-1,0,eWinTimeStampFontSize,1,...
         eWinTimeStampFont,90);
  end
  if eWinFrameVisible
    erect(eFile,0,0,eWinWidth*eFac,eWinHeight*eFac,...
          eWinFrameLineWidth,[0 0 0],0);
  end
  if eWinGridVisible
    esavpar;
    ePlotAreaPos=[0 0];
    ePlotAreaHeight=eWinHeight;
    ePlotAreaWidth=eWinWidth;
    eXGridVisible=1;
    eYGridVisible=1;
    eXGridColor=[0.6 0.6 0.6];
    eYGridColor=[0.6 0.6 0.6];
    eaxes([0 10 eWinWidth],[0 10 eWinHeight]);
    egrid;
    erespar;
  end                    
  if endOfPage==1
    fprintf(eFile,'showpage\n');
  end
  fclose(eFile);
  if message==1
    message=sprintf('%s is written',eFileName);
    disp(message);
  end
  if exist('close')
    close
  end
