/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

//
// Kernel module for NW8xx based USB webcams.
//
// - WebSite            : nw802.sourceforge.net
// - Mailing list       : nw802-main@lists.sourceforge.net
// - Project Developers : Sylvain Munaut <nw8xx ]at[ 246tNt.com>
//                        Kjell Claesson <keyson ]at[ users.sourceforge.net>
//
// [ sources bestviewed with tabstop=4 ]
//


//
// nw8xx_jpgl.h
//
// JPEG Lite decoding algorithm
//
// Author & Copyright (c) 2003 : Sylvain Munaut <nw8xx ]at[ 246tNt.com>
//

#ifndef __NW8XX_JPGL_H__
#define __NW8XX_JPGL_H__

#ifdef _JPGL_TEST_
#include "ringqueue.h"
#else
#include "usbvideo.h"
#endif

// Decode a frame. The input stream MUST BE aligned ( refer to 
// jpgl_findHeader ). A complete frame MUST BE available !
// Return 0 if the frame is valid.
// Another code is an error code
int jpgl_processFrame( struct RingQueue *rq, unsigned char *fb );


// Find a valid header and return the offset to skip to correctly align
// the stream for frame decoding.
// The ofs parameter allows you to start searching from some offset. 
// Returns -1 if nothing found.
int jpgl_findHeader( struct RingQueue *rq, int w, int h, int ofs );


// Init the decoder. Should only be called once
void jpgl_initDecoder();


#endif //  __NW8XX_JPGL_H__
