/* NVTV nv_type -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * Extends the NVRec type and introduces new types, and should
 * eventually be merged with the original XFree file.  
 * 
 */

#ifndef _NV_TYPE_H
#define _NV_TYPE_H

#include "xfree.h"
#include "xf86i2c.h"
#include "debug.h"

#include "nv_tvchip.h"

typedef void (*CalcOverscanFunc) (double hoc, double voc, double aspect);

typedef struct _I2CChainRec *I2CChainPtr;
typedef struct _I2CChainRec {
  char          *name;
  I2CDevPtr	dev;
  I2CChainPtr	next;
  NVTvChip      chip;
} I2CChainRec;

typedef struct _TvFuncRec *TvFuncPtr;

/* Number of TV Busses */
#define NV_NBUS 3

/* I2C Id of device for use in (s)printf */
#define I2C_ID(dev) dev->pI2CBus->BusName+2,dev->SlaveAddr

typedef struct {
    RIVA_HW_INST        riva;
    /* ... */
    CARD32              IOAddress;
    /* ... */
    int                 Chipset;
    /* ... */
 /* new members */
    TvFuncPtr		TvFunc;
    I2CChainPtr         TvChain; /* chain of devices on all busses */
    I2CBusPtr           TvBusses[NV_NBUS];
    I2CDevPtr           TvDev;
} NVRec, *NVPtr;

typedef struct _TvFuncRec {
  void (*InitRegs) (I2CDevPtr dev);
  void (*SetRegs) (I2CDevPtr dev, NVTvRegs *r);
  void (*SetState) (I2CDevPtr dev, NVTvState state);
  NVConnect (*GetConnect) (I2CDevPtr dev);
  long (*GetStatus) (I2CDevPtr dev, int index);
} TvFuncRec;

#define NVPTR(p) ((NVPtr)((p)->driverPrivate))

#endif /* _NV_TYPE_H */
