/* NVTV actions -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This is open software protected by the GPL. See GPL.txt for details.
 *
 * Header: Intermediate layer. Contains tv actions, X actions and card
 *   access.
 */

#ifndef _ACTIONS_H
#define _ACTIONS_H

#include <X11/Xlib.h>

#include "nv_tvchip.h"
#include "nv_type.h"
#include "main.h"

void tv_on (NVPtr pNv);
void tv_off (NVPtr pNv, Bool have_crt);
void tv_bars (NVPtr pNv);
void tv_set (NVPtr pNv);
void tv_exit (NVPtr pNv);

int tv_connect (NVPtr pNv);
char *tv_version (NVPtr pNv);
int tv_status (NVPtr pNv);

void print_crt_regs (NVCrtRegs *m);
void print_tv_regs (NVTvRegs *r, NVTvChip chip);

void probe_system (CardPtr card_list);

Bool has_vidmode (Display *display);
void switch_vidmode (Display *display, int screen, int res_x, int res_y);

Bool get_vidmode (Display *display, int screen, NVCrtRegs *crt);
Bool find_vidmode (Display *display, int screen, int res_x, int res_y, 
  NVCrtRegs *crt);

void center_window (Display *display, int screen, Window window,
  int res_x, int res_y);

Window Select_Window (Display *dpy, int screen);
Window Window_With_Name (Display *dpy, Window top, char *name);

#endif
