/* Written to work with Advice Partner/King PR750.
   See http://www.advice.co.il/product/inter/ups.html for its specifications.
   This model is based on PowerCom (www.powercom.com) models.
   Read docs/powercom.txt for other models and manufactures for which
   I believe this model program might work. 
    
   Copyright (C) 2000  Shaul Karl <shaulk@israsrv.net.il>

   Heavily based on 
    ups-trust425+625.c - model specific routines for Trust UPS 425/625
    Copyright (C) 1999  Peter Bieringer <pb@bieringer.de> 

   A technical description of the interface to the UPS that this program
   implements is found in docs/\*trust* files. 
    
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/


#include <sys/file.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/termios.h>
#include "time.h"
#include <limits.h>

#define INFO_MAX 12

#include "config.h"
#include "proto.h"
#include "shared.h"
#include "version.h"
#include "upscommon.h"
#include "common.h"

enum general {SHMOK = 1U, SEC_FOR_POWERKILL = 10U, 
	      NUM_OF_BYTES_FROM_UPS = 11U, MAINS_VOLTAGE = 230U};
enum commands {SEND_DATA = 0x01U, BATTERY_TEST = 0x03U, SHUTDOWN = 0xbcU};
enum data {LOAD_LEVEL = 0U, BAT_LEVEL = 1U, IN_AC_VOLT = 2U, OUT_AC_VOLT = 3U,
	   IN_AC_FREQ = 4U};
enum status {STATUS_A = 9U,
		SUMMARY = 0U, MAINS_FAILURE = 1U, LOW_BAT = 2U, 
		AVR_ON = 8U, OVERLOAD = 32U, OFF = 128U,
	     STATUS_B = 10U,
		BAD_BAT = 2U, TEST = 4U};

/* The following vars must be global because other parts of the NUT package
 * use them as well. */

	/* 9 entries in the info array for: 
	 * ACFREQ, BATTPCT, LOADPCT, MFR, MODEL, 
	 * 	SERIAL, STATUS, UPSIDENT, UTILITY.
	 * One for BTEST1,
	 * Other 2 are for MEMBERS and MSGID. */
