/* upsstats - cgi program to generate the main ups info page

   Copyright (C) 1998  Russell Kroll <rkroll@exploits.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/* default host - only used if you don't specify one in the URL */
#define MONHOST "127.0.0.1"

#include "common.h"
#include "upsfetch.h"
#include "status.h"
#include "cgilib.h"
#include "timehead.h"

#include <sys/time.h>

static	char	monhost[SMALLBUF];
static	int	use_celsius = 1, refreshdelay = -1;

void parsearg(char *var, char *value)
{
	if (!strcmp(var, "host"))
		strlcpy(monhost, value, sizeof(monhost));

	if (!strcmp(var, "use_celsius"))
		use_celsius = (int) strtol(value, (char **) NULL, 10);
	
	if (!strcmp(var, "refresh"))
		refreshdelay = (int) strtol(value, (char **) NULL, 10);
}

const char *my_getdate()
{
	time_t	tod;
	static char timestr[255];

	time (&tod);
	if (strftime (timestr, sizeof(timestr), "%a %b %d %X %Z %Y", localtime(&tod)) == 0)
		fatal("strftime");

	return (timestr);
}

void nocomm()
{
	printf ("Error: %s\n", upsstrerror(upserror));
	exit (1);
}

int main() 
{
	double	tempf;
	char	model[64], status[64], battpct[64], utility[64], loadpct[64],
	        upstemp[64], acfreq[64], *stat, *ptr;
	int	i;

	strcpy (monhost, MONHOST);	/* default host */

	extractcgiargs();

	printf ("Content-type: text/html\n"); 
	printf ("Pragma: no-cache\n");
	printf ("\n");

	if (!checkhost (monhost, NULL)) {
		printf ("Access to that host is not authorized.\n");
		exit (0);
	}

	if (getupsvar(monhost, "model", model, sizeof(model)) < 0)
		snprintf (model, sizeof(model), "Unknown - %s", upsstrerror(upserror));
	
	printf ("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\"\n");
	printf ("	\"http://www.w3.org/TR/REC-html40/loose.dtd\">\n");

	printf ("<HTML><HEAD>\n");
	if (refreshdelay > 0)
		printf ("<META HTTP-EQUIV=\"Refresh\" CONTENT=\"%d\">\n", refreshdelay);
	
	printf ("<TITLE>%s on %s</TITLE></HEAD>\n", model, monhost);
	printf ("<BODY BGCOLOR=\"#C8C8C8\" TEXT=\"#000000\" LINK=\"#0000EE\" VLINK=\"#551A8B\">\n");
	printf ("<CENTER><TABLE BORDER CELLSPACING=10 CELLPADDING=5>\n");
	printf ("<TR><TH>%s</TH>\n", my_getdate());
	printf ("<TH>Batt Chg</TH><TH>Utility</TH><TH>UPS Load</TH></TR>\n");
	printf ("<TR><TD BGCOLOR=\"#FFFFFF\"><PRE>\n");
	printf ("Monitoring: %s\n", monhost);
	printf (" UPS Model: %s\n", model);

	getupsvar (monhost, "status", status, sizeof(status));
	printf ("    Status: ");

	stat = status;
	while (stat != NULL) {
		ptr = strchr (stat, ' ');
		if (ptr)
			*ptr++ = '\0';	

		for (i = 0; stattab[i].name != NULL; i++) { 
			if (!strcmp(stattab[i].name, stat))
				printf ("%s ", stattab[i].desc);
		}

		stat = ptr;
	} 
	printf ("\n"); 

	printf ("</PRE></TD>\n");

	if (getupsvar (monhost, "battpct", battpct, sizeof(battpct)) > 0)
		printf ("<TD ROWSPAN=3><IMG SRC=\"upsimage.cgi?host=%s&amp;display=battpct\" WIDTH=130 HEIGHT=350 ALT=\"Battery charge: %s %%\">\n", monhost, battpct);
	else
		printf ("<TD ROWSPAN=3 VALIGN=TOP>Not supported\n");
	printf ("</TD>\n");

	if (getupsvar (monhost, "utility", utility, sizeof(utility)) > 0)
		printf ("<TD ROWSPAN=3><IMG SRC=\"upsimage.cgi?host=%s&amp;display=utility\" WIDTH=130 HEIGHT=350 ALT=\"Utility: %s VAC\">\n", monhost, utility);
	else {
		printf ("<TD ROWSPAN=3 VALIGN=TOP>Not supported\n");
		strcpy (utility, "");
	}
	printf ("</TD>\n");

	if (getupsvar (monhost, "loadpct", loadpct, sizeof(loadpct)) > 0)
		printf ("<TD ROWSPAN=3><IMG SRC=\"upsimage.cgi?host=%s&amp;display=loadpct\" WIDTH=130 HEIGHT=350 ALT=\"UPS Load: %s %%\">\n", monhost, loadpct);
	else
		printf ("<TD ROWSPAN=3 VALIGN=TOP>Not supported\n");
	printf ("</TD>\n");

	printf ("</TR>\n");

	printf ("<TR><TD BGCOLOR=\"#FFFFFF\"><PRE>\n");

	/* TODO: handle self tests */
	printf ("&nbsp;");
/*	printf ("Last UPS Self Test: Not Available\n"); */
/*	printf ("    Last Test Date: Not Available\n"); */
	printf ("</PRE></TD></TR>\n");

	printf ("<TR><TD BGCOLOR=\"#FFFFFF\"><PRE>\n");

	if (strlen(utility) != 0)
		printf ("   UPS Input: %s VAC\n", utility);

	if (getupsvar (monhost, "upstemp", upstemp, sizeof(upstemp)) > 0) {
		if (use_celsius)
			printf ("    UPS Temp: %s &deg;C\n", upstemp);
		else {
			tempf = (strtod (upstemp, 0) * 1.8) + 32;
			printf ("    UPS Temp: %.1f &deg;F\n", tempf); 
		}
	}

	if (getupsvar (monhost, "acfreq", acfreq, sizeof(acfreq)) > 0)
		printf (" Output Freq: %s Hz\n", acfreq);

	printf ("</PRE><P>\n");
	printf ("<CENTER>Network UPS Tools upsstats %s</CENTER>\n", UPS_VERSION);

	printf ("</TD></TR>\n");
	printf ("</TABLE></CENTER>\n");

	return 0;
}
