/* upsimage - cgi program to create graphical ups information reports

   Copyright (C) 1998  Russell Kroll <rkroll@exploits.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "common.h"
#include "upsfetch.h"
#include "cgilib.h"

#ifdef HAVE_GD_GD_H
#include <gd/gd.h>
#include <gd/gdfontl.h>
#elif HAVE_GD_H
#include <gd.h>
#include <gdfontl.h>
#else
#error "You need gd to build this!  http://www.boutell.com/gd/"
#endif

	char	monhost[128];
	char	cmd[16];

void parsearg(char *var, char *value) 
{
	if (!strcmp(var, "host"))
		strlcpy(monhost, value, sizeof(monhost));

	if (!strcmp(var, "display"))
		strlcpy(cmd, value, sizeof(cmd));
}

/* write the HTML header then have gd dump the image */
void drawimage(gdImagePtr im)
{
	printf("Pragma: no-cache\n");
	printf("Content-type: image/png\n\n");

	gdImagePng(im, stdout);
	gdImageDestroy(im);
	exit(0);
}

void drawbattcap(char *battcaps) 
{
	gdImagePtr	im;
	int		green, black, white, grey, darkgrey;
	char		batttxt[16];
	int		battpos;
	double		battcap;

	battcap = strtod(battcaps, NULL);

	im = gdImageCreate(130, 350);		/* X=130, Y=350 */

	black = gdImageColorAllocate(im, 0, 0, 0);
	green = gdImageColorAllocate(im, 0, 255, 0);
	white = gdImageColorAllocate(im, 255, 255, 255);
	grey = gdImageColorAllocate(im, 200, 200, 200);
	darkgrey = gdImageColorAllocate(im, 50, 50, 50);

	/* start out with a grey backing color */
	gdImageColorTransparent(im, grey);
	gdImageFilledRectangle(im, 0, 0, 130, 350, grey);

	/* put in the percentage values on the left side */
	gdImageString(im, gdFontLarge, 0, 0, "100", black);
	gdImageString(im, gdFontLarge, 0, 55, "80", black);
	gdImageString(im, gdFontLarge, 0, 115, "60", black);
	gdImageString(im, gdFontLarge, 0, 175, "40", black);
	gdImageString(im, gdFontLarge, 0, 235, "20", black);
	gdImageString(im, gdFontLarge, 0, 295, "0", black);

	/* the actual bar is backed with green */
	gdImageFilledRectangle(im, 30, 0, 130, 300, green);

	/* draw lines to correspond with the above percentage values */
	gdImageLine(im, 30, 60, 130, 60, darkgrey);
	gdImageLine(im, 30, 120, 130, 120, darkgrey);
	gdImageLine(im, 30, 180, 130, 180, darkgrey);
	gdImageLine(im, 30, 240, 130, 240, darkgrey);

	/* rescale battcap to get a Y coordinate for the top of the bar */
	battpos = (300 - (battcap * 3));

	/* sanity checks: */

	/* 1: if battcap is above 100%, then battpos goes negative */
	if (battpos < 0)
		battpos = 0;

	/* 2: if battcap is somehow below 0%, battpos goes off the scale */
	if (battpos > 300)
		battpos = 300;

	/* draw it */
	gdImageFilledRectangle(im, 55, battpos, 105, 300, black);

	/* stick the text version of the value at the bottom */
	snprintf(batttxt, sizeof(batttxt), "%.1f %%", battcap);
	gdImageString(im, gdFontLarge, 55, 320, batttxt, black);

	drawimage(im);
}

void noimage(void)
{
	gdImagePtr	im;
	int		black, grey;

	im = gdImageCreate(130, 350);
	grey = gdImageColorAllocate(im, 200, 200, 200);
	black = gdImageColorAllocate(im, 0, 0, 0);

	gdImageColorTransparent(im, grey);
	gdImageFilledRectangle(im, 0, 0, 130, 300, grey);

	gdImageString(im, gdFontLarge, 0, 0, "Not available", black);

	drawimage(im);
}

void drawupsload(char *upsloads) 
{
	gdImagePtr	im;
	int		green, black, white, grey, darkgrey, red;
	char		loadtxt[16];
	int		loadpos;
	double		upsload;

	upsload = strtod(upsloads, NULL);

	im = gdImageCreate(130, 350);

	black = gdImageColorAllocate(im, 0, 0, 0);
	green = gdImageColorAllocate(im, 0, 255, 0);
	white = gdImageColorAllocate(im, 255, 255, 255);
	grey = gdImageColorAllocate(im, 200, 200, 200);
	darkgrey = gdImageColorAllocate(im, 50, 50, 50);
	red = gdImageColorAllocate(im, 255, 0, 0);

	/* standard grey background */
	gdImageColorTransparent(im, grey);
	gdImageFilledRectangle(im, 0, 0, 130, 350, grey);

	/* numerical percentage markers */
	gdImageString(im, gdFontLarge, 0, 0, "125", black);
	gdImageString(im, gdFontLarge, 0, 55, "100", black);
	gdImageString(im, gdFontLarge, 0, 115, "75", black);
	gdImageString(im, gdFontLarge, 0, 175, "50", black);
	gdImageString(im, gdFontLarge, 0, 235, "25", black);
	gdImageString(im, gdFontLarge, 0, 295, "0", black);

	/* top = red (overload), remaining part is green (ok) */
	gdImageFilledRectangle(im, 30, 0, 130, 60, red);
	gdImageFilledRectangle(im, 30, 60, 130, 300, green); 

	/* percentage marker lines */
	gdImageLine(im, 30,  60, 130,  60, darkgrey);
	gdImageLine(im, 30, 120, 130, 120, darkgrey);
	gdImageLine(im, 30, 180, 130, 180, darkgrey);
	gdImageLine(im, 30, 240, 130, 240, darkgrey);

	/* rescale upsload to get a Y coordinate */
	loadpos = (300 - ((upsload / 125) * 300));

	/* sanity tests */

	/* 1: upsload above 125 == negative loadpos */
	if (loadpos < 0)
		loadpos = 0;

	/* 2: upsload below 0 == loadpos off the scale */
	if (loadpos > 300)
		loadpos = 300;

	/* draw it */
	gdImageFilledRectangle(im, 55, loadpos, 105, 300, black);

	/* label it */
	snprintf(loadtxt, sizeof(loadtxt), "%.1f %%", upsload);
	gdImageString(im, gdFontLarge, 55, 320, loadtxt, black);

	drawimage(im);
}

void drawutility(char *utilstr, int ht, int lt) 
{
	int	bh = 300;	/* bitmap height is fixed for now */

	int	green, black, white, grey, darkgrey, red;
	char	tempnum[16], utiltxt[16];
	int	lv, hv, sp, vr, htp, ltp, utp, i;
	double	ut;
	gdImagePtr	im;

	ut = strtod(utilstr, NULL);

	/* hack: deal with hardware that doesn't have known transfer points */
	if ((lt == 0) || (ht == 0)) {
		if (ut < 200.0) {
			lt = 90;
			ht = 140;
		}
		else {
			lt = 200;
			ht = 250;
		}
	}

	/* round transfer points to get high and low numbers for graph */
	lv = ((lt - 1) / 10) * 10;
	hv = ((ht + 10) / 10) * 10;

	/* chop it up into 6 even blocks */
	sp = (hv - lv) / 5;

	/* voltage range */
	vr = hv - lv;

	im = gdImageCreate(130, 350);

	black = gdImageColorAllocate(im, 0, 0, 0);
	green = gdImageColorAllocate(im, 0, 255, 0);
	white = gdImageColorAllocate(im, 255, 255, 255);
	grey = gdImageColorAllocate(im, 200, 200, 200);
	darkgrey = gdImageColorAllocate(im, 50, 50, 50);
	red = gdImageColorAllocate(im, 255, 0, 0);

	/* grey background */
	gdImageColorTransparent(im, grey);
	gdImageFilledRectangle(im, 0, 0, 130, 350, grey);

	/* put in the voltage points */

	/* first one is a special case since it'll poke off the top otherwise */
	snprintf(tempnum, sizeof(tempnum), "%d", hv);
	gdImageString(im, gdFontLarge, 0, 0, tempnum, black);

	for (i = 1; i < 6; i ++) {
		snprintf(tempnum, sizeof(tempnum), "%d", hv - (sp * i));
		gdImageString(im, gdFontLarge, 0, (i * 60) - 5, tempnum, black);
	}		

	/* red from the top to the high transfer point */

	htp = ((double)(hv - ht) / vr) * bh;
	gdImageFilledRectangle(im, 30, 0, 130, htp, red);

	/* green from the high transfer point to the low transfer point */

	ltp = ((double)(hv - lt) / vr) * bh;
	gdImageFilledRectangle(im, 30, htp, 130, ltp, green);

	/* red from low transfer point to bottom */
	gdImageFilledRectangle(im, 30, ltp, 130, bh, red);

	/* throw in the dividing lines */
	for (i = 60; i < 300; i += 60)
		gdImageLine(im, 30, i, 130, i, darkgrey);

	/* draw the utility box */
	utp = ((double)(hv - ut) / vr) * bh;

	/* deal with insanity from very large voltage values */
	if (utp < 0)
		utp = 0;

	/* and handle insanity from very low values as well */
	if (utp > bh)
		utp = bh;

	gdImageFilledRectangle(im, 55, utp, 105, bh, black);

	/* label it */
	snprintf(utiltxt, sizeof(utiltxt), "%.1f VAC", ut);
	gdImageString(im, gdFontLarge, 55, 320, utiltxt, black); 

	drawimage(im);
}

int main(int argc, char **argv)
{
	char	val[256], highxfer[256], lowxfer[256];

	extractcgiargs();

	if (!checkhost(monhost, NULL))
		noimage();		/* access denied */

	if (!strcmp(cmd, "loadpct")) {
		if (getupsvar(monhost, "loadpct", val, sizeof(val)) < 0)
			noimage();

		drawupsload(val);
	}

	if (!strcmp(cmd, "battpct")) {
		if (getupsvar(monhost, "battpct", val, sizeof(val)) < 0)
			noimage();

		drawbattcap(val);
	}

	if (!strcmp(cmd, "utility")) {
		if (getupsvar(monhost, "utility", val, sizeof(val)) < 0)
			noimage();

		/* these are not showstoppers */
		if (getupsvar(monhost, "highxfer", highxfer, sizeof(highxfer)) < 0)
			strncpy(highxfer, "0", 1);

		if (getupsvar(monhost, "lowxfer", lowxfer, sizeof(lowxfer)) < 0)
			strncpy(lowxfer, "0", 1);

		drawutility(val, atoi(highxfer), atoi(lowxfer));
	}

	printf("Content-type: text/plain\n\n");
	printf("Invalid request!\n");

	return 0;
}
