/* upscmd - simple "client" to test instant commands via upsd

   Copyright (C) 2000  Russell Kroll <rkroll@exploits.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#include "common.h"

#include <netdb.h>
#include <netinet/in.h>
#include <sys/socket.h>

#include "upsfetch.h"

	int	fd;

void usage(char *prog)
{
	printf("Network UPS Tools upscmd %s\n\n", UPS_VERSION);
	printf("usage: %s [-h]\n", prog);
	printf("       %s [-l <ups>]\n", prog);
	printf("       %s [-u <username>] [-p <password>] <ups> <command>\n\n", prog);
	printf("Administration program to initiate instant commands on UPS hardware.\n");
	printf("\n");
	printf("  -h		display this help text\n");
	printf("  -l <ups>	show available commands on UPS <ups>\n");
	printf("  -u <username>	set username for command authentication\n");
	printf("  -p <password>	set password for command authentication\n");
	printf("\n");
	printf("  <ups>		UPS identifier - myups@localhost, etc.\n");
	printf("  <command>	Valid instant command - FPTEST, BTEST1, etc.\n");
	exit(1);
}

void listvars(char *rawname)
{
	char	buf[SMALLBUF], buf2[SMALLBUF], *ptr, *upsname, *host, *tmp, *savename,
		*q, *desc;

	savename = xstrdup(rawname);

	/* handle upsname@hostname syntax and split up parts */
	ptr = strchr(rawname, '@');
	if (ptr != NULL) {
		*ptr = '\0';
		upsname = rawname;
		host = ptr + 1;
	}
	else {
		upsname = NULL;
		host = rawname;
	}

	fd = upsconnect(host);
	if (fd < 0) {
		printf("Unable to connect to %s - %s\n", host,
		       upsstrerror(upserror));
		exit(1);
	}

	if (upsname)
		snprintf(buf, sizeof(buf), "LISTINSTCMD %s\n", upsname);
	else
		snprintf(buf, sizeof(buf), "LISTINSTCMD\n");

	if (upssendraw(fd, buf) < 0) {
		printf("Can't list instant commands: %s\n",
		       upsstrerror(upserror));
		exit(1);
	}

	if (upsreadraw(fd, buf, sizeof(buf)) < 0) {
		printf("List instant commands failed: %s\n", 
		       upsstrerror(upserror));
		exit(1);
	}
	
	if (strncmp("INSTCMDS", buf, 7)) {
		printf("Invalid response from server: %s", buf);
		exit(1);
	}

	/* INSTCMDS <cmd1> <cmd2> ... <cmdn> */

	/* point at first instant command */
	ptr = strchr(buf, ' ');

	if (!ptr) {
		printf("No instant commands are supported on UPS [%s]\n",
		       savename);
		exit(0);
	}

	ptr++;

	/* INSTCMDS <@ups> ... - may skip another word */
	if (ptr[0] == '@') {
		ptr = strchr(ptr, ' ');
		if (!ptr) {
			printf("No instant commands found on this UPS!\n");
			exit(0);
		}
		ptr++;
	}

	printf("Instant commands supported on UPS [%s]:\n\n", savename);

	while (ptr) {
		tmp = ptr;
		ptr = strchr(tmp, ' ');
		if (ptr) {
			*ptr = '\0';
			ptr++;
		}

		printf("%s - ", tmp);

		/* now get description for this command */

		snprintf(buf2, sizeof(buf2), "INSTCMDDESC %s\n", tmp);

		if (upssendraw(fd, buf2) < 0) {
			printf("Description fetch failed: %s\n", 
			       upsstrerror(upserror));
			continue;
		}

		if (upsreadraw(fd, buf2, sizeof(buf2)) < 0) {
			printf("Description fetch failed: %s\n", 
			       upsstrerror(upserror));
			continue;
		}

		q = strchr(buf2, '"');
		if (!q) {
			printf ("Invalid description received from server (1)\n");
			continue;
		}

		desc = ++q;
		q = strchr(desc, '"');
		if (!q) {
			printf("Invalid description received from server (2)\n");
			continue;
		}

		*q = '\0';
		printf("%s\n", desc);
	}

	exit(0);
}

int main(int argc, char **argv)
{
	char	*upsname, *ptr, *host, *prog, buf[SMALLBUF], 
		*password = NULL, *username = NULL;
	int	i, ret;

	prog = argv[0];

	while ((i = getopt(argc, argv, "+l:hu:p:")) != EOF) {
		switch (i) {
			case 'l':
				listvars(optarg);
				break;
			case 'u':
				username = optarg;
				break;
			case 'p':
				password = optarg;
				break;			
			case 'h':
			default:
				usage(prog);
				break;
		}
	}

	argc -= optind;
	argv += optind;

	if (argc < 2)
		usage(prog);

	/* handle upsname@hostname syntax and split up parts */
	ptr = strstr(argv[0], "@");
	if (ptr != NULL) {
		ptr[0] = 0;
		upsname = argv[0];
		host = ptr + 1;
	}
	else {
		upsname = NULL;
		host = argv[0];
	}

	fd = upsconnect(host);
	if (fd < 0) {
		printf("Unable to connect to %s - %s\n", host,
		        upsstrerror(upserror));
		exit(1);
	}

	if (!username) {
		printf("Username: ");
		username = xmalloc(SMALLBUF);
		fgets(username, SMALLBUF, stdin);

		/* deal with that pesky newline */
		if (strlen(username) > 1)
			username[strlen(username) - 1] = '\0';
	}

	if (!password)
		password = getpass("Password: ");

	snprintf(buf, sizeof(buf), "USERNAME %s\n", username);

	if (upssendraw(fd, buf) < 0) {
		printf("Can't set username: %s\n", upsstrerror(upserror));
		exit(1);
	}

	ret = upsreadraw(fd, buf, sizeof(buf));

	if (ret < 0) {
		if (upserror == UPSF_UNKNOWNCMD) {
			printf("Set username failed due to an unknown command.\n");
			printf("You probably need to upgrade upsd.\n");
			exit(1);
		}

		printf("Set username failed: %s\n", upsstrerror(upserror));
		exit(1);
	}

	snprintf(buf, sizeof(buf), "PASSWORD %s\n", password);

	if (upssendraw(fd, buf) < 0) {
		printf("Can't set password: %s\n", upsstrerror(upserror));
		exit(1);
	}

	if (upsreadraw(fd, buf, sizeof(buf)) < 0) {
		printf("Set password failed: %s\n", upsstrerror(upserror));
		exit(1);
	}

	if (upsname)
		snprintf(buf, sizeof(buf), "INSTCMD %s@%s\n", argv[1], 
		         upsname);
	else
		snprintf(buf, sizeof(buf), "INSTCMD %s\n", argv[1]);

	if (upssendraw(fd, buf) < 0) {
		printf("Can't send instant command: %s\n",
			upsstrerror(upserror));
		exit(1);
	}

	if (upsreadraw(fd, buf, sizeof(buf)) < 0) {
		printf("Instant command failed: %s\n", upsstrerror(upserror));
		exit(1);
	}
	
	return 0;
}
