# -*- coding: utf-8 -*-

"""
Copyright(C) 2007 INL
Written by Romain Bignon <romain AT inl.fr>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, version 3 of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.


$Id: auth.py 11871 2007-12-31 15:09:38Z romain $
"""

from nucentral.core import LoadError
from nucentral.client import Service
import os
import codecs
from twisted.python import log

class Params:

    #################
    #   UserParam   #
    #################

    class UserParam:

        def __init__(self, username, auth_dir):

            self.username = username
            self.params = {}
            self.userdir = auth_dir + username + '/'

        def write(self):
            """ Write datas to disk. """
            try:
                os.makedirs(self.userdir)
            except OSError, O:
                pass

            for modulename, params in self.params.items():

                try:
                    modfile = codecs.open(self.userdir + modulename, 'w', 'utf-8')

                    for key, value in params.items():
                        if value is None:
                            modfile.write('%s\n' % key)
                        else:
                            modfile.write('%s %s\n' % (key, value))
                except OSError, O:
                    log.error('Error: Unable to write in %s: %s' % (self.userdir, str(O)))

        def load(self):

            # Return the list of files (and directories, but there isn't)
            for filename in os.listdir(self.userdir):

                try:
                    f = codecs.open(self.userdir + '/' + filename, 'r', 'utf-8')

                    for line in f.readlines():
                        # Split string by words.
                        # Note that it removes the last \n char.
                        line = line.split()

                        if not line or line[0][0] == '#':
                            # Blank line or comment.
                            continue

                        if not self.params.has_key(filename):
                            self.params[filename] = dict()

                        if len(line) > 1:
                            try:
                                self.params[filename][str(line[0])] = str(' '.join(line[1:]))
                            except UnicodeEncodeError:
                                self.params[filename][str(line[0])] = u' '.join(line[1:])
                        else:
                            self.params[filename][str(line[0])] = None

                except OSError, O:
                    # This isn't a file or a problem like this.
                    # We ignore it because we don't care about.
		    log.warning( "An error occurred in UserParam.load %s: %s" % (self.userdir + '/' + filename, O) )
                    pass

    #################

    def __init__(self, var_dir):

        self.mod_dir = var_dir + '/auth/'
        self._users = {}

    def getParams(self, username, module):
        """ Exported function to get params from an user.
            @param username [string] name of user
            @param module [string] module name
            @return [dict] params
        """

        try:
            return self._users[username].params[module]
        except Exception, e:
            try:
                return self._users['default'].params[module]
            except:
                return {}

    def setParams(self, username, module, params):
        """ Exported function to set params to an user.
            @param username [string] name of user
            @param module [string] name of module
            @param params [dict] dictionnary of parameters
        """

        if not isinstance(params, dict):
            raise Exception("Please give a dictionnary as 'params' argument")

        if not self._users.has_key(username):
            self._users[username] = Params.UserParam(username, self.mod_dir)

        self._users[username].params[module] = params
        self._users[username].write()

    def load(self):
        """ Load from files all user settings. """

        try:
            os.makedirs(self.mod_dir)
        except OSError, O:
            # We can't create directory, but if it exists already
            # we don't care about.
            pass

        try:
            for username in os.listdir(self.mod_dir):

                try:
                    self._users[username] = Params.UserParam(username, self.mod_dir)
                    self._users[username].load()
                except Exception, e:
                    # Unable to load datas, I think this is because it wasn't a directory or
                    # a valid user directory...
		    log.warning( "An error occurred in Params.load %s: %s" % (username, e) )
                    if self._users.has_key(username):
                        self._users.pop(username)
        except OSError, O:
            # I can read files in directory because it doesn't exist.
            # I've tried to create it, and it failed.
            # So we go out.
            raise LoadError('Unable to read %s. Please create it. (%s)' % (self.mod_dir, O))

    def write(self):
        """ Store all params. """

        for name, user in self._users.items():
            user.write()

def getComponentName():
    return "auth"

def getSyncServiceList():

    params = Params(Service.core.var_dir)
    params.load()

    services = dict()
    services['login'] = lambda *args: False # We define a pseudo function which return ALWAYS FALSE.
    services['getParams'] = params.getParams
    services['setParams'] = params.setParams

    return services

