/*
 * -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 * gnuline.c - Interface to the GNU Readline Library version 2.2.
 *
 * Luca Deri     <deri@ntop.org>
 * Rocco Carbone <rocco@ntop.org>
 * -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


/*
 * Ntop main configuration file
 * automatically generated at configuration time
 */
#include "config.h"


/*
 * operating system header file(s)
 * [do not forget to include stdio.h before using GNU Readline]
 */
#include <stdio.h>
#include <stdlib.h>
#include <strings.h>

#if defined(HAVE_READLINE)
# include "readline/history.h"
/* the following definition allows to eliminate a warning on Solaris 2.6 */
# define __FUNCTION_DEF
# include "readline/readline.h"

char * command_by_index (int i);
char ** completion (char * text, int start, int end);

void initialize_gnu_readline (char * prompt);
int history (int argc, char * argv []);


/*
 * Generator function for command completion.
 * STATE lets us know whether to start from scratch;
 * without any state (i.e. STATE == 0), then we
 * start at the top of the list
 */
static char * command_generator (char * text, int state)
{
  static int list_index = 0;
  static int len = 0;

  char * name;

  /*
   * If this is a new word to complete, initialize now.
   * This includes saving the length of TEXT for efficiency,
   * and initializing the index variable to 0
   */
  if (! state)
    {
      list_index = 0;
      len = strlen (text);
    }
  
  /*
   * Return the next name which partially matches from the command list
   */
  while ((name = command_by_index (list_index)))
    {
      list_index ++;
      if (strncmp (name, text, len) == 0)
	return (strdup (name));
    }

  /*
   * If no names matched, then return NULL
   */
  return ((char *) NULL);
}


/*
 * Attempt to complete on the contents of TEXT.
 * START and END show the region of TEXT that contains
 * the word to complete. We can use the entire line
 * in case we want to do some simple parsing.
 * Return the array of matches, or NULL if there aren't any
 */
char ** completion (char * text, int start, int end)
{
  char ** matches = (char **) NULL;

  /*
   * If this word is at the start of the line, then it is a command
   * to complete. Otherwise it is the name of a file in the current
   * directory
   */
  if (start == 0)
    matches = completion_matches (text, command_generator);

  return (matches);
}


/*
 * Tell the GNU Readline library how to complete.
 * We want to try to complete on command names if this is
 * the first word in the line, or on filenames if not
 */
void initialize_gnu_readline (char * prompt)
{
  /*
   * Allow conditional parsing of the ~/.inputrc file.
   */
  rl_readline_name = prompt;

  /*
   * Tell the completer that we want a crack first
   */
  rl_attempted_completion_function = completion;
}


/*
 * The History function
 */
int history (int argc, char * argv [])
{
  register HIST_ENTRY ** the_list = history_list ();
  register int i;

  if (the_list)
    for (i = 0; the_list [i]; i ++)
      printf ("%d: %s\n", i + history_base, the_list [i] -> line);

  return (0);
}

#endif /* HAVE_READLINE */
