/* Copyright (C) (2001) (Antonio SJ Musumeci) <bile_@hotmail.com>
   
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2 
    of the License, or (at your option) any later version.
   
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
   
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "ntaim.h"

extern char *command_list[];
extern int commandnum;
extern WINDOW *chat_win;
extern color_pref colors;

/* puts a tard tip on the screen or removes a tard tip from the screen */
void handle_tard_tips(char *input_string, int currpos, unsigned short action)
{
  unsigned short i;
  char *currstr;
  static unsigned short tard_tip_length;
         
  switch(action)
    {
    case TARDTIPCREATE:
      if (input_string[0] != '/') /* make sure we are dealing with a command */
	break;
      input_string[currpos] = '\0';
      tard_tip_length = 0;
      for (i = 0; i < commandnum; i++)
	{
	   currstr = command_list[i];
	   if (!strcmp(input_string, currstr))
	    {
	      currstr += strlen(currstr) + 1;
	      wattrset(chat_win, CP(colors.tardfore, colors.tardback));
	      wprintw(chat_win, " %s", currstr);
	      wattrset(chat_win, CP(colors.chatfore, colors.chatback));
	      tard_tip_length = strlen(currstr) + 1;
	      break;
	    }
	}
      break;
    case TARDTIPDESTROY:
      if (tard_tip_length)
	{
	  for (i = 0; i < tard_tip_length; i++)
	    wprintw(chat_win, "\b \b");
	  tard_tip_length = 0;
	}
      break;
    };
  wrefresh(chat_win);
  return;
}
                                                                                                                                                                                                                                                                                                                                                                        
