/* Copyright (C) (2001) (Antonio SJ Musumeci) <bile_@hotmail.com>
   
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2 
    of the License, or (at your option) any later version.
   
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
   
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "ntaim.h"

extern char username[];
extern char ntaim_path[];

int log_message(char *who, char *message, unsigned short send_recv)
{
   char tbuff[64];
   struct tm *time_info;
   time_t time_value;
   
   int fd;
   char path[PATHSIZE];
   
   strcpy(path, ntaim_path);
   strcat(path, "/logs/");
   strcat(path, username);
   strcat(path, "/");
   strcat(path, who);
   strcat(path, ".log\0");
   
   fd = open(path, O_WRONLY|O_CREAT|O_APPEND, 0644);
   
   if(fd < 0)
     {
	switch(errno)
	  {
	   case EACCES:
	     alert("could not open log file, permission denied.");
	     return 1;
	     break;
	     
	   default:
	     path_init();
	     strcpy(path, ntaim_path);
	     strcat(path, "/logs/");
	     if(mkdir(path, DOTTAIMPERM) && errno != EEXIST)
	       {
		  alert("error attempting to create logging directory!");
		  return 1;
	       }
	     strcat(path, username);
	     strcat(path, "/");
	     if(mkdir(path, DOTTAIMPERM) && errno != EEXIST)
	       {
		  alert("error attempting to create logging username directory!");
		  return 1;
	       }
	     strcat(path, who);
	     strcat(path, ".log");
	     fd = open(path, O_WRONLY|O_CREAT|O_APPEND, 0644);
	     if(fd < 0)
	       {
		  alert("could not create log file.");
		  return 1;
	       }
	  }
     }
   
   time_value = time(NULL);
   time_info = localtime(&time_value);
   strftime(tbuff, 30, "%x %X", time_info);
   
   write(fd, "[", 1);
   write(fd, tbuff, strlen(tbuff));
   write(fd, "] ", 2);

   if(send_recv == SEND)
     {
	strcpy(tbuff, username);
	write(fd, tbuff, strlen(tbuff));
     }
   else if(send_recv == RECIEVE)
     write(fd, who, strlen(who));
     
   write(fd, ": ", 2);
   write(fd, message, strlen(message));
   write(fd, "\n", 1);
   
   close(fd);
   return 0;
}

int log_room_message(char *room, char *from, char *message)
{
   char tbuff[64];
   struct tm *time_info;
   time_t time_value;
   
   int fd;
   char path[PATHSIZE];
   
   strcpy(path, ntaim_path);
   strcat(path, "/logs/");
   strcat(path, username);
   strcat(path, "/");
   strcat(path, room);
   strcat(path, ".log\0");
   
   fd = open(path, O_WRONLY|O_CREAT|O_APPEND, 0644);
   
   if(fd < 0)
     {
	switch(errno)
	  {
	   case EACCES:
	     alert("could not open log file, permission denied.");
	     return 1;
	     break;
	     
	   default:
	     path_init();
	     strcpy(path, ntaim_path);
	     strcat(path, "/logs/");
	     strcat(path, username);
	     if(mkdir(path, DOTTAIMPERM))
	       {
		  alert("error attempting to create logging directory!");
		  return 1;
	       }
	     strcat(path, "/");
	     strcat(path, room);
	     strcat(path, ".log");
	     fd = open(path, O_WRONLY|O_CREAT|O_APPEND, 0644);
	     if(fd < 0)
	       {
		  alert("could not create log file.");
		  return 1;
	       }
	  }
     }
   
   time_value = time(NULL);
   time_info = localtime(&time_value);
   strftime(tbuff, 30, "%x %X", time_info);
   
   write(fd, "[", 1);
   write(fd, tbuff, strlen(tbuff));
   write(fd, "] ", 2);

   write(fd, from, strlen(from));

   write(fd, ": ", 2);
   write(fd, message, strlen(message));
   write(fd, "\n", 1);
   
   close(fd);
   return 0;
}
